/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor.cassandra;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.NameUtils;
import ru.tinkoff.kora.database.annotation.processor.DbEntityReadHelper;
import ru.tinkoff.kora.database.annotation.processor.cassandra.CassandraNativeType;
import ru.tinkoff.kora.database.annotation.processor.cassandra.CassandraNativeTypes;
import ru.tinkoff.kora.database.annotation.processor.cassandra.CassandraTypes;
import ru.tinkoff.kora.database.annotation.processor.cassandra.extension.CassandraTypesExtension;
import ru.tinkoff.kora.database.annotation.processor.entity.DbEntity;

public class CassandraEntityGenerator {
    private final Elements elements;
    private final Filer filer;
    private final DbEntityReadHelper rowMapperGenerator;

    public CassandraEntityGenerator(Types types, Elements elements, Filer filer) {
        this.elements = elements;
        this.filer = filer;
        this.rowMapperGenerator = new DbEntityReadHelper(CassandraTypes.RESULT_COLUMN_MAPPER, types, fd -> CodeBlock.of((String)"this.$L.apply(_row, _idx_$L)", (Object[])new Object[]{fd.mapperFieldName(), fd.fieldName()}), fd -> {
            CassandraNativeType nativeType = CassandraNativeTypes.findNativeType(TypeName.get((TypeMirror)fd.type()));
            if (nativeType != null) {
                return nativeType.extract("_row", CodeBlock.of((String)"_idx_$L", (Object[])new Object[]{fd.fieldName()}));
            }
            return null;
        }, fd -> CodeBlock.builder().beginControlFlow("if (_row.isNull(_idx_$L))", new Object[]{fd.fieldName()}).add(fd.nullable() ? CodeBlock.of((String)"$N = null;\n", (Object[])new Object[]{fd.fieldName()}) : CodeBlock.of((String)"throw new $T($S);\n", (Object[])new Object[]{NullPointerException.class, "Result field %s is not nullable but row %s has null".formatted(fd.fieldName(), fd.columnName())})).endControlFlow().build());
    }

    public void generateRowMapper(DbEntity entity) throws IOException {
        ClassName mapperName = this.rowMapperName(entity.typeElement());
        PackageElement packageElement = this.elements.getPackageOf(entity.typeElement());
        TypeSpec.Builder type = TypeSpec.classBuilder((ClassName)mapperName).addOriginatingElement((Element)entity.typeElement()).addAnnotation(AnnotationUtils.generated(CassandraTypesExtension.class)).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)CassandraTypes.ROW_MAPPER, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)entity.typeMirror())})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        MethodSpec.Builder apply = MethodSpec.methodBuilder((String)"apply").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter((TypeName)CassandraTypes.ROW, "_row", new Modifier[0]).returns(TypeName.get((TypeMirror)entity.typeMirror()));
        DbEntityReadHelper.ReadEntityCodeBlock read = this.rowMapperGenerator.readEntity("_result", entity);
        read.enrich(type, constructor);
        for (DbEntity.Column field : entity.columns()) {
            apply.addCode("var _idx_$L = _row.firstIndexOf($S);\n", new Object[]{field.variableName(), field.columnName()});
        }
        apply.addCode(read.block());
        apply.addCode("return _result;\n", new Object[0]);
        type.addMethod(constructor.build());
        type.addMethod(apply.build());
        JavaFile.builder((String)packageElement.getQualifiedName().toString(), (TypeSpec)type.build()).build().writeTo(this.filer);
    }

    public void generateResultSetMapper(DbEntity entity) throws IOException {
        TypeElement rowTypeElement = entity.typeElement();
        PackageElement packageElement = this.elements.getPackageOf(rowTypeElement);
        ClassName mapperName = this.resultSetMapperName(rowTypeElement);
        TypeName rowTypeName = TypeName.get((TypeMirror)entity.typeMirror());
        TypeSpec.Builder type = TypeSpec.classBuilder((ClassName)mapperName).addOriginatingElement((Element)entity.typeElement()).addAnnotation(AnnotationUtils.generated(CassandraTypesExtension.class)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)CassandraTypes.RESULT_SET_MAPPER, (TypeName[])new TypeName[]{rowTypeName}));
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        MethodSpec.Builder apply = MethodSpec.methodBuilder((String)"apply").addAnnotation(Override.class).addAnnotation(CommonClassNames.nullable).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns(rowTypeName).addParameter((TypeName)CassandraTypes.RESULT_SET, "_rs", new Modifier[0]);
        apply.addStatement("var _it = _rs.iterator()", new Object[0]);
        apply.beginControlFlow("if (!_it.hasNext())", new Object[0]);
        apply.addStatement("return null", new Object[0]);
        apply.endControlFlow();
        for (DbEntity.Column field : entity.columns()) {
            apply.addCode("var _idx_$L = _rs.getColumnDefinitions().firstIndexOf($S);\n", new Object[]{field.variableName(), field.columnName()});
        }
        apply.addStatement("var _row = _it.next()", new Object[0]);
        DbEntityReadHelper.ReadEntityCodeBlock read = this.rowMapperGenerator.readEntity("_result", entity);
        read.enrich(type, constructor);
        apply.addCode(read.block());
        apply.addCode("return _result;\n", new Object[0]);
        TypeSpec typeSpec = type.addMethod(apply.build()).addMethod(constructor.build()).build();
        JavaFile.builder((String)packageElement.getQualifiedName().toString(), (TypeSpec)typeSpec).build().writeTo(this.filer);
    }

    public void generateListResultSetMapper(DbEntity entity) throws IOException {
        TypeElement rowTypeElement = entity.typeElement();
        PackageElement packageElement = this.elements.getPackageOf(rowTypeElement);
        ClassName mapperName = this.listResultSetMapperName(rowTypeElement);
        ParameterizedTypeName listType = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)entity.typeMirror())});
        TypeSpec.Builder type = TypeSpec.classBuilder((ClassName)mapperName).addOriginatingElement((Element)entity.typeElement()).addAnnotation(AnnotationUtils.generated(CassandraTypesExtension.class)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)CassandraTypes.RESULT_SET_MAPPER, (TypeName[])new TypeName[]{listType}));
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        MethodSpec.Builder apply = MethodSpec.methodBuilder((String)"apply").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns((TypeName)listType).addParameter((TypeName)CassandraTypes.RESULT_SET, "_rs", new Modifier[0]);
        DbEntityReadHelper.ReadEntityCodeBlock read = this.rowMapperGenerator.readEntity("_rowValue", entity);
        read.enrich(type, constructor);
        for (DbEntity.Column field : entity.columns()) {
            apply.addCode("var _idx_$L = _rs.getColumnDefinitions().firstIndexOf($S);\n", new Object[]{field.variableName(), field.columnName()});
        }
        apply.addCode("var _result = new $T<$T>(_rs.getAvailableWithoutFetching());\n", new Object[]{ArrayList.class, entity.typeMirror()});
        apply.beginControlFlow("for (var _row : _rs)", new Object[0]);
        apply.addCode(read.block());
        apply.addCode("_result.add(_rowValue);\n", new Object[0]);
        apply.endControlFlow();
        apply.addCode("return _result;\n", new Object[0]);
        TypeSpec typeSpec = type.addMethod(apply.build()).addMethod(constructor.build()).build();
        JavaFile.builder((String)packageElement.getQualifiedName().toString(), (TypeSpec)typeSpec).build().writeTo(this.filer);
    }

    public ClassName rowMapperName(Element rowTypeElement) {
        PackageElement packageElement = this.elements.getPackageOf(rowTypeElement);
        return ClassName.get((String)packageElement.getQualifiedName().toString(), (String)NameUtils.generatedType((Element)rowTypeElement, (ClassName)CassandraTypes.ROW_MAPPER), (String[])new String[0]);
    }

    public ClassName resultSetMapperName(Element rowTypeElement) {
        PackageElement packageElement = this.elements.getPackageOf(rowTypeElement);
        return ClassName.get((String)packageElement.getQualifiedName().toString(), (String)NameUtils.generatedType((Element)rowTypeElement, (ClassName)CassandraTypes.RESULT_SET_MAPPER), (String[])new String[0]);
    }

    public ClassName listResultSetMapperName(Element rowTypeElement) {
        PackageElement packageElement = this.elements.getPackageOf(rowTypeElement);
        return ClassName.get((String)packageElement.getQualifiedName().toString(), (String)NameUtils.generatedType((Element)rowTypeElement, (String)"ListCassandraResultSetMapper"), (String[])new String[0]);
    }
}

