/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor.cassandra;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import ru.tinkoff.kora.database.annotation.processor.cassandra.CassandraNativeType;

public class CassandraNativeTypes {
    private static final List<CassandraNativeType> nativeTypes;

    @Nullable
    public static CassandraNativeType findNativeType(TypeName typeName) {
        for (CassandraNativeType nativeParameterType : nativeTypes) {
            if (!Objects.equals(nativeParameterType.type(), typeName)) continue;
            return nativeParameterType;
        }
        return null;
    }

    static {
        CassandraNativeType booleanPrimitive = CassandraNativeType.of(TypeName.BOOLEAN, (rsName, i) -> CodeBlock.of((String)"$L.getBoolean($L)", (Object[])new Object[]{rsName, i}), (stmt, var, i) -> CodeBlock.of((String)"$L.setBoolean($L, $L)", (Object[])new Object[]{stmt, i, var}));
        CassandraNativeType booleanBoxed = booleanPrimitive.boxed();
        CassandraNativeType shortPrimitive = CassandraNativeType.of(TypeName.SHORT, (rsName, i) -> CodeBlock.of((String)"$L.getShort($L)", (Object[])new Object[]{rsName, i}), (stmt, var, i) -> CodeBlock.of((String)"$L.setShort($L, $L)", (Object[])new Object[]{stmt, i, var}));
        CassandraNativeType shortBoxed = shortPrimitive.boxed();
        CassandraNativeType intPrimitive = CassandraNativeType.of(TypeName.INT, (rsName, i) -> CodeBlock.of((String)"$L.getInt($L)", (Object[])new Object[]{rsName, i}), (stmt, var, i) -> CodeBlock.of((String)"$L.setInt($L, $L)", (Object[])new Object[]{stmt, i, var}));
        CassandraNativeType intBoxed = intPrimitive.boxed();
        CassandraNativeType longPrimitive = CassandraNativeType.of(TypeName.LONG, (rsName, i) -> CodeBlock.of((String)"$L.getLong($L)", (Object[])new Object[]{rsName, i}), (stmt, var, i) -> CodeBlock.of((String)"$L.setLong($L, $L)", (Object[])new Object[]{stmt, i, var}));
        CassandraNativeType longBoxed = longPrimitive.boxed();
        CassandraNativeType doublePrimitive = CassandraNativeType.of(TypeName.DOUBLE, (rsName, i) -> CodeBlock.of((String)"$L.getDouble($L)", (Object[])new Object[]{rsName, i}), (stmt, var, i) -> CodeBlock.of((String)"$L.setDouble($L, $L)", (Object[])new Object[]{stmt, i, var}));
        CassandraNativeType doubleBoxed = doublePrimitive.boxed();
        CassandraNativeType floatPrimitive = CassandraNativeType.of(TypeName.FLOAT, (rsName, i) -> CodeBlock.of((String)"$L.getFloat($L)", (Object[])new Object[]{rsName, i}), (stmt, var, i) -> CodeBlock.of((String)"$L.setFloat($L, $L)", (Object[])new Object[]{stmt, i, var}));
        CassandraNativeType floatBoxed = floatPrimitive.boxed();
        CassandraNativeType string = CassandraNativeType.of((TypeName)ClassName.get(String.class), (rsName, i) -> CodeBlock.of((String)"$L.getString($L)", (Object[])new Object[]{rsName, i}), (stmt, var, i) -> CodeBlock.of((String)"$L.setString($L, $L)", (Object[])new Object[]{stmt, i, var}));
        CassandraNativeType bigDecimal = CassandraNativeType.of((TypeName)ClassName.get(BigDecimal.class), (rsName, i) -> CodeBlock.of((String)"$L.getBigDecimal($L)", (Object[])new Object[]{rsName, i}), (stmt, var, i) -> CodeBlock.of((String)"$L.setBigDecimal($L, $L)", (Object[])new Object[]{stmt, i, var}));
        CassandraNativeType byteBuffer = CassandraNativeType.of((TypeName)ClassName.get(ByteBuffer.class), (rsName, i) -> CodeBlock.of((String)"$L.getByteBuffer($L)", (Object[])new Object[]{rsName, i}), (stmt, var, i) -> CodeBlock.of((String)"$L.setByteBuffer($L, $L)", (Object[])new Object[]{stmt, i, var}));
        CassandraNativeType localDateTime = CassandraNativeType.of(TypeName.get(LocalDateTime.class), (rsName, i) -> CodeBlock.of((String)"$L.get($L, $T.class)", (Object[])new Object[]{rsName, i, LocalDateTime.class}), (stmt, var, i) -> CodeBlock.of((String)"$L.set($L, $L, $T.class)", (Object[])new Object[]{stmt, i, var, LocalDateTime.class}));
        CassandraNativeType localDate = CassandraNativeType.of(TypeName.get(LocalDate.class), (rsName, i) -> CodeBlock.of((String)"$L.getLocalDate($L)", (Object[])new Object[]{rsName, i}), (stmt, var, i) -> CodeBlock.of((String)"$L.setLocalDate($L, $L)", (Object[])new Object[]{stmt, i, var}));
        CassandraNativeType instant = CassandraNativeType.of(TypeName.get(Instant.class), (rsName, i) -> CodeBlock.of((String)"$L.getInstant($L)", (Object[])new Object[]{rsName, i}), (stmt, var, i) -> CodeBlock.of((String)"$L.setInstant($L, $L)", (Object[])new Object[]{stmt, i, var}));
        CassandraNativeType localTime = CassandraNativeType.of(TypeName.get(LocalTime.class), (rsName, i) -> CodeBlock.of((String)"$L.getLocalTime($L)", (Object[])new Object[]{rsName, i}), (stmt, var, i) -> CodeBlock.of((String)"$L.setLocalTime($L, $L)", (Object[])new Object[]{stmt, i, var}));
        CassandraNativeType zonedDateTime = CassandraNativeType.of(TypeName.get(ZonedDateTime.class), (rsName, i) -> CodeBlock.of((String)"$L.get($L, $T.class)", (Object[])new Object[]{rsName, i, ZonedDateTime.class}), (stmt, var, i) -> CodeBlock.of((String)"$L.set($L, $L, $T.class)", (Object[])new Object[]{stmt, i, var, ZonedDateTime.class}));
        nativeTypes = List.of(booleanPrimitive, booleanBoxed, shortPrimitive, shortBoxed, intPrimitive, intBoxed, longPrimitive, longBoxed, doublePrimitive, doubleBoxed, floatPrimitive, floatBoxed, string, bigDecimal, byteBuffer, localDateTime, localDate, instant, localTime, zonedDateTime);
    }
}

