/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor.cassandra;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import jakarta.annotation.Nullable;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.FieldFactory;
import ru.tinkoff.kora.annotation.processor.common.Visitors;
import ru.tinkoff.kora.database.annotation.processor.DbUtils;
import ru.tinkoff.kora.database.annotation.processor.QueryWithParameters;
import ru.tinkoff.kora.database.annotation.processor.RepositoryGenerator;
import ru.tinkoff.kora.database.annotation.processor.cassandra.CassandraNativeTypes;
import ru.tinkoff.kora.database.annotation.processor.cassandra.CassandraTypes;
import ru.tinkoff.kora.database.annotation.processor.cassandra.StatementSetterGenerator;
import ru.tinkoff.kora.database.annotation.processor.model.QueryParameter;
import ru.tinkoff.kora.database.annotation.processor.model.QueryParameterParser;

public class CassandraRepositoryGenerator
implements RepositoryGenerator {
    private final Types types;
    private final Elements elements;
    private final Filer filer;

    public CassandraRepositoryGenerator(ProcessingEnvironment processingEnv) {
        this.types = processingEnv.getTypeUtils();
        this.elements = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
    }

    @Override
    public ClassName repositoryInterface() {
        return CassandraTypes.REPOSITORY;
    }

    @Override
    public TypeSpec generate(TypeElement repositoryElement, TypeSpec.Builder type, MethodSpec.Builder constructor) {
        DeclaredType repositoryType = (DeclaredType)repositoryElement.asType();
        List<ExecutableElement> queryMethods = DbUtils.findQueryMethods(this.types, this.elements, repositoryElement);
        this.enrichWithExecutor(repositoryElement, type, constructor);
        FieldFactory resultMappers = new FieldFactory(this.types, this.elements, type, constructor, "_result_mapper_");
        FieldFactory parameterMappers = new FieldFactory(this.types, this.elements, type, constructor, "_parameter_mapper_");
        int methodCounter = 1;
        for (ExecutableElement method : queryMethods) {
            ExecutableType methodType = (ExecutableType)this.types.asMemberOf(repositoryType, method);
            List<QueryParameter> parameters = QueryParameterParser.parse(this.types, CassandraTypes.CONNECTION, CassandraTypes.PARAMETER_COLUMN_MAPPER, method, methodType);
            AnnotationMirror queryAnnotation = AnnotationUtils.findAnnotation((Element)method, (ClassName)DbUtils.QUERY_ANNOTATION);
            String queryString = (String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)queryAnnotation, (String)"value");
            QueryWithParameters query = QueryWithParameters.parse(this.filer, this.types, queryString, parameters, repositoryType, method);
            String resultMapperName = this.parseResultMapper(method, parameters, methodType).map(rm -> DbUtils.addMapper(resultMappers, rm)).orElse(null);
            DbUtils.addMappers(parameterMappers, DbUtils.parseParameterMappers(parameters, query, tn -> CassandraNativeTypes.findNativeType(tn) != null, CassandraTypes.PARAMETER_COLUMN_MAPPER));
            MethodSpec methodSpec = this.generate(type, methodCounter, method, methodType, query, parameters, resultMapperName, parameterMappers);
            type.addMethod(methodSpec);
            ++methodCounter;
        }
        return type.addMethod(constructor.build()).build();
    }

    private MethodSpec generate(TypeSpec.Builder type, int methodNumber, ExecutableElement method, ExecutableType methodType, QueryWithParameters query, List<QueryParameter> parameters, @Nullable String resultMapperName, FieldFactory parameterMappers) {
        String sql = query.rawQuery();
        for (QueryWithParameters.QueryParameter parameter : query.parameters().stream().sorted(Comparator.comparing(p -> p.sqlParameterName().length()).reversed()).toList()) {
            sql = sql.replace(":" + parameter.sqlParameterName(), "?");
        }
        MethodSpec.Builder b = DbUtils.queryMethodBuilder(method, methodType);
        String queryContextFieldName = "QUERY_CONTEXT_" + methodNumber;
        type.addField(FieldSpec.builder((TypeName)DbUtils.QUERY_CONTEXT, (String)queryContextFieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("new $T(\n      $S,\n      $S,\n      $S\n    )", new Object[]{DbUtils.QUERY_CONTEXT, query.rawQuery(), sql, DbUtils.operationName(method)}).build());
        b.addStatement("var _query = $L", new Object[]{queryContextFieldName});
        QueryParameter batchParam = parameters.stream().filter(QueryParameter.BatchParameter.class::isInstance).findFirst().orElse(null);
        String profile = null;
        AnnotationMirror profileAnnotation = AnnotationUtils.findAnnotation((Element)method, (ClassName)CassandraTypes.CASSANDRA_PROFILE);
        if (profileAnnotation != null) {
            profile = (String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)profileAnnotation, (String)"value");
        }
        TypeMirror returnType = methodType.getReturnType();
        boolean isFlux = CommonUtils.isFlux((TypeMirror)returnType);
        boolean isMono = CommonUtils.isMono((TypeMirror)returnType);
        boolean isFuture = CommonUtils.isFuture((TypeMirror)returnType);
        if (isMono || isFlux) {
            b.addCode("return ", new Object[0]);
            b.beginControlFlow("$T.deferContextual(_reactorCtx ->", new Object[]{isFlux ? CommonClassNames.flux : CommonClassNames.mono});
            b.addStatement("var _ctxCurrent = $T.current(_reactorCtx)", new Object[]{CommonClassNames.contextReactor});
            b.addStatement("var _ctxFork = _ctxCurrent.fork()", new Object[0]);
            b.addStatement("_ctxFork.inject()", new Object[0]);
            b.addStatement("var _telemetry = this._connectionFactory.telemetry().createContext(_ctxFork, _query)", new Object[0]);
            b.addStatement("var _session = this._connectionFactory.currentSession()", new Object[0]);
            b.addCode("return $T.fromCompletionStage(_session.prepareAsync(_query.sql()))", new Object[]{CommonClassNames.mono});
            if (isMono) {
                b.beginControlFlow(".flatMap(_st ->", new Object[0]);
            } else {
                b.beginControlFlow(".flatMapMany(_st ->", new Object[0]);
            }
            b.addStatement("var _stmt = _st.boundStatementBuilder()", new Object[0]);
        } else if (isFuture) {
            b.addStatement("var _ctxCurrent = $T.current()", new Object[]{CommonClassNames.context});
            b.addStatement("var _ctxFork = _ctxCurrent.fork()", new Object[0]);
            b.addStatement("var _telemetry = this._connectionFactory.telemetry().createContext(_ctxFork, _query)", new Object[]{CommonClassNames.context});
            b.addStatement("var _session = this._connectionFactory.currentSession()", new Object[0]);
            b.addCode("return _session.prepareAsync(_query.sql())\n", new Object[0]);
            b.addCode("  .thenCompose(_st -> {$>$>\n", new Object[0]);
            b.addStatement("_ctxFork.inject()", new Object[0]);
            b.addStatement("var _stmt = _st.boundStatementBuilder()", new Object[0]);
        } else {
            b.addStatement("var _ctxCurrent = $T.current()", new Object[]{CommonClassNames.context});
            b.addStatement("var _telemetry = this._connectionFactory.telemetry().createContext(_ctxCurrent, _query)", new Object[]{CommonClassNames.context});
            b.addStatement("var _session = this._connectionFactory.currentSession()", new Object[0]);
            b.addStatement("var _stmt = _session.prepare(_query.sql()).boundStatementBuilder()", new Object[0]);
        }
        if (profile != null) {
            b.addStatement("_stmt.setExecutionProfileName($S)", new Object[]{profile});
        }
        StatementSetterGenerator.generate(b, method, query, parameters, batchParam, parameterMappers);
        if (isMono || isFlux) {
            b.addStatement("var _rrs = _session.executeReactive(_s)", new Object[0]);
            if (CommonUtils.isVoid((TypeMirror)((DeclaredType)returnType).getTypeArguments().get(0))) {
                b.addStatement("return $T.from(_rrs).then()", new Object[]{CommonClassNames.flux});
            } else {
                Objects.requireNonNull(resultMapperName, () -> "Illegal State occurred when expected to get result mapper, but got null in " + String.valueOf(method.getEnclosingElement().getSimpleName()) + "#" + String.valueOf(method.getSimpleName()));
                b.addStatement("return $N.apply(_rrs)", new Object[]{resultMapperName});
            }
            b.endControlFlow().addCode(")\n", new Object[0]);
            b.addCode("  .doOnEach(_s -> {\n    if (_s.isOnComplete()) {\n      _telemetry.close(null);\n      _ctxCurrent.inject();\n    } else if (_s.isOnError()) {\n      _telemetry.close(_s.getThrowable());\n      _ctxCurrent.inject();\n    }\n  });\n", new Object[0]);
            b.endControlFlow(")", new Object[0]);
        } else if (isFuture) {
            if (CommonUtils.isVoid((TypeMirror)((DeclaredType)returnType).getTypeArguments().get(0))) {
                b.addStatement("return _session.executeAsync(_s).thenApply(_rs -> (Void)null)", new Object[0]);
            } else {
                Objects.requireNonNull(resultMapperName, () -> "Illegal State occurred when expected to get result mapper, but got null in " + String.valueOf(method.getEnclosingElement().getSimpleName()) + "#" + String.valueOf(method.getSimpleName()));
                b.addStatement("return _session.executeAsync(_s).thenCompose($N::apply)", new Object[]{resultMapperName});
            }
            b.addCode("$<})$<\n  .whenComplete((_result, _error) -> {\n    _telemetry.close(_error);\n    _ctxCurrent.inject();\n  })", new Object[0]);
            if (((DeclaredType)returnType).asElement().toString().equals(CompletableFuture.class.getCanonicalName())) {
                b.addCode(".toCompletableFuture();", new Object[0]);
            } else {
                b.addCode(";", new Object[0]);
            }
        } else {
            b.beginControlFlow("try", new Object[0]);
            b.addStatement("var _rs = _session.execute(_s)", new Object[0]);
            if (returnType.getKind() != TypeKind.VOID) {
                Objects.requireNonNull(resultMapperName, () -> "Illegal State occurred when expected to get result mapper, but got null in " + String.valueOf(method.getEnclosingElement().getSimpleName()) + "#" + String.valueOf(method.getSimpleName()));
                b.addStatement("var _result = $N.apply(_rs)", new Object[]{resultMapperName});
            }
            b.addStatement("_telemetry.close(null)", new Object[0]);
            if (returnType.getKind() != TypeKind.VOID) {
                b.addStatement("return _result", new Object[0]);
            }
            b.nextControlFlow("catch (Exception _e)", new Object[0]).addStatement("_telemetry.close(_e)", new Object[0]).addStatement("throw _e", new Object[0]).endControlFlow();
        }
        return b.build();
    }

    private Optional<DbUtils.Mapper> parseResultMapper(ExecutableElement method, List<QueryParameter> parameters, ExecutableType methodType) {
        for (QueryParameter parameter : parameters) {
            if (!(parameter instanceof QueryParameter.BatchParameter)) continue;
            return Optional.empty();
        }
        TypeMirror returnType = methodType.getReturnType();
        CommonUtils.MappersData mappings = CommonUtils.parseMapping((Element)method);
        CommonUtils.MappingData resultSetMapper = mappings.getMapping(CassandraTypes.RESULT_SET_MAPPER);
        CommonUtils.MappingData reactiveResultSetMapper = mappings.getMapping(CassandraTypes.REACTIVE_RESULT_SET_MAPPER);
        CommonUtils.MappingData rowMapper = mappings.getMapping(CassandraTypes.ROW_MAPPER);
        if (CommonUtils.isFlux((TypeMirror)returnType)) {
            TypeMirror fluxParam = (TypeMirror)Visitors.visitDeclaredType((TypeMirror)returnType, dt -> dt.getTypeArguments().get(0));
            if (CommonUtils.isVoid((TypeMirror)fluxParam)) {
                return Optional.empty();
            }
            ParameterizedTypeName mapperType = ParameterizedTypeName.get((ClassName)CassandraTypes.REACTIVE_RESULT_SET_MAPPER, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)fluxParam), TypeName.get((TypeMirror)returnType)});
            if (reactiveResultSetMapper != null) {
                return Optional.of(new DbUtils.Mapper(reactiveResultSetMapper.mapperClass(), (TypeName)mapperType, reactiveResultSetMapper.mapperTags()));
            }
            if (rowMapper != null) {
                return Optional.of(new DbUtils.Mapper(rowMapper.mapperClass(), (TypeName)mapperType, rowMapper.mapperTags(), c -> CodeBlock.of((String)"$T.flux($L)", (Object[])new Object[]{CassandraTypes.REACTIVE_RESULT_SET_MAPPER, c})));
            }
            return Optional.of(new DbUtils.Mapper((TypeName)mapperType, Set.of()));
        }
        if (CommonUtils.isMono((TypeMirror)returnType)) {
            TypeMirror monoParam = (TypeMirror)Visitors.visitDeclaredType((TypeMirror)returnType, dt -> dt.getTypeArguments().get(0));
            ParameterizedTypeName mapperType = ParameterizedTypeName.get((ClassName)CassandraTypes.REACTIVE_RESULT_SET_MAPPER, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)monoParam), TypeName.get((TypeMirror)returnType)});
            if (CommonUtils.isVoid((TypeMirror)monoParam)) {
                return Optional.empty();
            }
            if (reactiveResultSetMapper != null) {
                return Optional.of(new DbUtils.Mapper(reactiveResultSetMapper.mapperClass(), (TypeName)mapperType, reactiveResultSetMapper.mapperTags()));
            }
            if (rowMapper != null) {
                if (CommonUtils.isList((TypeMirror)monoParam)) {
                    return Optional.of(new DbUtils.Mapper(rowMapper.mapperClass(), (TypeName)mapperType, rowMapper.mapperTags(), c -> CodeBlock.of((String)"$T.monoList($L)", (Object[])new Object[]{CassandraTypes.REACTIVE_RESULT_SET_MAPPER, c})));
                }
                return Optional.of(new DbUtils.Mapper(rowMapper.mapperClass(), (TypeName)mapperType, rowMapper.mapperTags(), c -> CodeBlock.of((String)"$T.mono($L)", (Object[])new Object[]{CassandraTypes.REACTIVE_RESULT_SET_MAPPER, c})));
            }
            return Optional.of(new DbUtils.Mapper((TypeName)mapperType, Set.of()));
        }
        if (CommonUtils.isFuture((TypeMirror)returnType)) {
            TypeMirror futureParam = (TypeMirror)Visitors.visitDeclaredType((TypeMirror)returnType, dt -> dt.getTypeArguments().get(0));
            if (CommonUtils.isVoid((TypeMirror)futureParam)) {
                return Optional.empty();
            }
            ParameterizedTypeName mapperType = ParameterizedTypeName.get((ClassName)CassandraTypes.ASYNC_RESULT_SET_MAPPER, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)futureParam)});
            if (reactiveResultSetMapper != null) {
                return Optional.of(new DbUtils.Mapper(reactiveResultSetMapper.mapperClass(), (TypeName)mapperType, reactiveResultSetMapper.mapperTags()));
            }
            if (rowMapper != null) {
                if (CommonUtils.isList((TypeMirror)futureParam)) {
                    return Optional.of(new DbUtils.Mapper(rowMapper.mapperClass(), (TypeName)mapperType, rowMapper.mapperTags(), c -> CodeBlock.of((String)"$T.list($L)", (Object[])new Object[]{CassandraTypes.ASYNC_RESULT_SET_MAPPER, c})));
                }
                return Optional.of(new DbUtils.Mapper(rowMapper.mapperClass(), (TypeName)mapperType, rowMapper.mapperTags(), c -> CodeBlock.of((String)"$T.one($L)", (Object[])new Object[]{CassandraTypes.ASYNC_RESULT_SET_MAPPER, c})));
            }
            return Optional.of(new DbUtils.Mapper((TypeName)mapperType, Set.of()));
        }
        if (returnType.getKind() == TypeKind.VOID) {
            return Optional.empty();
        }
        ParameterizedTypeName mapperType = ParameterizedTypeName.get((ClassName)CassandraTypes.RESULT_SET_MAPPER, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)returnType).box()});
        if (resultSetMapper != null) {
            return Optional.of(new DbUtils.Mapper(resultSetMapper.mapperClass(), (TypeName)mapperType, resultSetMapper.mapperTags()));
        }
        if (rowMapper != null) {
            if (CommonUtils.isList((TypeMirror)returnType)) {
                return Optional.of(new DbUtils.Mapper(rowMapper.mapperClass(), (TypeName)mapperType, rowMapper.mapperTags(), c -> CodeBlock.of((String)"$T.listResultSetMapper($L)", (Object[])new Object[]{CassandraTypes.RESULT_SET_MAPPER, c})));
            }
            if (CommonUtils.isOptional((TypeMirror)returnType)) {
                return Optional.of(new DbUtils.Mapper(rowMapper.mapperClass(), (TypeName)mapperType, rowMapper.mapperTags(), c -> CodeBlock.of((String)"$T.optionalResultSetMapper($L)", (Object[])new Object[]{CassandraTypes.RESULT_SET_MAPPER, c})));
            }
            return Optional.of(new DbUtils.Mapper(rowMapper.mapperClass(), (TypeName)mapperType, rowMapper.mapperTags(), c -> CodeBlock.of((String)"$T.singleResultSetMapper($L)", (Object[])new Object[]{CassandraTypes.RESULT_SET_MAPPER, c})));
        }
        return Optional.of(new DbUtils.Mapper((TypeName)mapperType, Set.of()));
    }

    public void enrichWithExecutor(TypeElement repositoryElement, TypeSpec.Builder builder, MethodSpec.Builder constructorBuilder) {
        builder.addField((TypeName)CassandraTypes.CONNECTION_FACTORY, "_connectionFactory", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        builder.addSuperinterface((TypeName)CassandraTypes.REPOSITORY);
        builder.addMethod(MethodSpec.methodBuilder((String)"getCassandraConnectionFactory").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(Override.class).returns((TypeName)CassandraTypes.CONNECTION_FACTORY).addCode("return this._connectionFactory;", new Object[0]).build());
        CodeBlock executorTag = DbUtils.getTag(repositoryElement);
        if (executorTag != null) {
            constructorBuilder.addParameter(ParameterSpec.builder((TypeName)CassandraTypes.CONNECTION_FACTORY, (String)"_connectionFactory", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.tag).addMember("value", executorTag).build()).build());
        } else {
            constructorBuilder.addParameter((TypeName)CassandraTypes.CONNECTION_FACTORY, "_connectionFactory", new Modifier[0]);
        }
        constructorBuilder.addStatement("this._connectionFactory = _connectionFactory", new Object[0]);
    }
}

