/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor.cassandra;

import com.squareup.javapoet.ClassName;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import ru.tinkoff.kora.annotation.processor.common.AbstractKoraProcessor;
import ru.tinkoff.kora.database.annotation.processor.cassandra.CassandraTypes;
import ru.tinkoff.kora.database.annotation.processor.cassandra.UserDefinedTypeResultExtractorGenerator;
import ru.tinkoff.kora.database.annotation.processor.cassandra.UserDefinedTypeStatementSetterGenerator;
import ru.tinkoff.kora.database.annotation.processor.entity.DbEntity;

public class CassandraUdtAnnotationProcessor
extends AbstractKoraProcessor {
    private UserDefinedTypeResultExtractorGenerator resultExtractorGenerator;
    private UserDefinedTypeStatementSetterGenerator statementSetterGenerator;

    public Set<ClassName> getSupportedAnnotationClassNames() {
        return Set.of(CassandraTypes.UDT_ANNOTATION);
    }

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.resultExtractorGenerator = new UserDefinedTypeResultExtractorGenerator(processingEnv);
        this.statementSetterGenerator = new UserDefinedTypeStatementSetterGenerator(processingEnv);
    }

    public void process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv, Map<ClassName, List<AbstractKoraProcessor.AnnotatedElement>> annotatedElements) {
        for (List<AbstractKoraProcessor.AnnotatedElement> annotatedList : annotatedElements.values()) {
            for (AbstractKoraProcessor.AnnotatedElement annotated : annotatedList) {
                Element element = annotated.element();
                if (element.getKind() != ElementKind.RECORD && element.getKind() != ElementKind.CLASS) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Only classes and records can be annotated with @UDT", element);
                    continue;
                }
                TypeMirror type = element.asType();
                TypeElement typeElement = (TypeElement)element;
                DbEntity entity = DbEntity.parseEntity(this.types, type);
                if (entity == null) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Invalid type for @UDT", element);
                    continue;
                }
                this.statementSetterGenerator.generate(typeElement, type);
                this.resultExtractorGenerator.generate(typeElement, type);
            }
        }
    }
}

