/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor.cassandra.extension;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.GenericTypeResolver;
import ru.tinkoff.kora.annotation.processor.common.NameUtils;
import ru.tinkoff.kora.database.annotation.processor.cassandra.CassandraEntityGenerator;
import ru.tinkoff.kora.database.annotation.processor.cassandra.CassandraTypes;
import ru.tinkoff.kora.database.annotation.processor.entity.DbEntity;
import ru.tinkoff.kora.kora.app.annotation.processor.extension.ExtensionResult;
import ru.tinkoff.kora.kora.app.annotation.processor.extension.KoraExtension;

public class CassandraTypesExtension
implements KoraExtension {
    private final Types types;
    private final Elements elements;
    private final CassandraEntityGenerator generator;
    private final Messager messager;

    public CassandraTypesExtension(ProcessingEnvironment env) {
        this.types = env.getTypeUtils();
        this.elements = env.getElementUtils();
        this.generator = new CassandraEntityGenerator(env.getTypeUtils(), env.getElementUtils(), env.getFiler());
        this.messager = env.getMessager();
    }

    @Nullable
    public KoraExtension.KoraExtensionDependencyGenerator getDependencyGenerator(RoundEnvironment roundEnvironment, TypeMirror typeMirror, Set<String> tag) {
        ParameterizedTypeName ptn;
        block11: {
            block10: {
                if (!tag.isEmpty()) {
                    return null;
                }
                TypeName typeName = TypeName.get((TypeMirror)typeMirror).withoutAnnotations();
                if (!(typeName instanceof ParameterizedTypeName)) break block10;
                ptn = (ParameterizedTypeName)typeName;
                if (typeMirror instanceof DeclaredType) break block11;
            }
            return null;
        }
        DeclaredType dt = (DeclaredType)typeMirror;
        if (ptn.rawType.equals((Object)CassandraTypes.RESULT_SET_MAPPER)) {
            return this.generateResultSetMapper(roundEnvironment, dt);
        }
        if (ptn.rawType.equals((Object)CassandraTypes.ASYNC_RESULT_SET_MAPPER)) {
            return this.generateAsyncResultSetMapper(roundEnvironment, dt);
        }
        if (ptn.rawType.equals((Object)CassandraTypes.REACTIVE_RESULT_SET_MAPPER)) {
            return this.generateReactiveResultSetMapper(roundEnvironment, ptn, dt);
        }
        if (ptn.rawType.equals((Object)CassandraTypes.ROW_MAPPER)) {
            return this.generateResultRowMapper(roundEnvironment, dt);
        }
        if (ptn.rawType.equals((Object)CassandraTypes.PARAMETER_COLUMN_MAPPER)) {
            return this.generateParameterColumnMapper(roundEnvironment, dt);
        }
        if (ptn.rawType.equals((Object)CassandraTypes.RESULT_COLUMN_MAPPER)) {
            return this.generateRowColumnMapper(roundEnvironment, dt);
        }
        return null;
    }

    private KoraExtension.KoraExtensionDependencyGenerator generateRowColumnMapper(RoundEnvironment roundEnvironment, DeclaredType dt) {
        TypeMirror entityType = dt.getTypeArguments().get(0);
        TypeElement element = (TypeElement)this.types.asElement(entityType);
        if (AnnotationUtils.findAnnotation((Element)element, (ClassName)CassandraTypes.UDT_ANNOTATION) != null) {
            return KoraExtension.KoraExtensionDependencyGenerator.generatedFrom((Elements)this.elements, (Element)element, (ClassName)CassandraTypes.RESULT_COLUMN_MAPPER);
        }
        if (element.getQualifiedName().contentEquals("java.util.List") && AnnotationUtils.findAnnotation((Element)(element = (TypeElement)this.types.asElement(entityType = ((DeclaredType)entityType).getTypeArguments().get(0))), (ClassName)CassandraTypes.UDT_ANNOTATION) != null) {
            return KoraExtension.KoraExtensionDependencyGenerator.generatedFrom((Elements)this.elements, (Element)element, (String)"List_CassandraRowColumnMapper");
        }
        return null;
    }

    private KoraExtension.KoraExtensionDependencyGenerator generateParameterColumnMapper(RoundEnvironment roundEnvironment, DeclaredType dt) {
        TypeMirror entityType = dt.getTypeArguments().get(0);
        TypeElement element = (TypeElement)this.types.asElement(entityType);
        if (AnnotationUtils.findAnnotation((Element)element, (ClassName)CassandraTypes.UDT_ANNOTATION) != null) {
            return KoraExtension.KoraExtensionDependencyGenerator.generatedFrom((Elements)this.elements, (Element)element, (ClassName)CassandraTypes.PARAMETER_COLUMN_MAPPER);
        }
        if (element.getQualifiedName().contentEquals("java.util.List") && AnnotationUtils.findAnnotation((Element)(element = (TypeElement)this.types.asElement(entityType = ((DeclaredType)entityType).getTypeArguments().get(0))), (ClassName)CassandraTypes.UDT_ANNOTATION) != null) {
            return KoraExtension.KoraExtensionDependencyGenerator.generatedFrom((Elements)this.elements, (Element)element, (String)"List_CassandraParameterColumnMapper");
        }
        return null;
    }

    @Nullable
    private KoraExtension.KoraExtensionDependencyGenerator generateResultRowMapper(RoundEnvironment roundEnvironment, DeclaredType typeMirror) {
        TypeMirror rowType = typeMirror.getTypeArguments().get(0);
        Element rowTypeElement = this.types.asElement(rowType);
        if (AnnotationUtils.isAnnotationPresent((Element)rowTypeElement, (ClassName)CassandraTypes.CASSANDRA_ENTITY)) {
            return this.fromAnnotationProcessor(this.generator.rowMapperName(rowTypeElement));
        }
        DbEntity entity = DbEntity.parseEntity(this.types, rowType);
        if (entity == null) {
            return null;
        }
        String mapperName = NameUtils.generatedType((Element)entity.typeElement(), (ClassName)CassandraTypes.ROW_MAPPER);
        PackageElement packageElement = this.elements.getPackageOf(entity.typeElement());
        return () -> {
            TypeElement maybeGenerated = this.elements.getTypeElement(String.valueOf(packageElement.getQualifiedName()) + "." + mapperName);
            if (maybeGenerated != null) {
                List constructors = CommonUtils.findConstructors((TypeElement)maybeGenerated, m -> m.contains((Object)Modifier.PUBLIC));
                if (constructors.size() != 1) {
                    throw new IllegalStateException();
                }
                return ExtensionResult.fromExecutable((ExecutableElement)((ExecutableElement)constructors.get(0)));
            }
            this.messager.printMessage(Diagnostic.Kind.WARNING, "Type is not annotated with @EntityCassandra, but mapper %s is requested by graph. Generating one in graph building process will lead to another round of compiling which will slow down you build".formatted(TypeName.get((TypeMirror)typeMirror)), entity.typeElement());
            this.generator.generateRowMapper(entity);
            return ExtensionResult.nextRound();
        };
    }

    @Nullable
    private KoraExtension.KoraExtensionDependencyGenerator generateResultSetMapper(RoundEnvironment roundEnvironment, DeclaredType typeMirror) {
        TypeMirror resultType = typeMirror.getTypeArguments().get(0);
        if (!(resultType instanceof DeclaredType)) {
            return null;
        }
        DeclaredType dt = (DeclaredType)resultType;
        if (CommonUtils.isList((TypeMirror)resultType)) {
            ParameterizedTypeName tn = (ParameterizedTypeName)TypeName.get((TypeMirror)resultType);
            TypeMirror rowType = dt.getTypeArguments().get(0);
            return this.listResultSetMapper(typeMirror, tn, (DeclaredType)rowType);
        }
        Element rowTypeElement = this.types.asElement(resultType);
        if (AnnotationUtils.isAnnotationPresent((Element)rowTypeElement, (ClassName)CassandraTypes.CASSANDRA_ENTITY)) {
            return this.fromAnnotationProcessor(this.generator.resultSetMapperName(rowTypeElement));
        }
        return () -> {
            ExecutableElement singleResultSetMapper = this.findStaticMethod(CassandraTypes.RESULT_SET_MAPPER, "singleResultSetMapper");
            TypeVariable tp = (TypeVariable)singleResultSetMapper.getTypeParameters().get(0).asType();
            ExecutableType executableType = (ExecutableType)GenericTypeResolver.resolve((Types)this.types, Map.of(tp, resultType), (TypeMirror)singleResultSetMapper.asType());
            return ExtensionResult.fromExecutable((ExecutableElement)singleResultSetMapper, (ExecutableType)executableType);
        };
    }

    @Nullable
    private KoraExtension.KoraExtensionDependencyGenerator generateAsyncResultSetMapper(RoundEnvironment roundEnvironment, DeclaredType typeMirror) {
        TypeMirror listType = typeMirror.getTypeArguments().get(0);
        if (!(listType instanceof DeclaredType)) {
            return null;
        }
        DeclaredType dt = (DeclaredType)listType;
        if (CommonUtils.isList((TypeMirror)listType)) {
            return () -> {
                ParameterizedTypeName tn = (ParameterizedTypeName)TypeName.get((TypeMirror)listType);
                TypeMirror rowType = dt.getTypeArguments().get(0);
                ExecutableElement singleResultSetMapper = this.findStaticMethod(CassandraTypes.ASYNC_RESULT_SET_MAPPER, "list");
                TypeVariable tp = (TypeVariable)singleResultSetMapper.getTypeParameters().get(0).asType();
                ExecutableType executableType = (ExecutableType)GenericTypeResolver.resolve((Types)this.types, Map.of(tp, rowType), (TypeMirror)singleResultSetMapper.asType());
                return ExtensionResult.fromExecutable((ExecutableElement)singleResultSetMapper, (ExecutableType)executableType);
            };
        }
        return () -> {
            ExecutableElement singleResultSetMapper = this.findStaticMethod(CassandraTypes.ASYNC_RESULT_SET_MAPPER, "one");
            TypeVariable tp = (TypeVariable)singleResultSetMapper.getTypeParameters().get(0).asType();
            ExecutableType executableType = (ExecutableType)GenericTypeResolver.resolve((Types)this.types, Map.of(tp, listType), (TypeMirror)singleResultSetMapper.asType());
            return ExtensionResult.fromExecutable((ExecutableElement)singleResultSetMapper, (ExecutableType)executableType);
        };
    }

    @Nullable
    private KoraExtension.KoraExtensionDependencyGenerator generateReactiveResultSetMapper(RoundEnvironment roundEnvironment, ParameterizedTypeName ptn, DeclaredType typeMirror) {
        Object e;
        if (ptn.typeArguments.size() < 2 || !((e = ptn.typeArguments.get(1)) instanceof ParameterizedTypeName)) {
            return null;
        }
        ParameterizedTypeName publisherTypeName = (ParameterizedTypeName)e;
        if (publisherTypeName.rawType.equals((Object)CommonClassNames.flux)) {
            ExecutableElement fluxMapper = this.findStaticMethod(CassandraTypes.REACTIVE_RESULT_SET_MAPPER, "flux");
            TypeMirror rowType = typeMirror.getTypeArguments().get(0);
            TypeVariable tp = (TypeVariable)fluxMapper.getTypeParameters().get(0).asType();
            ExecutableType executableType = (ExecutableType)GenericTypeResolver.resolve((Types)this.types, Map.of(tp, rowType), (TypeMirror)fluxMapper.asType());
            return () -> ExtensionResult.fromExecutable((ExecutableElement)fluxMapper, (ExecutableType)executableType);
        }
        if (publisherTypeName.rawType.equals((Object)CommonClassNames.mono)) {
            TypeMirror monoParam = typeMirror.getTypeArguments().get(0);
            TypeName monoParamTypeName = TypeName.get((TypeMirror)monoParam);
            if (monoParam instanceof DeclaredType) {
                DeclaredType monoDt = (DeclaredType)monoParam;
                if (monoParamTypeName instanceof ParameterizedTypeName) {
                    ParameterizedTypeName monoPtn = (ParameterizedTypeName)monoParamTypeName;
                    if (monoPtn.rawType.equals((Object)CommonClassNames.list)) {
                        TypeMirror rowType = monoDt.getTypeArguments().get(0);
                        ExecutableElement monoList = this.findStaticMethod(CassandraTypes.REACTIVE_RESULT_SET_MAPPER, "monoList");
                        TypeVariable tp = (TypeVariable)monoList.getTypeParameters().get(0).asType();
                        ExecutableType executableType = (ExecutableType)GenericTypeResolver.resolve((Types)this.types, Map.of(tp, rowType), (TypeMirror)monoList.asType());
                        return () -> ExtensionResult.fromExecutable((ExecutableElement)monoList, (ExecutableType)executableType);
                    }
                }
            }
            if (monoParamTypeName.equals((Object)TypeName.VOID.box())) {
                ExecutableElement monoVoid = this.findStaticMethod(CassandraTypes.REACTIVE_RESULT_SET_MAPPER, "monoVoid");
                return () -> ExtensionResult.fromExecutable((ExecutableElement)monoVoid, (ExecutableType)((ExecutableType)monoVoid.asType()));
            }
            TypeMirror rowType = monoParam;
            ExecutableElement mono = this.findStaticMethod(CassandraTypes.REACTIVE_RESULT_SET_MAPPER, "mono");
            TypeVariable tp = (TypeVariable)mono.getTypeParameters().get(0).asType();
            ExecutableType executableType = (ExecutableType)GenericTypeResolver.resolve((Types)this.types, Map.of(tp, rowType), (TypeMirror)mono.asType());
            return () -> ExtensionResult.fromExecutable((ExecutableElement)mono, (ExecutableType)executableType);
        }
        return null;
    }

    private KoraExtension.KoraExtensionDependencyGenerator listResultSetMapper(DeclaredType typeMirror, ParameterizedTypeName listType, DeclaredType rowTypeMirror) {
        Element rowTypeElement = this.types.asElement(rowTypeMirror);
        ClassName listResultSetMapperName = this.generator.listResultSetMapperName(rowTypeElement);
        if (AnnotationUtils.isAnnotationPresent((Element)rowTypeElement, (ClassName)CassandraTypes.CASSANDRA_ENTITY)) {
            return this.fromAnnotationProcessor(listResultSetMapperName);
        }
        DbEntity entity = DbEntity.parseEntity(this.types, rowTypeMirror);
        if (entity == null) {
            return () -> {
                ExecutableElement listResultSetMapper = this.findStaticMethod(CassandraTypes.RESULT_SET_MAPPER, "listResultSetMapper");
                TypeVariable tp = (TypeVariable)listResultSetMapper.getTypeParameters().get(0).asType();
                ExecutableType executableType = (ExecutableType)GenericTypeResolver.resolve((Types)this.types, Map.of(tp, rowTypeMirror), (TypeMirror)listResultSetMapper.asType());
                return ExtensionResult.fromExecutable((ExecutableElement)listResultSetMapper, (ExecutableType)executableType);
            };
        }
        return () -> {
            TypeElement maybeGenerated = this.elements.getTypeElement(listResultSetMapperName.canonicalName());
            if (maybeGenerated != null) {
                List constructors = CommonUtils.findConstructors((TypeElement)maybeGenerated, m -> m.contains((Object)Modifier.PUBLIC));
                if (constructors.size() != 1) {
                    throw new IllegalStateException();
                }
                return ExtensionResult.fromExecutable((ExecutableElement)((ExecutableElement)constructors.get(0)));
            }
            this.generator.generateListResultSetMapper(entity);
            return ExtensionResult.nextRound();
        };
    }

    private ExecutableElement findStaticMethod(ClassName className, String methodName) {
        return this.elements.getTypeElement(className.canonicalName()).getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD && e.getModifiers().contains((Object)Modifier.STATIC)).map(ExecutableElement.class::cast).filter(m -> m.getSimpleName().contentEquals(methodName)).findFirst().orElseThrow();
    }

    private KoraExtension.KoraExtensionDependencyGenerator fromAnnotationProcessor(ClassName mapperName) {
        TypeElement maybeGenerated = this.elements.getTypeElement(mapperName.canonicalName());
        if (maybeGenerated != null) {
            List constructors = CommonUtils.findConstructors((TypeElement)maybeGenerated, m -> m.contains((Object)Modifier.PUBLIC));
            if (constructors.size() != 1) {
                throw new IllegalStateException();
            }
            return () -> ExtensionResult.fromExecutable((ExecutableElement)((ExecutableElement)constructors.get(0)));
        }
        return ExtensionResult::nextRound;
    }
}

