/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor.entity;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.RecordUtils;
import ru.tinkoff.kora.database.annotation.processor.DbUtils;
import ru.tinkoff.kora.database.annotation.processor.EntityUtils;

public class DbEntity {
    private final TypeMirror typeMirror;
    private final TypeElement typeElement;
    private final DtoType entityType;
    private final List<EntityField> entityFields;
    private final List<Column> columns;

    public DbEntity(TypeMirror typeMirror, TypeElement typeElement, DtoType entityType, List<EntityField> entityFields) {
        this.typeMirror = typeMirror;
        this.typeElement = typeElement;
        this.entityType = entityType;
        this.entityFields = entityFields;
        this.columns = entityFields.stream().flatMap(ef -> {
            if (ef instanceof SimpleEntityField) {
                SimpleEntityField simple = (SimpleEntityField)ef;
                return Stream.of(new ColumnImpl(simple));
            }
            EmbeddedEntityField embedded = (EmbeddedEntityField)ef;
            return embedded.fields().stream().map(ColumnImpl::new);
        }).toList();
    }

    public List<Column> columns() {
        return this.columns;
    }

    public TypeMirror typeMirror() {
        return this.typeMirror;
    }

    public TypeElement typeElement() {
        return this.typeElement;
    }

    public CodeBlock buildInstance(String variableName) {
        return switch (this.entityType) {
            default -> throw new IncompatibleClassChangeError();
            case DtoType.RECORD -> {
                CodeBlock.Builder b = CodeBlock.builder();
                b.add("$[var $N = new $T(", new Object[]{variableName, TypeName.get((TypeMirror)this.typeMirror)}).indent().add("\n", new Object[0]);
                for (int i = 0; i < this.entityFields.size(); ++i) {
                    EntityField entityField = this.entityFields.get(i);
                    if (i > 0) {
                        b.add(",\n", new Object[0]);
                    }
                    if (entityField instanceof SimpleEntityField) {
                        SimpleEntityField simple = (SimpleEntityField)entityField;
                        b.add("$N", new Object[]{simple.element().getSimpleName()});
                        continue;
                    }
                    if (!(entityField instanceof EmbeddedEntityField)) continue;
                    EmbeddedEntityField embedded = (EmbeddedEntityField)entityField;
                    b.add("$N", new Object[]{embedded.parent().element().getSimpleName()});
                }
                yield b.unindent().add("\n);$]\n", new Object[0]).build();
            }
            case DtoType.BEAN -> {
                CodeBlock.Builder b = CodeBlock.builder();
                b.addStatement("var $N = new $T()", new Object[]{variableName, TypeName.get((TypeMirror)this.typeMirror)});
                for (EntityField entityField : this.entityFields) {
                    String setter;
                    if (entityField instanceof SimpleEntityField) {
                        SimpleEntityField simple = (SimpleEntityField)entityField;
                        setter = "set" + CommonUtils.capitalize((String)simple.element().getSimpleName().toString());
                        b.addStatement("$N.$N($N)", new Object[]{variableName, setter, simple.element().getSimpleName()});
                        continue;
                    }
                    if (!(entityField instanceof EmbeddedEntityField)) continue;
                    EmbeddedEntityField embedded = (EmbeddedEntityField)entityField;
                    setter = "set" + CommonUtils.capitalize((String)embedded.element().getSimpleName().toString());
                    b.addStatement("$N.$N($L)", new Object[]{variableName, setter, embedded.buildInstance()});
                }
                yield b.build();
            }
        };
    }

    public CodeBlock buildEmbeddedFields() {
        CodeBlock.Builder b = CodeBlock.builder();
        for (EntityField entityField : this.entityFields) {
            if (!(entityField instanceof EmbeddedEntityField)) continue;
            EmbeddedEntityField embedded = (EmbeddedEntityField)entityField;
            b.addStatement("$T $N", new Object[]{embedded.typeMirror(), embedded.parent.element().getSimpleName()});
            if (CommonUtils.isNullable((AnnotatedConstruct)embedded.parent().element())) {
                EmbeddedEntityField.Field field;
                int j;
                b.add("if (", new Object[0]);
                for (j = 0; j < embedded.fields().size(); ++j) {
                    field = embedded.fields().get(j);
                    if (j > 0) {
                        b.add(" && ", new Object[0]);
                    }
                    b.add("$N == null", new Object[]{field.variableName()});
                }
                b.add(") {$>\n", new Object[0]);
                b.add("$N = null;$<\n} else {$>\n", new Object[]{embedded.parent().element().getSimpleName()});
                for (j = 0; j < embedded.fields().size(); ++j) {
                    field = embedded.fields().get(j);
                    if (CommonUtils.isNullable((AnnotatedConstruct)field.element())) continue;
                    b.beginControlFlow("if ($N == null)", new Object[]{field.variableName()}).addStatement("throw new $T($S)", new Object[]{NullPointerException.class, "Field %s is not nullable, but column %s is null".formatted(field.element().getSimpleName(), field.columnName())}).endControlFlow();
                }
            }
            b.add("$N = $L;", new Object[]{embedded.parent().element().getSimpleName(), embedded.buildInstance()});
            if (CommonUtils.isNullable((AnnotatedConstruct)embedded.parent().element())) {
                b.add("$<\n}\n", new Object[0]);
                continue;
            }
            b.add("\n", new Object[0]);
        }
        return b.build();
    }

    public static DbEntity parseEntity(Types types, TypeMirror typeMirror) {
        TypeElement typeElement = (TypeElement)types.asElement(typeMirror);
        if (typeElement == null) {
            return null;
        }
        if (DbEntity.isRecord(typeElement)) {
            return DbEntity.parseRecordEntity(types, typeElement);
        }
        DbEntity javaBeanEntity = DbEntity.parseJavaBean(types, typeMirror, typeElement);
        if (javaBeanEntity != null) {
            return javaBeanEntity;
        }
        return null;
    }

    private static DbEntity parseRecordEntity(Types types, TypeElement typeElement) {
        CommonUtils.NameConverter nameConverter = CommonUtils.getNameConverter((TypeElement)typeElement);
        List<EntityField> fields = typeElement.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.FIELD).filter(DbEntity::isNotStaticField).map(e -> {
            VariableElement fieldElement = (VariableElement)e;
            TypeMirror fieldType = fieldElement.asType();
            String columnName = EntityUtils.parseColumnName(fieldElement, nameConverter);
            boolean isNullableField = DbEntity.isNullableRecordField(fieldElement, typeElement);
            SimpleEntityField field = new SimpleEntityField(fieldElement, fieldType, columnName, DtoType.RECORD, isNullableField);
            AnnotationMirror embedded = AnnotationUtils.findAnnotation((Element)fieldElement, (ClassName)DbUtils.EMBEDDED_ANNOTATION);
            if (embedded == null) {
                return field;
            }
            String prefix = Objects.requireNonNullElse((String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)embedded, (String)"value"), "");
            DbEntity entity = DbEntity.parseEntity(types, fieldType);
            ArrayList<EmbeddedEntityField.Field> embeddedFields = new ArrayList<EmbeddedEntityField.Field>();
            for (EntityField entityField : entity.entityFields) {
                boolean isNullableEmbedded = isNullableField || DbEntity.isNullableRecordField(entityField.element(), entity.typeElement);
                String prefixEmbedded = prefix + ((SimpleEntityField)entityField).columnName();
                embeddedFields.add(new EmbeddedEntityField.Field(field, entityField.element(), entityField.typeMirror(), prefixEmbedded, DtoType.RECORD, isNullableEmbedded));
            }
            return new EmbeddedEntityField(field, fieldType, fieldElement, embeddedFields);
        }).toList();
        return new DbEntity(typeElement.asType(), typeElement, DtoType.RECORD, fields);
    }

    private static boolean isNullableRecordField(VariableElement field, TypeElement type) {
        boolean nullable = CommonUtils.isNullable((AnnotatedConstruct)field);
        if (nullable) {
            return true;
        }
        ExecutableElement constructor = RecordUtils.findCanonicalConstructor((TypeElement)type);
        for (VariableElement variableElement : constructor.getParameters()) {
            if (!variableElement.getSimpleName().contentEquals(field.getSimpleName())) continue;
            return CommonUtils.isNullable((AnnotatedConstruct)variableElement);
        }
        throw new IllegalStateException();
    }

    private static boolean isRecord(TypeElement typeElement) {
        TypeMirror superclass = typeElement.getSuperclass();
        if (superclass == null) {
            return false;
        }
        return superclass.toString().equals(Record.class.getCanonicalName());
    }

    @Nullable
    private static DbEntity parseJavaBean(Types types, TypeMirror typeMirror, TypeElement typeElement) {
        CommonUtils.NameConverter nameConverter = CommonUtils.getNameConverter((TypeElement)typeElement);
        Map methods = typeElement.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD && e.getModifiers().contains((Object)Modifier.PUBLIC)).map(ExecutableElement.class::cast).collect(Collectors.toMap(e -> e.getSimpleName().toString(), Function.identity(), (e1, e2) -> e1));
        List<EntityField> fields = typeElement.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.FIELD).filter(DbEntity::isNotStaticField).map(VariableElement.class::cast).mapMulti((fieldElement, sink) -> {
            TypeMirror fieldType = fieldElement.asType();
            String fieldName = fieldElement.getSimpleName().toString();
            String getterName = "get" + CommonUtils.capitalize((String)fieldName);
            String setterName = "set" + CommonUtils.capitalize((String)fieldName);
            ExecutableElement getter = (ExecutableElement)methods.get(getterName);
            ExecutableElement setter = (ExecutableElement)methods.get(setterName);
            if (getter == null || setter == null) {
                return;
            }
            if (!getter.getParameters().isEmpty()) {
                return;
            }
            if (setter.getParameters().size() != 1 || setter.getReturnType().getKind() != TypeKind.VOID) {
                return;
            }
            if (!types.isSameType(getter.getReturnType(), fieldType)) {
                return;
            }
            if (!types.isSameType(setter.getParameters().get(0).asType(), fieldType)) {
                return;
            }
            String columnName = EntityUtils.parseColumnName(fieldElement, nameConverter);
            boolean isNullableField = DbEntity.isNullableBeanField(fieldElement, setter);
            SimpleEntityField simpleField = new SimpleEntityField((VariableElement)fieldElement, fieldType, columnName, DtoType.BEAN, isNullableField);
            AnnotationMirror embedded = AnnotationUtils.findAnnotation((Element)fieldElement, (ClassName)DbUtils.EMBEDDED_ANNOTATION);
            if (embedded == null) {
                sink.accept(simpleField);
            } else {
                String prefix = Objects.requireNonNullElse((String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)embedded, (String)"value"), "");
                DbEntity entity = DbEntity.parseEntity(types, fieldType);
                ArrayList<EmbeddedEntityField.Field> embeddedFields = new ArrayList<EmbeddedEntityField.Field>();
                for (EntityField entityField : entity.entityFields) {
                    boolean isNullableEmbedded = isNullableField || DbEntity.isNullableRecordField(entityField.element(), entity.typeElement);
                    String prefixEmbedded = prefix + ((SimpleEntityField)entityField).columnName();
                    embeddedFields.add(new EmbeddedEntityField.Field(simpleField, entityField.element(), entityField.typeMirror(), prefixEmbedded, DtoType.RECORD, isNullableEmbedded));
                }
                EmbeddedEntityField embeddedField = new EmbeddedEntityField(simpleField, fieldType, (VariableElement)fieldElement, (List<EmbeddedEntityField.Field>)embeddedFields);
                sink.accept(embeddedField);
            }
        }).toList();
        if (fields.isEmpty()) {
            return null;
        }
        return new DbEntity(typeMirror, typeElement, DtoType.BEAN, fields);
    }

    private static boolean isNullableBeanField(VariableElement field, ExecutableElement method) {
        boolean nullable = CommonUtils.isNullable((AnnotatedConstruct)field);
        if (nullable) {
            return true;
        }
        return method.getParameters().stream().findFirst().map(CommonUtils::isNullable).orElse(false);
    }

    private static boolean isNotStaticField(Element element) {
        return !element.getModifiers().contains((Object)Modifier.STATIC);
    }

    private static enum DtoType {
        RECORD,
        BEAN;

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface EntityField {
        public String accessor();

        public VariableElement element();

        public TypeMirror typeMirror();
    }

    public record SimpleEntityField(VariableElement element, TypeMirror typeMirror, String columnName, DtoType entityType, boolean nullable) implements EntityField
    {
        @Override
        public String accessor() {
            return switch (this.entityType) {
                default -> throw new IncompatibleClassChangeError();
                case DtoType.RECORD -> this.element.getSimpleName().toString();
                case DtoType.BEAN -> "get" + CommonUtils.capitalize((String)this.element.getSimpleName().toString());
            };
        }
    }

    public record EmbeddedEntityField(EntityField parent, TypeMirror typeMirror, VariableElement element, List<Field> fields) implements EntityField
    {
        @Override
        public String accessor() {
            return this.parent.accessor();
        }

        public CodeBlock buildInstance() {
            CodeBlock.Builder eb = CodeBlock.builder();
            eb.add("new $T(", new Object[]{TypeName.get((TypeMirror)this.typeMirror())}).indent().add("\n", new Object[0]);
            for (int j = 0; j < this.fields().size(); ++j) {
                Field field = this.fields().get(j);
                if (j > 0) {
                    eb.add(",\n", new Object[0]);
                }
                eb.add("$N", new Object[]{field.variableName()});
            }
            eb.unindent().add("\n)", new Object[0]);
            return eb.build();
        }

        private record Field(SimpleEntityField parent, VariableElement element, TypeMirror typeMirror, String columnName, DtoType entityType, boolean nullable) {
            public String variableName() {
                return String.valueOf(this.parent.element.getSimpleName()) + "_" + this.element.getSimpleName().toString();
            }
        }
    }

    private record ColumnImpl(VariableElement element, TypeMirror type, String sqlParameterName, String variableName, String columnName, String[] names, boolean isNullable, String accessor, EntityField entityField) implements Column
    {
        public ColumnImpl(SimpleEntityField simple) {
            this(simple.element, simple.typeMirror, simple.element.getSimpleName().toString(), simple.element.getSimpleName().toString(), simple.columnName(), new String[]{simple.element.getSimpleName().toString()}, simple.nullable, simple.accessor(), simple);
        }

        public ColumnImpl(EmbeddedEntityField.Field f) {
            this(f.element(), f.typeMirror(), String.valueOf(f.parent().element.getSimpleName()) + "." + String.valueOf(f.element.getSimpleName()), f.variableName(), f.columnName(), new String[]{f.parent.element.getSimpleName().toString(), f.element.getSimpleName().toString()}, f.nullable, f.parent.accessor() + "()." + f.element.getSimpleName().toString(), f.parent);
        }

        @Override
        public String queryParameterName(String variableName) {
            return variableName + "." + this.sqlParameterName;
        }
    }

    public static interface Column {
        public VariableElement element();

        public TypeMirror type();

        public String queryParameterName(String var1);

        public String variableName();

        public String columnName();

        public String[] names();

        public boolean isNullable();

        public String accessor();

        public EntityField entityField();
    }
}

