/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor.extension;

import com.squareup.javapoet.ClassName;
import java.util.Collection;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.NameUtils;
import ru.tinkoff.kora.annotation.processor.common.TagUtils;
import ru.tinkoff.kora.database.annotation.processor.DbUtils;
import ru.tinkoff.kora.kora.app.annotation.processor.extension.ExtensionResult;
import ru.tinkoff.kora.kora.app.annotation.processor.extension.KoraExtension;

public class RepositoryKoraExtension
implements KoraExtension {
    private final Elements elements;
    private final Types types;

    public RepositoryKoraExtension(ProcessingEnvironment processingEnvironment) {
        this.elements = processingEnvironment.getElementUtils();
        this.types = processingEnvironment.getTypeUtils();
    }

    public KoraExtension.KoraExtensionDependencyGenerator getDependencyGenerator(RoundEnvironment roundEnvironment, TypeMirror typeMirror, Set<String> tags) {
        if (typeMirror.getKind() != TypeKind.DECLARED) {
            return null;
        }
        Element element = this.types.asElement(typeMirror);
        if (!(element.getKind() == ElementKind.INTERFACE || element.getKind() == ElementKind.CLASS && element.getModifiers().contains((Object)Modifier.ABSTRACT))) {
            return null;
        }
        if (AnnotationUtils.findAnnotation((Element)element, (ClassName)DbUtils.REPOSITORY_ANNOTATION) == null) {
            return null;
        }
        if (!TagUtils.tagsMatch(tags, (Collection)TagUtils.parseTagValue((AnnotatedConstruct)element)).booleanValue()) {
            return null;
        }
        TypeElement typeElement = (TypeElement)this.types.asElement(typeMirror);
        PackageElement packageElement = this.elements.getPackageOf(typeElement);
        String repositoryName = NameUtils.generatedType((Element)typeElement, (String)"Impl");
        Name packageName = packageElement.getQualifiedName();
        return () -> {
            TypeElement repositoryElement = this.elements.getTypeElement(String.valueOf(packageElement.getQualifiedName()) + "." + repositoryName);
            if (repositoryElement == null) {
                return ExtensionResult.nextRound();
            }
            if (!CommonUtils.hasAopAnnotations((TypeElement)repositoryElement)) {
                return (ExtensionResult)CommonUtils.findConstructors((TypeElement)repositoryElement, m -> m.contains((Object)Modifier.PUBLIC)).stream().map(ExtensionResult::fromExecutable).findFirst().orElseThrow();
            }
            String aopProxy = NameUtils.generatedType((Element)repositoryElement, (String)"_AopProxy");
            TypeElement aopProxyElement = this.elements.getTypeElement(String.valueOf(packageName) + "." + aopProxy);
            if (aopProxyElement == null) {
                return ExtensionResult.nextRound();
            }
            return (ExtensionResult)CommonUtils.findConstructors((TypeElement)aopProxyElement, m -> m.contains((Object)Modifier.PUBLIC)).stream().map(ExtensionResult::fromExecutable).findFirst().orElseThrow();
        };
    }
}

