/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor.jdbc;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.NameUtils;
import ru.tinkoff.kora.database.annotation.processor.DbEntityReadHelper;
import ru.tinkoff.kora.database.annotation.processor.entity.DbEntity;
import ru.tinkoff.kora.database.annotation.processor.jdbc.JdbcNativeType;
import ru.tinkoff.kora.database.annotation.processor.jdbc.JdbcNativeTypes;
import ru.tinkoff.kora.database.annotation.processor.jdbc.JdbcTypes;

public class JdbcEntityGenerator {
    private final DbEntityReadHelper rowMapperGenerator;
    private final Elements elements;
    private final Filer filer;

    public JdbcEntityGenerator(Types types, Elements elements, Filer filer) {
        this.rowMapperGenerator = new DbEntityReadHelper(JdbcTypes.RESULT_COLUMN_MAPPER, types, fd -> CodeBlock.of((String)"this.$L.apply(_rs, _$LColumn)", (Object[])new Object[]{fd.mapperFieldName(), fd.fieldName()}), fd -> {
            JdbcNativeType nativeType = JdbcNativeTypes.findNativeType(TypeName.get((TypeMirror)fd.type()));
            if (nativeType != null) {
                return nativeType.extract("_rs", CodeBlock.of((String)"_$LColumn", (Object[])new Object[]{fd.fieldName()}));
            }
            return null;
        }, fd -> CodeBlock.builder().beginControlFlow("if (_rs.wasNull())", new Object[0]).add(fd.nullable() ? CodeBlock.of((String)"$N = null;\n", (Object[])new Object[]{fd.fieldName()}) : CodeBlock.of((String)"throw new $T($S);\n", (Object[])new Object[]{NullPointerException.class, "Result field %s is not nullable but row %s has null".formatted(fd.fieldName(), fd.columnName())})).endControlFlow().build());
        this.elements = elements;
        this.filer = filer;
    }

    public ClassName listJdbcResultSetMapperName(TypeElement entityTypeElement) {
        String mapperName = NameUtils.generatedType((Element)entityTypeElement, (String)"ListJdbcResultSetMapper");
        PackageElement packageElement = this.elements.getPackageOf(entityTypeElement);
        return ClassName.get((String)packageElement.getQualifiedName().toString(), (String)mapperName, (String[])new String[0]);
    }

    public ClassName resultSetMapperName(TypeElement entityTypeElement) {
        String mapperName = NameUtils.generatedType((Element)entityTypeElement, (ClassName)JdbcTypes.RESULT_SET_MAPPER);
        PackageElement packageElement = this.elements.getPackageOf(entityTypeElement);
        return ClassName.get((String)packageElement.getQualifiedName().toString(), (String)mapperName, (String[])new String[0]);
    }

    public ClassName rowMapperName(TypeElement entityTypeElement) {
        String mapperName = NameUtils.generatedType((Element)entityTypeElement, (ClassName)JdbcTypes.ROW_MAPPER);
        PackageElement packageElement = this.elements.getPackageOf(entityTypeElement);
        return ClassName.get((String)packageElement.getQualifiedName().toString(), (String)mapperName, (String[])new String[0]);
    }

    public void generateListResultSetMapper(DbEntity entity) throws IOException {
        ClassName mapperClassName = this.listJdbcResultSetMapperName(entity.typeElement());
        TypeSpec.Builder type = TypeSpec.classBuilder((ClassName)mapperClassName).addOriginatingElement((Element)entity.typeElement()).addAnnotation(AnnotationUtils.generated(JdbcEntityGenerator.class)).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)JdbcTypes.RESULT_SET_MAPPER, (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)entity.typeMirror())})})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        MethodSpec.Builder apply = MethodSpec.methodBuilder((String)"apply").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(TypeName.get(ResultSet.class), "_rs", new Modifier[0]).addException(TypeName.get(SQLException.class)).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)entity.typeMirror())}));
        apply.addCode("if (!_rs.next()) {\n  return $T.of();\n}\n", new Object[]{List.class});
        apply.addCode(this.readColumnIds(entity));
        DbEntityReadHelper.ReadEntityCodeBlock row = this.rowMapperGenerator.readEntity("_row", entity);
        row.enrich(type, constructor);
        apply.addCode("var _result = new $T<$T>();\n", new Object[]{ArrayList.class, entity.typeMirror()});
        apply.addCode("do {$>\n", new Object[0]);
        apply.addCode(row.block());
        apply.addCode("_result.add(_row);\n", new Object[0]);
        apply.addCode("$<\n} while (_rs.next());\n", new Object[0]);
        apply.addCode("return _result;\n", new Object[0]);
        type.addMethod(constructor.build());
        type.addMethod(apply.build());
        JavaFile.builder((String)mapperClassName.packageName(), (TypeSpec)type.build()).build().writeTo(this.filer);
    }

    public void generateRowMapper(DbEntity entity) throws IOException {
        ClassName mapperName = this.rowMapperName(entity.typeElement());
        TypeSpec.Builder type = TypeSpec.classBuilder((ClassName)mapperName).addOriginatingElement((Element)entity.typeElement()).addAnnotation(AnnotationUtils.generated(JdbcEntityGenerator.class)).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)JdbcTypes.ROW_MAPPER, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)entity.typeMirror())})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        MethodSpec.Builder apply = MethodSpec.methodBuilder((String)"apply").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(TypeName.get(ResultSet.class), "_rs", new Modifier[0]).addException(TypeName.get(SQLException.class)).returns(TypeName.get((TypeMirror)entity.typeMirror()));
        apply.addCode(this.readColumnIds(entity));
        DbEntityReadHelper.ReadEntityCodeBlock read = this.rowMapperGenerator.readEntity("_result", entity);
        read.enrich(type, constructor);
        apply.addCode(read.block());
        apply.addCode("return _result;\n", new Object[0]);
        type.addMethod(constructor.build());
        type.addMethod(apply.build());
        JavaFile.builder((String)mapperName.packageName(), (TypeSpec)type.build()).build().writeTo(this.filer);
    }

    private CodeBlock readColumnIds(DbEntity entity) {
        CodeBlock.Builder b = CodeBlock.builder();
        for (DbEntity.Column entityField : entity.columns()) {
            String fieldName = entityField.variableName();
            b.add("var _$LColumn = _rs.findColumn($S);\n", new Object[]{fieldName, entityField.columnName()});
        }
        return b.build();
    }

    public void generateResultSetMapper(DbEntity entity) throws IOException {
        ClassName mapperName = this.resultSetMapperName(entity.typeElement());
        TypeSpec.Builder type = TypeSpec.classBuilder((ClassName)mapperName).addOriginatingElement((Element)entity.typeElement()).addAnnotation(AnnotationUtils.generated(JdbcEntityGenerator.class)).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)JdbcTypes.RESULT_SET_MAPPER, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)entity.typeMirror())})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        MethodSpec.Builder apply = MethodSpec.methodBuilder((String)"apply").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(CommonClassNames.nullable).addParameter(TypeName.get(ResultSet.class), "_rs", new Modifier[0]).addException(TypeName.get(SQLException.class)).returns(TypeName.get((TypeMirror)entity.typeMirror()));
        apply.addCode("if (!_rs.next()) {\n  return null;\n}\n", new Object[0]);
        apply.addCode(this.readColumnIds(entity));
        DbEntityReadHelper.ReadEntityCodeBlock read = this.rowMapperGenerator.readEntity("_result", entity);
        read.enrich(type, constructor);
        apply.addCode(read.block());
        apply.addCode("if (_rs.next()) {\n  throw new IllegalStateException($S);\n}\n", new Object[]{"ResultSet was expected to return zero or one row but got two or more"});
        apply.addCode("return _result;\n", new Object[0]);
        type.addMethod(constructor.build());
        type.addMethod(apply.build());
        JavaFile.builder((String)mapperName.packageName(), (TypeSpec)type.build()).build().writeTo(this.filer);
    }
}

