/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor.jdbc;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import jakarta.annotation.Nullable;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.FieldFactory;
import ru.tinkoff.kora.database.annotation.processor.QueryWithParameters;
import ru.tinkoff.kora.database.annotation.processor.entity.DbEntity;
import ru.tinkoff.kora.database.annotation.processor.jdbc.JdbcNativeType;
import ru.tinkoff.kora.database.annotation.processor.jdbc.JdbcNativeTypes;
import ru.tinkoff.kora.database.annotation.processor.jdbc.JdbcTypes;
import ru.tinkoff.kora.database.annotation.processor.model.QueryParameter;

public class StatementSetterGenerator {
    public static CodeBlock generate(ExecutableElement method, QueryWithParameters sqlWithParameters, List<QueryParameter> parameters, @Nullable QueryParameter batchParam, FieldFactory parameterMappers) {
        CodeBlock.Builder b = CodeBlock.builder();
        if (batchParam != null) {
            b.add("for (var _i : $L) {$>\n", new Object[]{batchParam.variable()});
        }
        for (int i = 0; i < parameters.size(); ++i) {
            CommonUtils.MappingData mapping;
            Object sqlParameter;
            QueryParameter parameter = parameters.get(i);
            if (parameter instanceof QueryParameter.ConnectionParameter) continue;
            int _i = i;
            String parameterName = parameter.name();
            if (parameter instanceof QueryParameter.BatchParameter) {
                QueryParameter.BatchParameter batchParameter = (QueryParameter.BatchParameter)parameter;
                parameterName = "_i";
                parameter = batchParameter.parameter();
            }
            if (parameter instanceof QueryParameter.SimpleParameter) {
                QueryParameter.SimpleParameter nativeParameter = (QueryParameter.SimpleParameter)parameter;
                sqlParameter = sqlWithParameters.parameters().stream().filter(p -> p.methodIndex() == _i).findFirst().get();
                CommonUtils.MappersData mappingData = CommonUtils.parseMapping((Element)parameter.variable());
                mapping = mappingData.getMapping(JdbcTypes.PARAMETER_COLUMN_MAPPER);
                JdbcNativeType nativeType = JdbcNativeTypes.findNativeType(TypeName.get((TypeMirror)parameter.type()));
                if (mapping == null && nativeType != null) {
                    if (CommonUtils.isNullable((AnnotatedConstruct)parameter.variable())) {
                        b.add("if ($L != null) {$>", new Object[]{parameterName});
                        for (Integer n : ((QueryWithParameters.QueryParameter)sqlParameter).sqlIndexes()) {
                            b.add("\n", new Object[0]).add(nativeType.bind("_stmt", parameterName, n + 1)).add(";", new Object[0]);
                        }
                        b.add("$<\n} else {$>", new Object[0]);
                        for (Integer n : ((QueryWithParameters.QueryParameter)sqlParameter).sqlIndexes()) {
                            b.add("\n", new Object[0]).add(nativeType.bindNull("_stmt", n + 1)).add(";", new Object[0]);
                        }
                        b.add("$<\n}\n", new Object[0]);
                    } else {
                        for (Integer n : ((QueryWithParameters.QueryParameter)sqlParameter).sqlIndexes()) {
                            b.add(nativeType.bind("_stmt", parameterName, n + 1)).add(";\n", new Object[0]);
                        }
                    }
                } else if (mapping != null && mapping.mapperClass() != null) {
                    mapper = parameterMappers.get(JdbcTypes.PARAMETER_COLUMN_MAPPER, mapping, parameter.type());
                    for (Integer idx : ((QueryWithParameters.QueryParameter)sqlParameter).sqlIndexes()) {
                        b.add("$L.set(_stmt, $L, $L);\n", new Object[]{mapper, idx + 1, parameterName});
                    }
                } else {
                    mapper = parameterMappers.get(JdbcTypes.PARAMETER_COLUMN_MAPPER, parameter.type(), (Element)parameter.variable());
                    for (Integer idx : ((QueryWithParameters.QueryParameter)sqlParameter).sqlIndexes()) {
                        b.add("$L.set(_stmt, $L, $L);\n", new Object[]{mapper, idx + 1, parameterName});
                    }
                }
            }
            if (!(parameter instanceof QueryParameter.EntityParameter)) continue;
            QueryParameter.EntityParameter ep = (QueryParameter.EntityParameter)parameter;
            for (DbEntity.Column field : ep.entity().columns()) {
                Iterator<Integer> se;
                boolean embeddedNullable;
                Object object;
                QueryWithParameters.QueryParameter sqlParameter2 = sqlWithParameters.find(field.queryParameterName(ep.name()));
                if (sqlParameter2 == null || sqlParameter2.sqlIndexes().isEmpty()) continue;
                String accessor = CodeBlock.of((String)"$N.$N()", (Object[])new Object[]{parameterName, field.accessor()}).toString();
                CommonUtils.MappersData mappingData = CommonUtils.parseMapping((Element)field.element());
                CommonUtils.MappingData mappingData2 = mappingData.getMapping(JdbcTypes.PARAMETER_COLUMN_MAPPER);
                JdbcNativeType nativeType = JdbcNativeTypes.findNativeType(TypeName.get((TypeMirror)field.type()));
                if (mappingData2 == null && nativeType != null) {
                    Integer idx2;
                    object = field.entityField();
                    boolean bl = embeddedNullable = object instanceof DbEntity.SimpleEntityField && ((DbEntity.SimpleEntityField)((Object)(se = (DbEntity.SimpleEntityField)object))).nullable() && ((DbEntity.SimpleEntityField)((Object)se)).element() != field.element();
                    if (embeddedNullable) {
                        b.add("if ($N.$N() != null) {$>\n", new Object[]{parameterName, field.entityField().accessor()});
                    }
                    if (CommonUtils.isNullable((AnnotatedConstruct)field.element())) {
                        b.add("if ($L != null) {$>", new Object[]{accessor});
                        for (Integer idx2 : sqlParameter2.sqlIndexes()) {
                            b.add("\n", new Object[0]).add(nativeType.bind("_stmt", accessor, idx2 + 1)).add(";", new Object[0]);
                        }
                        b.add("$<\n} else {$>", new Object[0]);
                        se = sqlParameter2.sqlIndexes().iterator();
                        while (se.hasNext()) {
                            idx2 = se.next();
                            b.add("\n", new Object[0]).add(nativeType.bindNull("_stmt", idx2 + 1)).add(";", new Object[0]);
                        }
                        b.add("$<\n}\n", new Object[0]);
                    } else {
                        se = sqlParameter2.sqlIndexes().iterator();
                        while (se.hasNext()) {
                            Integer idx2 = (Integer)se.next();
                            b.add(nativeType.bind("_stmt", accessor, idx2 + 1)).add(";\n", new Object[0]);
                        }
                    }
                    if (!embeddedNullable) continue;
                    b.add("$<} else {$>", new Object[0]);
                    se = sqlParameter2.sqlIndexes().iterator();
                    while (se.hasNext()) {
                        idx2 = se.next();
                        b.add("\n", new Object[0]).add(nativeType.bindNull("_stmt", idx2 + 1)).add(";", new Object[0]);
                    }
                    b.add("$<\n}\n", new Object[0]);
                    continue;
                }
                if (mappingData2 == null) {
                    object = field.entityField();
                    boolean bl = embeddedNullable = object instanceof DbEntity.SimpleEntityField && ((DbEntity.SimpleEntityField)((Object)(se = (DbEntity.SimpleEntityField)object))).nullable() && ((DbEntity.SimpleEntityField)((Object)se)).element() != field.element();
                    if (embeddedNullable) {
                        b.add("if ($N.$N() != null) {$>\n", new Object[]{parameterName, field.entityField().accessor()});
                    }
                    String mapper = parameterMappers.get(JdbcTypes.PARAMETER_COLUMN_MAPPER, field.type(), (Element)field.element());
                    for (Integer idx : sqlParameter2.sqlIndexes()) {
                        b.add("$L.set(_stmt, $L, $L);\n", new Object[]{mapper, idx + 1, accessor});
                    }
                    if (!embeddedNullable) continue;
                    b.add("$<} else {$>\n", new Object[0]);
                    for (Integer idx : sqlParameter2.sqlIndexes()) {
                        b.add("$L.set(_stmt, $L, null);\n", new Object[]{mapper, idx + 1});
                    }
                    b.add("$<}\n", new Object[0]);
                    continue;
                }
                object = field.entityField();
                boolean bl = embeddedNullable = object instanceof DbEntity.SimpleEntityField && ((DbEntity.SimpleEntityField)((Object)(se = (DbEntity.SimpleEntityField)object))).nullable() && ((DbEntity.SimpleEntityField)((Object)se)).element() != field.element();
                if (embeddedNullable) {
                    b.add("if ($N.$N() != null) {$>\n", new Object[]{parameterName, field.entityField().accessor()});
                }
                String mapper2 = parameterMappers.get(JdbcTypes.PARAMETER_COLUMN_MAPPER, mappingData2, field.type());
                for (Integer idx : sqlParameter2.sqlIndexes()) {
                    b.add("$L.set(_stmt, $L, $L);\n", new Object[]{mapper2, idx + 1, accessor});
                }
                if (!embeddedNullable) continue;
                b.add("$<} else {$>\n", new Object[0]);
                for (Integer idx : sqlParameter2.sqlIndexes()) {
                    b.add("$L.set(_stmt, $L, null);\n", new Object[]{mapper2, idx + 1});
                }
                b.add("$<}\n", new Object[0]);
            }
            sqlParameter = sqlWithParameters.find(ep.name());
            if (sqlParameter == null || ((QueryWithParameters.QueryParameter)sqlParameter).sqlIndexes().isEmpty()) continue;
            String fieldAccessor = CodeBlock.of((String)"$N", (Object[])new Object[]{parameterName}).toString();
            mapping = CommonUtils.parseMapping((Element)ep.entity().typeElement()).getMapping(JdbcTypes.PARAMETER_COLUMN_MAPPER);
            if (mapping != null && mapping.mapperClass() != null) {
                for (Integer idx : ((QueryWithParameters.QueryParameter)sqlParameter).sqlIndexes()) {
                    String string = parameterMappers.get(JdbcTypes.PARAMETER_COLUMN_MAPPER, mapping, ep.type());
                    b.add("$L.set(_stmt, $L, $L);\n", new Object[]{string, idx + 1, fieldAccessor});
                }
                continue;
            }
            for (Integer idx : ((QueryWithParameters.QueryParameter)sqlParameter).sqlIndexes()) {
                String string = parameterMappers.get(JdbcTypes.PARAMETER_COLUMN_MAPPER, ep.type(), (Element)ep.entity().typeElement());
                b.add("$L.set(_stmt, $L, $L);\n", new Object[]{string, idx + 1, fieldAccessor});
            }
        }
        if (batchParam != null) {
            b.add("_stmt.addBatch();$<\n}\n", new Object[0]);
        }
        return b.build();
    }
}

