/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor.jdbc.extension;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.GenericTypeResolver;
import ru.tinkoff.kora.annotation.processor.common.NameUtils;
import ru.tinkoff.kora.database.annotation.processor.entity.DbEntity;
import ru.tinkoff.kora.database.annotation.processor.jdbc.JdbcEntityGenerator;
import ru.tinkoff.kora.database.annotation.processor.jdbc.JdbcTypes;
import ru.tinkoff.kora.kora.app.annotation.processor.extension.ExtensionResult;
import ru.tinkoff.kora.kora.app.annotation.processor.extension.KoraExtension;

public class JdbcTypesExtension
implements KoraExtension {
    private static final ClassName LIST_CLASS_NAME = ClassName.get(List.class);
    private final Types types;
    private final Elements elements;
    private final JdbcEntityGenerator generator;
    private final Messager messager;

    public JdbcTypesExtension(ProcessingEnvironment env) {
        this.types = env.getTypeUtils();
        this.elements = env.getElementUtils();
        this.messager = env.getMessager();
        this.generator = new JdbcEntityGenerator(this.types, this.elements, env.getFiler());
    }

    private KoraExtension.KoraExtensionDependencyGenerator fromAnnotationProcessor(ClassName mapperName) {
        TypeElement maybeGenerated = this.elements.getTypeElement(mapperName.canonicalName());
        if (maybeGenerated != null) {
            List constructors = CommonUtils.findConstructors((TypeElement)maybeGenerated, m -> m.contains((Object)Modifier.PUBLIC));
            if (constructors.size() != 1) {
                throw new IllegalStateException();
            }
            return () -> ExtensionResult.fromExecutable((ExecutableElement)((ExecutableElement)constructors.get(0)));
        }
        return ExtensionResult::nextRound;
    }

    @Nullable
    public KoraExtension.KoraExtensionDependencyGenerator getDependencyGenerator(RoundEnvironment roundEnvironment, TypeMirror typeMirror, Set<String> tags) {
        if (!tags.isEmpty()) {
            return null;
        }
        if (!(typeMirror instanceof DeclaredType)) {
            return null;
        }
        DeclaredType declaredType = (DeclaredType)typeMirror;
        TypeName typeName = TypeName.get((TypeMirror)typeMirror);
        if (!(typeName instanceof ParameterizedTypeName)) {
            return null;
        }
        ParameterizedTypeName ptn = (ParameterizedTypeName)typeName;
        if (Objects.equals(ptn.rawType, JdbcTypes.ROW_MAPPER)) {
            TypeMirror rowTypeMirror = declaredType.getTypeArguments().get(0);
            TypeElement rowTypeElement = (TypeElement)((DeclaredType)rowTypeMirror).asElement();
            if (AnnotationUtils.isAnnotationPresent((Element)rowTypeElement, (ClassName)JdbcTypes.JDBC_ENTITY)) {
                return this.fromAnnotationProcessor(this.generator.rowMapperName(rowTypeElement));
            }
            DbEntity entity = DbEntity.parseEntity(this.types, rowTypeMirror);
            if (entity != null) {
                return this.entityRowMapper(typeMirror, entity);
            }
            return null;
        }
        if (Objects.equals(ptn.rawType, JdbcTypes.RESULT_SET_MAPPER)) {
            TypeElement resultTypeElement;
            TypeName resultTypeName = (TypeName)ptn.typeArguments.get(0);
            TypeMirror resultTypeMirror = declaredType.getTypeArguments().get(0);
            if (resultTypeName instanceof ParameterizedTypeName) {
                ParameterizedTypeName rptn = (ParameterizedTypeName)resultTypeName;
                if (rptn.rawType.equals((Object)LIST_CLASS_NAME) && resultTypeMirror instanceof DeclaredType) {
                    DeclaredType resultDeclaredType = (DeclaredType)resultTypeMirror;
                    TypeMirror rowTypeMirror = resultDeclaredType.getTypeArguments().get(0);
                    TypeElement rowTypeElement = (TypeElement)this.types.asElement(rowTypeMirror);
                    if (AnnotationUtils.isAnnotationPresent((Element)rowTypeElement, (ClassName)JdbcTypes.JDBC_ENTITY)) {
                        return this.fromAnnotationProcessor(this.generator.listJdbcResultSetMapperName(rowTypeElement));
                    }
                    DbEntity entity = DbEntity.parseEntity(this.types, rowTypeMirror);
                    if (entity != null) {
                        return this.entityResultListSetMapper(typeMirror, entity);
                    }
                    return () -> {
                        ExecutableElement listResultSetMapper = this.elements.getTypeElement(JdbcTypes.RESULT_SET_MAPPER.canonicalName()).getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD && e.getModifiers().contains((Object)Modifier.STATIC)).map(ExecutableElement.class::cast).filter(m -> m.getSimpleName().contentEquals("listResultSetMapper")).findFirst().orElseThrow();
                        TypeVariable tp = (TypeVariable)listResultSetMapper.getTypeParameters().get(0).asType();
                        ExecutableType executableType = (ExecutableType)GenericTypeResolver.resolve((Types)this.types, Map.of(tp, rowTypeMirror), (TypeMirror)listResultSetMapper.asType());
                        return ExtensionResult.fromExecutable((ExecutableElement)listResultSetMapper, (ExecutableType)executableType);
                    };
                }
            }
            if (AnnotationUtils.isAnnotationPresent((Element)(resultTypeElement = (TypeElement)this.types.asElement(resultTypeMirror)), (ClassName)JdbcTypes.JDBC_ENTITY)) {
                return this.fromAnnotationProcessor(this.generator.resultSetMapperName(resultTypeElement));
            }
            return () -> {
                ExecutableElement singleResultSetMapper = this.elements.getTypeElement(JdbcTypes.RESULT_SET_MAPPER.canonicalName()).getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD && e.getModifiers().contains((Object)Modifier.STATIC)).map(ExecutableElement.class::cast).filter(m -> m.getSimpleName().contentEquals("singleResultSetMapper")).findFirst().orElseThrow();
                TypeVariable tp = (TypeVariable)singleResultSetMapper.getTypeParameters().get(0).asType();
                ExecutableType executableType = (ExecutableType)GenericTypeResolver.resolve((Types)this.types, Map.of(tp, resultTypeMirror), (TypeMirror)singleResultSetMapper.asType());
                return ExtensionResult.fromExecutable((ExecutableElement)singleResultSetMapper, (ExecutableType)executableType);
            };
        }
        return null;
    }

    private KoraExtension.KoraExtensionDependencyGenerator entityRowMapper(TypeMirror mapperType, DbEntity entity) {
        return () -> {
            String mapperName = NameUtils.generatedType((Element)entity.typeElement(), (ClassName)JdbcTypes.ROW_MAPPER);
            PackageElement packageElement = this.elements.getPackageOf(entity.typeElement());
            TypeElement maybeGenerated = this.elements.getTypeElement(String.valueOf(packageElement.getQualifiedName()) + "." + mapperName);
            if (maybeGenerated != null) {
                List constructors = CommonUtils.findConstructors((TypeElement)maybeGenerated, m -> m.contains((Object)Modifier.PUBLIC));
                if (constructors.size() != 1) {
                    throw new IllegalStateException();
                }
                return ExtensionResult.fromExecutable((ExecutableElement)((ExecutableElement)constructors.get(0)));
            }
            this.messager.printMessage(Diagnostic.Kind.WARNING, "Type is not annotated with @EntityJdbc, but mapper %s is requested by graph. Generating one in graph building process will lead to another round of compiling which will slow down you build".formatted(mapperType), entity.typeElement());
            this.generator.generateRowMapper(entity);
            return ExtensionResult.nextRound();
        };
    }

    private KoraExtension.KoraExtensionDependencyGenerator entityResultListSetMapper(TypeMirror mapperType, DbEntity entity) {
        return () -> {
            String mapperName = NameUtils.generatedType((Element)entity.typeElement(), (String)"ListJdbcResultSetMapper");
            PackageElement packageElement = this.elements.getPackageOf(entity.typeElement());
            TypeElement maybeGenerated = this.elements.getTypeElement(String.valueOf(packageElement.getQualifiedName()) + "." + mapperName);
            if (maybeGenerated != null) {
                List constructors = CommonUtils.findConstructors((TypeElement)maybeGenerated, m -> m.contains((Object)Modifier.PUBLIC));
                if (constructors.size() != 1) {
                    throw new IllegalStateException();
                }
                return ExtensionResult.fromExecutable((ExecutableElement)((ExecutableElement)constructors.get(0)));
            }
            this.messager.printMessage(Diagnostic.Kind.WARNING, "Type is not annotated with @EntityJdbc, but mapper %s is requested by graph. Generating one in graph building process will lead to another round of compiling which will slow down you build".formatted(mapperType), entity.typeElement());
            this.generator.generateListResultSetMapper(entity);
            return ExtensionResult.nextRound();
        };
    }
}

