/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor.r2dbc;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import jakarta.annotation.Nullable;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.FieldFactory;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.annotation.processor.common.Visitors;
import ru.tinkoff.kora.database.annotation.processor.DbUtils;
import ru.tinkoff.kora.database.annotation.processor.QueryWithParameters;
import ru.tinkoff.kora.database.annotation.processor.RepositoryGenerator;
import ru.tinkoff.kora.database.annotation.processor.model.QueryParameter;
import ru.tinkoff.kora.database.annotation.processor.model.QueryParameterParser;
import ru.tinkoff.kora.database.annotation.processor.r2dbc.R2dbcNativeTypes;
import ru.tinkoff.kora.database.annotation.processor.r2dbc.R2dbcStatementSetterGenerator;
import ru.tinkoff.kora.database.annotation.processor.r2dbc.R2dbcTypes;

public final class R2dbcRepositoryGenerator
implements RepositoryGenerator {
    private final Types types;
    private final Elements elements;
    private final Filer filer;

    public R2dbcRepositoryGenerator(ProcessingEnvironment processingEnv) {
        this.types = processingEnv.getTypeUtils();
        this.elements = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
    }

    @Override
    @Nullable
    public ClassName repositoryInterface() {
        return R2dbcTypes.R2DBC_REPOSITORY;
    }

    @Override
    public TypeSpec generate(TypeElement repositoryElement, TypeSpec.Builder type, MethodSpec.Builder constructor) {
        DeclaredType repositoryType = (DeclaredType)repositoryElement.asType();
        List<ExecutableElement> queryMethods = DbUtils.findQueryMethods(this.types, this.elements, repositoryElement);
        this.enrichWithExecutor(repositoryElement, type, constructor);
        FieldFactory resultMappers = new FieldFactory(this.types, this.elements, type, constructor, "_result_mapper_");
        FieldFactory parameterMappers = new FieldFactory(this.types, this.elements, type, constructor, "_parameter_mapper_");
        int methodCounter = 1;
        for (ExecutableElement method : queryMethods) {
            ExecutableType methodType = (ExecutableType)this.types.asMemberOf(repositoryType, method);
            List<QueryParameter> parameters = QueryParameterParser.parse(this.types, R2dbcTypes.CONNECTION, R2dbcTypes.PARAMETER_COLUMN_MAPPER, method, methodType);
            AnnotationMirror queryAnnotation = AnnotationUtils.findAnnotation((Element)method, (ClassName)DbUtils.QUERY_ANNOTATION);
            String queryString = (String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)queryAnnotation, (String)"value");
            QueryWithParameters query = QueryWithParameters.parse(this.filer, this.types, queryString, parameters, repositoryType, method);
            String resultMapper = this.parseResultMapper(method, parameters, methodType).map(rm -> DbUtils.addMapper(resultMappers, rm)).orElse(null);
            DbUtils.addMappers(parameterMappers, DbUtils.parseParameterMappers(parameters, query, tn -> R2dbcNativeTypes.findAndBox(tn) != null, R2dbcTypes.PARAMETER_COLUMN_MAPPER));
            MethodSpec methodSpec = this.generate(type, methodCounter, method, methodType, query, parameters, resultMapper, parameterMappers);
            type.addMethod(methodSpec);
            ++methodCounter;
        }
        return type.addMethod(constructor.build()).build();
    }

    private MethodSpec generate(TypeSpec.Builder type, int methodNumber, ExecutableElement method, ExecutableType methodType, QueryWithParameters query, List<QueryParameter> parameters, @Nullable String resultMapperName, FieldFactory parameterMappers) {
        boolean generatedKeys = AnnotationUtils.isAnnotationPresent((Element)method, (ClassName)DbUtils.ID_ANNOTATION);
        String sql = query.rawQuery();
        for (QueryWithParameters.QueryParameter parameter : query.parameters().stream().sorted(Comparator.comparingInt(s -> s.sqlParameterName().length()).reversed()).toList()) {
            for (Integer sqlIndex : parameter.sqlIndexes()) {
                sql = sql.replace(":" + parameter.sqlParameterName(), "$" + (sqlIndex + 1));
            }
        }
        QueryParameter connectionParameter = parameters.stream().filter(QueryParameter.ConnectionParameter.class::isInstance).findFirst().orElse(null);
        MethodSpec.Builder b = DbUtils.queryMethodBuilder(method, methodType);
        String queryContextFieldName = "QUERY_CONTEXT_" + methodNumber;
        type.addField(FieldSpec.builder((TypeName)DbUtils.QUERY_CONTEXT, (String)queryContextFieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("new $T(\n      $S,\n      $S,\n      $S\n    )", new Object[]{DbUtils.QUERY_CONTEXT, query.rawQuery(), sql, DbUtils.operationName(method)}).build());
        b.addStatement("var _query = $L", new Object[]{queryContextFieldName});
        QueryParameter batchParam = parameters.stream().filter(QueryParameter.BatchParameter.class::isInstance).findFirst().orElse(null);
        boolean isFlux = CommonUtils.isFlux((TypeMirror)methodType.getReturnType());
        boolean isMono = CommonUtils.isMono((TypeMirror)methodType.getReturnType());
        TypeMirror returnType = isMono || isFlux ? ((DeclaredType)method.getReturnType()).getTypeArguments().get(0) : method.getReturnType();
        b.addCode("var _result = ", new Object[0]);
        b.addCode("$T.deferContextual(_reactorCtx -> {$>\n", new Object[]{isFlux ? CommonClassNames.flux : CommonClassNames.mono});
        b.addStatement("var _ctxCurrent = $T.current(_reactorCtx)", new Object[]{CommonClassNames.contextReactor});
        b.addStatement("var _ctxFork = _ctxCurrent.fork()", new Object[0]);
        b.addStatement("_ctxFork.inject()", new Object[0]);
        b.addCode("var _telemetry = this._connectionFactory.telemetry().createContext(_ctxFork, _query);\n", new Object[]{CommonClassNames.context});
        String connectionName = "_con";
        if (connectionParameter == null) {
            b.addCode("return this._connectionFactory.withConnection$L(_con -> {$>\n", new Object[]{isFlux ? "Flux" : ""});
        } else {
            connectionName = connectionParameter.name();
        }
        b.addCode("var _stmt = $N.createStatement(_query.sql());\n", new Object[]{connectionName});
        R2dbcStatementSetterGenerator.generate(b, method, query, parameters, batchParam, parameterMappers);
        if (generatedKeys) {
            b.addCode("var _flux = $T.<$T>from(_stmt.returnGeneratedValues().execute());\n", new Object[]{CommonClassNames.flux, R2dbcTypes.RESULT});
        } else {
            b.addCode("var _flux = $T.<$T>from(_stmt.execute());\n", new Object[]{CommonClassNames.flux, R2dbcTypes.RESULT});
        }
        CommonUtils.MappersData mappings = CommonUtils.parseMapping((Element)method);
        CommonUtils.MappingData resultFluxMapper = mappings.getMapping(R2dbcTypes.RESULT_FLUX_MAPPER);
        CommonUtils.MappingData rowMapper = mappings.getMapping(R2dbcTypes.ROW_MAPPER);
        if (returnType.toString().equals(DbUtils.UPDATE_COUNT.canonicalName())) {
            b.addCode("return _flux.flatMap($T::getRowsUpdated).reduce(0L, Long::sum).map($T::new)", new Object[]{R2dbcTypes.RESULT, DbUtils.UPDATE_COUNT});
        } else if (resultFluxMapper != null) {
            Objects.requireNonNull(resultMapperName, () -> "Illegal State occurred when expected to get result mapper, but got null in " + String.valueOf(method.getEnclosingElement().getSimpleName()) + "#" + String.valueOf(method.getSimpleName()));
            b.addCode("return $L.apply(_flux)\n", new Object[]{resultMapperName});
        } else if (rowMapper != null || !CommonUtils.isVoid((TypeMirror)returnType)) {
            Objects.requireNonNull(resultMapperName, () -> "Illegal State occurred when expected to get result mapper, but got null in " + String.valueOf(method.getEnclosingElement().getSimpleName()) + "#" + String.valueOf(method.getSimpleName()));
            b.addCode("return $L.apply(_flux)\n", new Object[]{resultMapperName});
        } else {
            b.addCode("return _flux.flatMap($T::getRowsUpdated).then()", new Object[]{R2dbcTypes.RESULT});
        }
        b.addCode(".doOnEach(_s -> {\n  if (_s.isOnComplete()) {\n    _telemetry.close(null);\n    _ctxCurrent.inject();\n  } else if (_s.isOnError()) {\n    _telemetry.close(_s.getThrowable());\n    _ctxCurrent.inject();\n  }\n});", new Object[0]);
        if (connectionParameter == null) {
            b.addCode("\n$<\n});\n", new Object[0]);
        }
        b.addCode("\n$<\n});\n", new Object[0]);
        if (isMono || isFlux) {
            b.addCode("return _result;\n", new Object[0]);
        } else if (returnType.getKind() == TypeKind.VOID) {
            b.addCode("_result.then().block();", new Object[0]);
        } else {
            b.addCode("return _result.block();", new Object[0]);
        }
        return b.build();
    }

    private Optional<DbUtils.Mapper> parseResultMapper(ExecutableElement method, List<QueryParameter> parameters, ExecutableType methodType) {
        TypeMirror returnType = methodType.getReturnType();
        boolean isFlux = CommonUtils.isFlux((TypeMirror)returnType);
        boolean isMono = CommonUtils.isMono((TypeMirror)returnType);
        boolean generatedKeys = AnnotationUtils.isAnnotationPresent((Element)method, (ClassName)DbUtils.ID_ANNOTATION);
        for (QueryParameter parameter : parameters) {
            TypeMirror realReturnType;
            if (!(parameter instanceof QueryParameter.BatchParameter)) continue;
            TypeMirror typeMirror = realReturnType = isMono || isFlux ? (TypeMirror)Visitors.visitDeclaredType((TypeMirror)returnType, dt -> dt.getTypeArguments().get(0)) : method.getReturnType();
            if (CommonUtils.isVoid((TypeMirror)realReturnType)) {
                return Optional.empty();
            }
            if (DbUtils.UPDATE_COUNT.canonicalName().equals(realReturnType.toString())) {
                return Optional.empty();
            }
            if (generatedKeys) continue;
            throw new ProcessingErrorException("@Batch method can't return arbitrary values, it can only return: void/UpdateCount or database-generated @Id", (Element)method);
        }
        CommonUtils.MappersData mappings = CommonUtils.parseMapping((Element)method);
        CommonUtils.MappingData resultFluxMapper = mappings.getMapping(R2dbcTypes.RESULT_FLUX_MAPPER);
        CommonUtils.MappingData rowMapper = mappings.getMapping(R2dbcTypes.ROW_MAPPER);
        if (resultFluxMapper == null && rowMapper == null && CommonUtils.isVoid((TypeMirror)returnType)) {
            return Optional.empty();
        }
        if (isMono || isFlux) {
            TypeMirror publisherParam = (TypeMirror)Visitors.visitDeclaredType((TypeMirror)returnType, dt -> dt.getTypeArguments().get(0));
            if (CommonUtils.isVoid((TypeMirror)publisherParam)) {
                return Optional.empty();
            }
            if (publisherParam.toString().equals(DbUtils.UPDATE_COUNT.canonicalName())) {
                return Optional.empty();
            }
            ParameterizedTypeName mapperType = ParameterizedTypeName.get((ClassName)R2dbcTypes.RESULT_FLUX_MAPPER, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)publisherParam), TypeName.get((TypeMirror)returnType)});
            if (resultFluxMapper != null) {
                return Optional.of(new DbUtils.Mapper(resultFluxMapper.mapperClass(), (TypeName)mapperType, resultFluxMapper.mapperTags()));
            }
            if (rowMapper != null) {
                if (isFlux) {
                    return Optional.of(new DbUtils.Mapper(rowMapper.mapperClass(), (TypeName)mapperType, rowMapper.mapperTags(), c -> CodeBlock.of((String)"$T.flux($L)", (Object[])new Object[]{R2dbcTypes.RESULT_FLUX_MAPPER, c})));
                }
                if (CommonUtils.isList((TypeMirror)publisherParam)) {
                    return Optional.of(new DbUtils.Mapper(rowMapper.mapperClass(), (TypeName)mapperType, rowMapper.mapperTags(), c -> CodeBlock.of((String)"$T.monoList($L)", (Object[])new Object[]{R2dbcTypes.RESULT_FLUX_MAPPER, c})));
                }
                if (CommonUtils.isOptional((TypeMirror)publisherParam)) {
                    return Optional.of(new DbUtils.Mapper(rowMapper.mapperClass(), (TypeName)mapperType, rowMapper.mapperTags(), c -> CodeBlock.of((String)"$T.monoOptional($L)", (Object[])new Object[]{R2dbcTypes.RESULT_FLUX_MAPPER, c})));
                }
                return Optional.of(new DbUtils.Mapper(rowMapper.mapperClass(), (TypeName)mapperType, rowMapper.mapperTags(), c -> CodeBlock.of((String)"$T.mono($L)", (Object[])new Object[]{R2dbcTypes.RESULT_FLUX_MAPPER, c})));
            }
            return Optional.of(new DbUtils.Mapper((TypeName)mapperType, mappings.mapperTags()));
        }
        TypeName monoParam = TypeName.get((TypeMirror)returnType).box();
        ParameterizedTypeName mapperType = ParameterizedTypeName.get((ClassName)R2dbcTypes.RESULT_FLUX_MAPPER, (TypeName[])new TypeName[]{monoParam, ParameterizedTypeName.get((ClassName)CommonClassNames.mono, (TypeName[])new TypeName[]{monoParam})});
        if (resultFluxMapper != null) {
            return Optional.of(new DbUtils.Mapper(resultFluxMapper.mapperClass(), (TypeName)mapperType, resultFluxMapper.mapperTags()));
        }
        if (rowMapper != null) {
            if (CommonUtils.isList((TypeMirror)returnType)) {
                return Optional.of(new DbUtils.Mapper(rowMapper.mapperClass(), (TypeName)mapperType, rowMapper.mapperTags(), c -> CodeBlock.of((String)"$T.monoList($L)", (Object[])new Object[]{R2dbcTypes.RESULT_FLUX_MAPPER, c})));
            }
            if (CommonUtils.isOptional((TypeMirror)returnType)) {
                return Optional.of(new DbUtils.Mapper(rowMapper.mapperClass(), (TypeName)mapperType, rowMapper.mapperTags(), c -> CodeBlock.of((String)"$T.monoOptional($L)", (Object[])new Object[]{R2dbcTypes.RESULT_FLUX_MAPPER, c})));
            }
            return Optional.of(new DbUtils.Mapper(rowMapper.mapperClass(), (TypeName)mapperType, rowMapper.mapperTags(), c -> CodeBlock.of((String)"$T.mono($L)", (Object[])new Object[]{R2dbcTypes.RESULT_FLUX_MAPPER, c})));
        }
        if (CommonUtils.isVoid((TypeMirror)returnType)) {
            return Optional.empty();
        }
        if (returnType.toString().equals(DbUtils.UPDATE_COUNT.canonicalName())) {
            return Optional.empty();
        }
        return Optional.of(new DbUtils.Mapper((TypeName)mapperType, mappings.mapperTags()));
    }

    private void enrichWithExecutor(TypeElement repositoryElement, TypeSpec.Builder builder, MethodSpec.Builder constructorBuilder) {
        builder.addField((TypeName)R2dbcTypes.CONNECTION_FACTORY, "_connectionFactory", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        builder.addSuperinterface((TypeName)R2dbcTypes.R2DBC_REPOSITORY);
        builder.addMethod(MethodSpec.methodBuilder((String)"getR2dbcConnectionFactory").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(Override.class).returns((TypeName)R2dbcTypes.CONNECTION_FACTORY).addCode("return this._connectionFactory;", new Object[0]).build());
        CodeBlock executorTag = DbUtils.getTag(repositoryElement);
        if (executorTag != null) {
            constructorBuilder.addParameter(ParameterSpec.builder((TypeName)R2dbcTypes.CONNECTION_FACTORY, (String)"_connectionFactory", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.tag).addMember("value", executorTag).build()).build());
        } else {
            constructorBuilder.addParameter((TypeName)R2dbcTypes.CONNECTION_FACTORY, "_connectionFactory", new Modifier[0]);
        }
        constructorBuilder.addStatement("this._connectionFactory = _connectionFactory", new Object[0]);
    }
}

