/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor.r2dbc.extension;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.GenericTypeResolver;
import ru.tinkoff.kora.annotation.processor.common.NameUtils;
import ru.tinkoff.kora.database.annotation.processor.DbEntityReadHelper;
import ru.tinkoff.kora.database.annotation.processor.entity.DbEntity;
import ru.tinkoff.kora.database.annotation.processor.r2dbc.R2dbcNativeTypes;
import ru.tinkoff.kora.database.annotation.processor.r2dbc.R2dbcTypes;
import ru.tinkoff.kora.kora.app.annotation.processor.extension.ExtensionResult;
import ru.tinkoff.kora.kora.app.annotation.processor.extension.KoraExtension;

public class R2dbcTypesExtension
implements KoraExtension {
    private final Types types;
    private final Elements elements;
    private final Filer filer;
    private final DbEntityReadHelper entityHelper;

    public R2dbcTypesExtension(ProcessingEnvironment env) {
        this.types = env.getTypeUtils();
        this.elements = env.getElementUtils();
        this.filer = env.getFiler();
        this.entityHelper = new DbEntityReadHelper(R2dbcTypes.RESULT_COLUMN_MAPPER, this.types, fd -> CodeBlock.of((String)"this.$L.apply(_row, $S)", (Object[])new Object[]{fd.mapperFieldName(), fd.columnName()}), fd -> {
            TypeName nativeType = R2dbcNativeTypes.findAndBox(TypeName.get((TypeMirror)fd.type()));
            if (nativeType != null) {
                return CodeBlock.of((String)"_row.get($S, $T.class)", (Object[])new Object[]{fd.columnName(), nativeType});
            }
            return null;
        }, fd -> fd.nullable() || fd.type().getKind().isPrimitive() ? CodeBlock.of((String)"", (Object[])new Object[0]) : CodeBlock.builder().beginControlFlow("if ($N == null)", new Object[]{fd.fieldName()}).add("throw new $T($S);\n", new Object[]{NullPointerException.class, "Result field %s is not nullable but row %s has null".formatted(fd.fieldName(), fd.columnName())}).endControlFlow().build());
    }

    @Nullable
    public KoraExtension.KoraExtensionDependencyGenerator getDependencyGenerator(RoundEnvironment roundEnvironment, TypeMirror typeMirror, Set<String> tags) {
        if (!tags.isEmpty()) {
            return null;
        }
        if (!(typeMirror instanceof DeclaredType)) {
            return null;
        }
        DeclaredType declaredType = (DeclaredType)typeMirror;
        TypeName typeName = TypeName.get((TypeMirror)typeMirror);
        if (!(typeName instanceof ParameterizedTypeName)) {
            return null;
        }
        ParameterizedTypeName ptn = (ParameterizedTypeName)typeName;
        if (Objects.equals(ptn.rawType, R2dbcTypes.ROW_MAPPER)) {
            return this.generateResultRowMapper(declaredType);
        }
        if (Objects.equals(ptn.rawType, R2dbcTypes.RESULT_FLUX_MAPPER)) {
            return this.generateResultFluxMapper(declaredType);
        }
        return null;
    }

    @Nullable
    private KoraExtension.KoraExtensionDependencyGenerator generateResultFluxMapper(DeclaredType dt) {
        TypeMirror publisherType = dt.getTypeArguments().get(1);
        if (!publisherType.toString().startsWith("reactor.core.publisher.Mono<")) {
            return null;
        }
        TypeMirror resultType = dt.getTypeArguments().get(0);
        TypeMirror rowType = ((DeclaredType)resultType).getTypeArguments().get(0);
        ExecutableElement listResultSetMapper = this.elements.getTypeElement(R2dbcTypes.RESULT_FLUX_MAPPER.canonicalName()).getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD && e.getModifiers().contains((Object)Modifier.STATIC)).map(ExecutableElement.class::cast).filter(m -> m.getSimpleName().contentEquals("monoList")).findFirst().orElseThrow();
        TypeVariable tp = (TypeVariable)listResultSetMapper.getTypeParameters().get(0).asType();
        ExecutableType executableType = (ExecutableType)GenericTypeResolver.resolve((Types)this.types, Map.of(tp, rowType), (TypeMirror)listResultSetMapper.asType());
        return () -> ExtensionResult.fromExecutable((ExecutableElement)listResultSetMapper, (ExecutableType)executableType);
    }

    @Nullable
    private KoraExtension.KoraExtensionDependencyGenerator generateResultRowMapper(DeclaredType typeMirror) {
        TypeMirror rowType = typeMirror.getTypeArguments().get(0);
        DbEntity entity = DbEntity.parseEntity(this.types, rowType);
        if (entity == null) {
            return null;
        }
        String mapperName = NameUtils.generatedType((Element)entity.typeElement(), (ClassName)R2dbcTypes.ROW_MAPPER);
        PackageElement packageElement = this.elements.getPackageOf(entity.typeElement());
        return () -> {
            TypeElement maybeGenerated = this.elements.getTypeElement(String.valueOf(packageElement.getQualifiedName()) + "." + mapperName);
            if (maybeGenerated != null) {
                List constructors = CommonUtils.findConstructors((TypeElement)maybeGenerated, m -> m.contains((Object)Modifier.PUBLIC));
                if (constructors.size() != 1) {
                    throw new IllegalStateException();
                }
                return ExtensionResult.fromExecutable((ExecutableElement)((ExecutableElement)constructors.get(0)));
            }
            TypeSpec.Builder type = TypeSpec.classBuilder((String)mapperName).addAnnotation(AnnotationUtils.generated(R2dbcTypesExtension.class)).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)R2dbcTypes.ROW_MAPPER, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)entity.typeMirror())})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
            MethodSpec.Builder apply = MethodSpec.methodBuilder((String)"apply").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter((TypeName)R2dbcTypes.ROW, "_row", new Modifier[0]).returns(TypeName.get((TypeMirror)entity.typeMirror()));
            DbEntityReadHelper.ReadEntityCodeBlock read = this.entityHelper.readEntity("_result", entity);
            read.enrich(type, constructor);
            apply.addCode(read.block());
            apply.addCode("return _result;\n", new Object[0]);
            type.addMethod(constructor.build());
            type.addMethod(apply.build());
            JavaFile.builder((String)packageElement.getQualifiedName().toString(), (TypeSpec)type.build()).build().writeTo(this.filer);
            return ExtensionResult.nextRound();
        };
    }
}

