/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.common.telemetry;

import jakarta.annotation.Nullable;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.database.common.QueryContext;
import ru.tinkoff.kora.database.common.telemetry.DataBaseLogger;
import ru.tinkoff.kora.database.common.telemetry.DataBaseMetricWriter;
import ru.tinkoff.kora.database.common.telemetry.DataBaseTelemetry;
import ru.tinkoff.kora.database.common.telemetry.DataBaseTelemetryFactory;
import ru.tinkoff.kora.database.common.telemetry.DataBaseTracer;

public class DefaultDataBaseTelemetry
implements DataBaseTelemetry {
    @Nullable
    private final DataBaseMetricWriter metricWriter;
    @Nullable
    private final DataBaseTracer tracing;
    @Nullable
    private final DataBaseLogger logger;

    public DefaultDataBaseTelemetry(@Nullable DataBaseMetricWriter metricWriter, @Nullable DataBaseTracer tracing, @Nullable DataBaseLogger logger) {
        this.metricWriter = metricWriter;
        this.tracing = tracing;
        this.logger = logger;
    }

    @Override
    public Object getMetricRegistry() {
        if (this.metricWriter == null) {
            return null;
        }
        return this.metricWriter.getMetricRegistry();
    }

    @Override
    public DataBaseTelemetry.DataBaseTelemetryContext createContext(Context ctx, QueryContext query) {
        DataBaseMetricWriter metricWriter = this.metricWriter;
        DataBaseTracer tracing = this.tracing;
        DataBaseLogger logger = this.logger;
        if (!(metricWriter != null || tracing != null || logger != null && logger.isEnabled())) {
            return DataBaseTelemetryFactory.EMPTY_CTX;
        }
        DataBaseTracer.DataBaseSpan span = tracing == null ? null : tracing.createQuerySpan(ctx, query);
        long start = System.nanoTime();
        if (logger != null) {
            logger.logQueryBegin(query);
        }
        return exception -> {
            long processingTime = System.nanoTime() - start;
            if (metricWriter != null) {
                metricWriter.recordQuery(start, query, exception);
            }
            if (logger != null) {
                logger.logQueryEnd(processingTime, query, exception);
            }
            if (span != null) {
                span.close(exception);
            }
        };
    }
}

