/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.common.telemetry;

import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import ru.tinkoff.kora.database.common.QueryContext;
import ru.tinkoff.kora.database.common.telemetry.DataBaseLogger;
import ru.tinkoff.kora.logging.common.arg.StructuredArgument;

public class DefaultDataBaseLogger
implements DataBaseLogger {
    private final Logger log;
    private final String poolName;

    public DefaultDataBaseLogger(String poolName) {
        this.poolName = poolName;
        this.log = LoggerFactory.getLogger((String)("ru.tinkoff.kora.database." + poolName + ".query"));
    }

    @Override
    public boolean isEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public void logQueryBegin(QueryContext queryContext) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.queryBeginMarker(queryContext), "SQL executing for pool '{}':\n{}", (Object)this.poolName, (Object)queryContext.sql());
        } else if (this.log.isDebugEnabled()) {
            this.log.debug(this.queryBeginMarker(queryContext), "SQL executing for pool '{}'", (Object)this.poolName);
        }
    }

    @Override
    public void logQueryEnd(long processingTime, QueryContext queryContext, @Nullable Throwable ex) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.queryEndMarker(processingTime, queryContext), "SQL executed for pool '{}':\n{}", (Object)this.poolName, (Object)queryContext.sql());
        } else if (this.log.isDebugEnabled()) {
            this.log.debug(this.queryEndMarker(processingTime, queryContext), "SQL executed for pool '{}'", (Object)this.poolName);
        }
    }

    private Marker queryBeginMarker(QueryContext queryContext) {
        return StructuredArgument.marker((String)"sqlQuery", gen -> {
            gen.writeStartObject();
            gen.writeStringField("pool", this.poolName);
            gen.writeStringField("operation", queryContext.operation());
            gen.writeStringField("queryId", queryContext.queryId());
            gen.writeEndObject();
        });
    }

    private Marker queryEndMarker(long processingTime, QueryContext queryContext) {
        return StructuredArgument.marker((String)"sqlQuery", gen -> {
            gen.writeStartObject();
            gen.writeStringField("pool", this.poolName);
            gen.writeStringField("operation", queryContext.operation());
            gen.writeStringField("queryId", queryContext.queryId());
            gen.writeNumberField("processingTime", processingTime / 1000000L);
            gen.writeEndObject();
        });
    }
}

