/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.jdbc;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import ru.tinkoff.kora.common.annotation.Generated;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.PathElement;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;
import ru.tinkoff.kora.database.jdbc.JdbcDatabaseConfig;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

@Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
public final class $JdbcDatabaseConfig_ConfigValueExtractor
implements ConfigValueExtractor<JdbcDatabaseConfig> {
    public static final JdbcDatabaseConfig_Defaults DEFAULTS = new JdbcDatabaseConfig_Defaults();
    private static final PathElement.Key _username_path = PathElement.get((String)"username");
    private static final PathElement.Key _password_path = PathElement.get((String)"password");
    private static final PathElement.Key _jdbcUrl_path = PathElement.get((String)"jdbcUrl");
    private static final PathElement.Key _poolName_path = PathElement.get((String)"poolName");
    private static final PathElement.Key _schema_path = PathElement.get((String)"schema");
    private static final PathElement.Key _connectionTimeout_path = PathElement.get((String)"connectionTimeout");
    private static final PathElement.Key _validationTimeout_path = PathElement.get((String)"validationTimeout");
    private static final PathElement.Key _idleTimeout_path = PathElement.get((String)"idleTimeout");
    private static final PathElement.Key _maxLifetime_path = PathElement.get((String)"maxLifetime");
    private static final PathElement.Key _leakDetectionThreshold_path = PathElement.get((String)"leakDetectionThreshold");
    private static final PathElement.Key _maxPoolSize_path = PathElement.get((String)"maxPoolSize");
    private static final PathElement.Key _minIdle_path = PathElement.get((String)"minIdle");
    private static final PathElement.Key _initializationFailTimeout_path = PathElement.get((String)"initializationFailTimeout");
    private static final PathElement.Key _readinessProbe_path = PathElement.get((String)"readinessProbe");
    private static final PathElement.Key _dsProperties_path = PathElement.get((String)"dsProperties");
    private static final PathElement.Key _telemetry_path = PathElement.get((String)"telemetry");
    private final ConfigValueExtractor<Duration> extractor1;
    private final ConfigValueExtractor<Duration> connectionTimeout_parser;
    private final ConfigValueExtractor<Duration> validationTimeout_parser;
    private final ConfigValueExtractor<Duration> idleTimeout_parser;
    private final ConfigValueExtractor<Duration> maxLifetime_parser;
    private final ConfigValueExtractor<Duration> leakDetectionThreshold_parser;
    private final ConfigValueExtractor<Duration> initializationFailTimeout_parser;
    private final ConfigValueExtractor<Properties> extractor2;
    private final ConfigValueExtractor<Properties> dsProperties_parser;
    private final ConfigValueExtractor<TelemetryConfig> extractor3;
    private final ConfigValueExtractor<TelemetryConfig> telemetry_parser;

    public $JdbcDatabaseConfig_ConfigValueExtractor(ConfigValueExtractor<Duration> extractor1, ConfigValueExtractor<Properties> extractor2, ConfigValueExtractor<TelemetryConfig> extractor3) {
        this.extractor1 = extractor1;
        this.connectionTimeout_parser = extractor1;
        this.validationTimeout_parser = extractor1;
        this.idleTimeout_parser = extractor1;
        this.maxLifetime_parser = extractor1;
        this.leakDetectionThreshold_parser = extractor1;
        this.initializationFailTimeout_parser = extractor1;
        this.extractor2 = extractor2;
        this.dsProperties_parser = extractor2;
        this.extractor3 = extractor3;
        this.telemetry_parser = extractor3;
    }

    public JdbcDatabaseConfig extract(ConfigValue<?> _sourceValue) {
        if (_sourceValue instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue _nullValue = (ConfigValue.NullValue)_sourceValue;
            _sourceValue = new ConfigValue.ObjectValue(_sourceValue.origin(), Map.of());
        }
        ConfigValue.ObjectValue _config = _sourceValue.asObject();
        String username = this.parse_username(_config);
        String password = this.parse_password(_config);
        String jdbcUrl = this.parse_jdbcUrl(_config);
        String poolName = this.parse_poolName(_config);
        String schema = this.parse_schema(_config);
        Duration connectionTimeout = this.parse_connectionTimeout(_config);
        Duration validationTimeout = this.parse_validationTimeout(_config);
        Duration idleTimeout = this.parse_idleTimeout(_config);
        Duration maxLifetime = this.parse_maxLifetime(_config);
        Duration leakDetectionThreshold = this.parse_leakDetectionThreshold(_config);
        int maxPoolSize = this.parse_maxPoolSize(_config);
        int minIdle = this.parse_minIdle(_config);
        Duration initializationFailTimeout = this.parse_initializationFailTimeout(_config);
        boolean readinessProbe = this.parse_readinessProbe(_config);
        Properties dsProperties = this.parse_dsProperties(_config);
        TelemetryConfig telemetry = this.parse_telemetry(_config);
        return new JdbcDatabaseConfig_Impl(username, password, jdbcUrl, poolName, schema, connectionTimeout, validationTimeout, idleTimeout, maxLifetime, leakDetectionThreshold, maxPoolSize, minIdle, initializationFailTimeout, readinessProbe, dsProperties, telemetry);
    }

    private String parse_username(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_username_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            throw ConfigValueExtractionException.missingValue((ConfigValue)nullValue);
        }
        return value.asString();
    }

    private String parse_password(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_password_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            throw ConfigValueExtractionException.missingValue((ConfigValue)nullValue);
        }
        return value.asString();
    }

    private String parse_jdbcUrl(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_jdbcUrl_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            throw ConfigValueExtractionException.missingValue((ConfigValue)nullValue);
        }
        return value.asString();
    }

    private String parse_poolName(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_poolName_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            throw ConfigValueExtractionException.missingValue((ConfigValue)nullValue);
        }
        return value.asString();
    }

    @Nullable
    private String parse_schema(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_schema_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            return null;
        }
        return value.asString();
    }

    private Duration parse_connectionTimeout(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_connectionTimeout_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Duration defaultValue = DEFAULTS.connectionTimeout();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Duration parsed = (Duration)this.connectionTimeout_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private Duration parse_validationTimeout(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_validationTimeout_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Duration defaultValue = DEFAULTS.validationTimeout();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Duration parsed = (Duration)this.validationTimeout_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private Duration parse_idleTimeout(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_idleTimeout_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Duration defaultValue = DEFAULTS.idleTimeout();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Duration parsed = (Duration)this.idleTimeout_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private Duration parse_maxLifetime(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_maxLifetime_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Duration defaultValue = DEFAULTS.maxLifetime();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Duration parsed = (Duration)this.maxLifetime_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private Duration parse_leakDetectionThreshold(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_leakDetectionThreshold_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Duration defaultValue = DEFAULTS.leakDetectionThreshold();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Duration parsed = (Duration)this.leakDetectionThreshold_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private int parse_maxPoolSize(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_maxPoolSize_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            int defaultValue = DEFAULTS.maxPoolSize();
            return defaultValue;
        }
        return value.asNumber().intValue();
    }

    private int parse_minIdle(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_minIdle_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            int defaultValue = DEFAULTS.minIdle();
            return defaultValue;
        }
        return value.asNumber().intValue();
    }

    @Nullable
    private Duration parse_initializationFailTimeout(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_initializationFailTimeout_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            return null;
        }
        return (Duration)this.initializationFailTimeout_parser.extract(value);
    }

    private boolean parse_readinessProbe(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_readinessProbe_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            boolean defaultValue = DEFAULTS.readinessProbe();
            return defaultValue;
        }
        return value.asBoolean();
    }

    private Properties parse_dsProperties(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_dsProperties_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Properties defaultValue = DEFAULTS.dsProperties();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Properties parsed = (Properties)this.dsProperties_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private TelemetryConfig parse_telemetry(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_telemetry_path);
        TelemetryConfig parsed = (TelemetryConfig)this.telemetry_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    @Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
    public record JdbcDatabaseConfig_Impl(@Nonnull String username, @Nonnull String password, @Nonnull String jdbcUrl, @Nonnull String poolName, String schema, @Nonnull Duration connectionTimeout, @Nonnull Duration validationTimeout, @Nonnull Duration idleTimeout, @Nonnull Duration maxLifetime, @Nonnull Duration leakDetectionThreshold, int maxPoolSize, int minIdle, Duration initializationFailTimeout, boolean readinessProbe, @Nonnull Properties dsProperties, @Nonnull TelemetryConfig telemetry) implements JdbcDatabaseConfig
    {
        public JdbcDatabaseConfig_Impl {
            Objects.requireNonNull(username);
            Objects.requireNonNull(password);
            Objects.requireNonNull(jdbcUrl);
            Objects.requireNonNull(poolName);
            Objects.requireNonNull(connectionTimeout);
            Objects.requireNonNull(validationTimeout);
            Objects.requireNonNull(idleTimeout);
            Objects.requireNonNull(maxLifetime);
            Objects.requireNonNull(leakDetectionThreshold);
            Objects.requireNonNull(dsProperties);
            Objects.requireNonNull(telemetry);
        }
    }

    @Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
    public static final class JdbcDatabaseConfig_Defaults
    implements JdbcDatabaseConfig {
        @Override
        public String username() {
            return null;
        }

        @Override
        public String password() {
            return null;
        }

        @Override
        public String jdbcUrl() {
            return null;
        }

        @Override
        public String poolName() {
            return null;
        }

        @Override
        public String schema() {
            return null;
        }

        @Override
        public Duration initializationFailTimeout() {
            return null;
        }

        @Override
        public TelemetryConfig telemetry() {
            return null;
        }
    }
}

