/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.jdbc;

import jakarta.annotation.Nullable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.database.common.QueryContext;
import ru.tinkoff.kora.database.common.telemetry.DataBaseTelemetry;
import ru.tinkoff.kora.database.jdbc.JdbcHelper;
import ru.tinkoff.kora.database.jdbc.RuntimeSqlException;

public interface JdbcConnectionFactory {
    public <T> T withConnection(JdbcHelper.SqlFunction1<Connection, T> var1) throws RuntimeSqlException;

    @Nullable
    public Connection currentConnection();

    public Connection newConnection();

    public DataBaseTelemetry telemetry();

    default public <T> T query(QueryContext queryContext, JdbcHelper.SqlFunction1<PreparedStatement, T> callback) {
        DataBaseTelemetry.DataBaseTelemetryContext telemetry = this.telemetry().createContext(Context.current(), queryContext);
        return (T)this.withConnection((Connection connection) -> {
            Object r;
            block8: {
                PreparedStatement ps = connection.prepareStatement(queryContext.sql());
                try {
                    Object result = callback.apply(ps);
                    telemetry.close(null);
                    r = result;
                    if (ps == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        telemetry.close((Throwable)e);
                        throw e;
                    }
                }
                ps.close();
            }
            return r;
        });
    }

    default public <T> T withConnection(JdbcHelper.SqlFunction0<T> callback) throws RuntimeSqlException {
        return (T)this.withConnection((Connection connection) -> callback.apply());
    }

    default public void withConnection(JdbcHelper.SqlConsumer<Connection> callback) throws RuntimeSqlException {
        this.withConnection((Connection connection) -> {
            callback.accept((Connection)connection);
            return null;
        });
    }

    default public void withConnection(JdbcHelper.SqlRunnable callback) throws RuntimeSqlException {
        this.withConnection((Connection connection) -> {
            callback.run();
            return null;
        });
    }

    default public <T> T inTx(JdbcHelper.SqlFunction1<Connection, T> callback) throws RuntimeSqlException {
        return (T)this.withConnection((Connection connection) -> {
            if (!connection.getAutoCommit()) {
                return callback.apply((Connection)connection);
            }
            connection.setAutoCommit(false);
            try {
                Object result = callback.apply((Connection)connection);
                connection.commit();
                connection.setAutoCommit(true);
                return result;
            }
            catch (Exception e) {
                try {
                    connection.rollback();
                    connection.setAutoCommit(true);
                }
                catch (SQLException sqlException) {
                    e.addSuppressed(sqlException);
                }
                throw e;
            }
        });
    }

    default public <T> T inTx(JdbcHelper.SqlFunction0<T> callback) throws RuntimeSqlException {
        return (T)this.inTx((Connection connection) -> callback.apply());
    }

    default public void inTx(JdbcHelper.SqlConsumer<Connection> callback) throws RuntimeSqlException {
        this.inTx((Connection connection) -> {
            callback.accept((Connection)connection);
            return null;
        });
    }

    default public void inTx(JdbcHelper.SqlRunnable callback) throws RuntimeSqlException {
        this.inTx((Connection connection) -> {
            callback.run();
            return null;
        });
    }
}

