/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.jdbc;

import com.zaxxer.hikari.HikariDataSource;
import jakarta.annotation.Nullable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.application.graph.Wrapped;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.common.readiness.ReadinessProbe;
import ru.tinkoff.kora.common.readiness.ReadinessProbeFailure;
import ru.tinkoff.kora.common.util.TimeUtils;
import ru.tinkoff.kora.database.common.telemetry.DataBaseTelemetry;
import ru.tinkoff.kora.database.common.telemetry.DataBaseTelemetryFactory;
import ru.tinkoff.kora.database.jdbc.JdbcConnectionFactory;
import ru.tinkoff.kora.database.jdbc.JdbcDatabaseConfig;
import ru.tinkoff.kora.database.jdbc.JdbcHelper;
import ru.tinkoff.kora.database.jdbc.RuntimeSqlException;

public class JdbcDatabase
implements Lifecycle,
Wrapped<DataSource>,
JdbcConnectionFactory,
ReadinessProbe {
    private static final Logger logger = LoggerFactory.getLogger(JdbcDatabase.class);
    final Context.Key<Connection> connectionKey = new Context.Key<Connection>(){

        protected Connection copy(Connection object) {
            return null;
        }
    };
    private final JdbcDatabaseConfig databaseConfig;
    private final HikariDataSource dataSource;
    private final DataBaseTelemetry telemetry;
    @Nullable
    final Executor executor;

    public JdbcDatabase(JdbcDatabaseConfig config, DataBaseTelemetryFactory telemetryFactory) {
        this(config, telemetryFactory, null);
    }

    public JdbcDatabase(JdbcDatabaseConfig databaseConfig, DataBaseTelemetry telemetry) {
        this(databaseConfig, telemetry, null);
    }

    public JdbcDatabase(JdbcDatabaseConfig config, DataBaseTelemetryFactory telemetryFactory, @Nullable Executor executor) {
        this(config, JdbcDatabase.getTelemetry(config, telemetryFactory), executor);
    }

    public JdbcDatabase(JdbcDatabaseConfig databaseConfig, DataBaseTelemetry telemetry, @Nullable Executor executor) {
        this.databaseConfig = Objects.requireNonNull(databaseConfig);
        this.telemetry = Objects.requireNonNull(telemetry);
        this.dataSource = new HikariDataSource(JdbcDatabaseConfig.toHikariConfig(this.databaseConfig));
        if (telemetry.getMetricRegistry() != null) {
            this.dataSource.setMetricRegistry(telemetry.getMetricRegistry());
        }
        this.executor = executor;
    }

    private static DataBaseTelemetry getTelemetry(JdbcDatabaseConfig config, DataBaseTelemetryFactory factory) {
        String jdbcUrl = config.jdbcUrl();
        DataBaseTelemetry telemetry = factory.get(config.telemetry(), config.poolName(), "jdbc", jdbcUrl.substring(4, jdbcUrl.indexOf(":", 5)), config.username());
        return Objects.requireNonNullElse(telemetry, DataBaseTelemetryFactory.EMPTY);
    }

    public void init() throws SQLException {
        if (this.databaseConfig.initializationFailTimeout() != null) {
            logger.debug("JdbcDatabase pool '{}' starting...", (Object)this.databaseConfig.poolName());
            long started = System.nanoTime();
            try (Connection connection = this.dataSource.getConnection();){
                connection.isValid((int)this.databaseConfig.initializationFailTimeout().toMillis());
            }
            logger.info("JdbcDatabase pool '{}' started in {}", (Object)this.databaseConfig.poolName(), (Object)TimeUtils.tookForLogging((long)started));
        }
    }

    public void release() {
        logger.debug("JdbcDatabase pool '{}' stopping...", (Object)this.databaseConfig.poolName());
        long started = System.nanoTime();
        this.dataSource.close();
        logger.info("JdbcDatabase pool '{}' stopped in {}", (Object)this.databaseConfig.poolName(), (Object)TimeUtils.tookForLogging((long)started));
    }

    public DataSource value() {
        return this.dataSource;
    }

    @Override
    @Nullable
    public Connection newConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    public DataBaseTelemetry telemetry() {
        return this.telemetry;
    }

    @Override
    @Nullable
    public Connection currentConnection() {
        Context ctx = Context.current();
        return (Connection)ctx.get(this.connectionKey);
    }

    @Override
    public <T> T withConnection(JdbcHelper.SqlFunction1<Connection, T> callback) throws RuntimeSqlException {
        Context ctx = Context.current();
        Connection currentConnection = (Connection)ctx.get(this.connectionKey);
        if (currentConnection != null) {
            try {
                return callback.apply(currentConnection);
            }
            catch (SQLException e) {
                throw new RuntimeSqlException(e);
            }
        }
        try {
            T t;
            block14: {
                Connection connection = (Connection)ctx.set(this.connectionKey, (Object)this.newConnection());
                try {
                    t = callback.apply(connection);
                    if (connection == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RuntimeSqlException(e);
                    }
                }
                connection.close();
            }
            return t;
        }
        finally {
            ctx.remove(this.connectionKey);
        }
    }

    public ReadinessProbeFailure probe() throws Exception {
        if (this.databaseConfig.readinessProbe()) {
            try (Connection c = this.dataSource.getConnection();){
                c.isValid((int)this.databaseConfig.validationTimeout().toMillis());
            }
        }
        return null;
    }
}

