/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.jdbc;

import com.zaxxer.hikari.HikariConfig;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Properties;
import ru.tinkoff.kora.config.common.annotation.ConfigValueExtractor;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

@ConfigValueExtractor
public interface JdbcDatabaseConfig {
    public String username();

    public String password();

    public String jdbcUrl();

    public String poolName();

    @Nullable
    public String schema();

    default public Duration connectionTimeout() {
        return Duration.ofSeconds(10L);
    }

    default public Duration validationTimeout() {
        return Duration.ofSeconds(5L);
    }

    default public Duration idleTimeout() {
        return Duration.ofMinutes(10L);
    }

    default public Duration maxLifetime() {
        return Duration.ofMinutes(15L);
    }

    default public Duration leakDetectionThreshold() {
        return Duration.ofSeconds(0L);
    }

    default public int maxPoolSize() {
        return 10;
    }

    default public int minIdle() {
        return 0;
    }

    @Nullable
    public Duration initializationFailTimeout();

    default public boolean readinessProbe() {
        return false;
    }

    default public Properties dsProperties() {
        return new Properties();
    }

    public TelemetryConfig telemetry();

    public static HikariConfig toHikariConfig(JdbcDatabaseConfig config) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setConnectionTimeout(config.connectionTimeout().toMillis());
        hikariConfig.setValidationTimeout(config.validationTimeout().toMillis());
        hikariConfig.setIdleTimeout(config.idleTimeout().toMillis());
        hikariConfig.setMaxLifetime(config.maxLifetime().toMillis());
        hikariConfig.setLeakDetectionThreshold(config.leakDetectionThreshold().toMillis());
        hikariConfig.setMaximumPoolSize(config.maxPoolSize());
        hikariConfig.setMinimumIdle(config.minIdle());
        hikariConfig.setUsername(config.username());
        hikariConfig.setPassword(config.password());
        hikariConfig.setJdbcUrl(config.jdbcUrl());
        hikariConfig.setPoolName(config.poolName());
        hikariConfig.setInitializationFailTimeout(-1L);
        hikariConfig.setAutoCommit(true);
        hikariConfig.setSchema(config.schema());
        hikariConfig.setDataSourceProperties(config.dsProperties());
        hikariConfig.setRegisterMbeans(false);
        return hikariConfig;
    }
}

