/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.jdbc;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Optional;
import java.util.UUID;
import ru.tinkoff.kora.common.DefaultComponent;
import ru.tinkoff.kora.database.common.DataBaseModule;
import ru.tinkoff.kora.database.jdbc.mapper.parameter.JdbcParameterColumnMapper;
import ru.tinkoff.kora.database.jdbc.mapper.result.JdbcResultColumnMapper;
import ru.tinkoff.kora.database.jdbc.mapper.result.JdbcResultSetMapper;
import ru.tinkoff.kora.database.jdbc.mapper.result.JdbcRowMapper;

public interface JdbcModule
extends DataBaseModule {
    default public <T> JdbcResultSetMapper<Optional<T>> optionalResultSetMapper(JdbcRowMapper<T> rowMapper) {
        return JdbcResultSetMapper.optionalResultSetMapper(rowMapper);
    }

    default public JdbcRowMapper<Boolean> booleanJdbcRowMapper() {
        return rs -> {
            boolean value = rs.getBoolean(1);
            if (rs.wasNull()) {
                return null;
            }
            return value;
        };
    }

    default public JdbcRowMapper<Short> shortJdbcRowMapper() {
        return rs -> {
            short value = rs.getShort(1);
            if (rs.wasNull()) {
                return null;
            }
            return value;
        };
    }

    default public JdbcRowMapper<Integer> integerJdbcRowMapper() {
        return rs -> {
            int value = rs.getInt(1);
            if (rs.wasNull()) {
                return null;
            }
            return value;
        };
    }

    default public JdbcRowMapper<Long> longJdbcRowMapper() {
        return rs -> {
            long value = rs.getLong(1);
            if (rs.wasNull()) {
                return null;
            }
            return value;
        };
    }

    default public JdbcRowMapper<Double> doubleJdbcRowMapper() {
        return rs -> {
            double value = rs.getDouble(1);
            if (rs.wasNull()) {
                return null;
            }
            return value;
        };
    }

    default public JdbcRowMapper<Float> floatJdbcRowMapper() {
        return rs -> {
            float value = rs.getFloat(1);
            if (rs.wasNull()) {
                return null;
            }
            return Float.valueOf(value);
        };
    }

    default public JdbcRowMapper<String> stringJdbcRowMapper() {
        return rs -> {
            String value = rs.getString(1);
            if (rs.wasNull()) {
                return null;
            }
            return value;
        };
    }

    default public JdbcRowMapper<byte[]> byteArrayJdbcRowMapper() {
        return rs -> {
            byte[] value = rs.getBytes(1);
            if (rs.wasNull()) {
                return null;
            }
            return value;
        };
    }

    @DefaultComponent
    default public JdbcRowMapper<BigDecimal> bigDecimalJdbcRowMapper() {
        return rs -> {
            BigDecimal value = rs.getObject(1, BigDecimal.class);
            if (rs.wasNull()) {
                return null;
            }
            return value;
        };
    }

    @DefaultComponent
    default public JdbcRowMapper<UUID> uuidJdbcRowMapper() {
        return rs -> {
            UUID value = rs.getObject(1, UUID.class);
            if (rs.wasNull()) {
                return null;
            }
            return value;
        };
    }

    @DefaultComponent
    default public JdbcRowMapper<LocalDate> localDateJdbcRowMapper() {
        return rs -> {
            LocalDate value = rs.getObject(1, LocalDate.class);
            if (rs.wasNull()) {
                return null;
            }
            return value;
        };
    }

    @DefaultComponent
    default public JdbcRowMapper<LocalTime> localTimeJdbcRowMapper() {
        return rs -> {
            LocalTime value = rs.getObject(1, LocalTime.class);
            if (rs.wasNull()) {
                return null;
            }
            return value;
        };
    }

    @DefaultComponent
    default public JdbcRowMapper<LocalDateTime> localDateTimeJdbcRowMapper() {
        return rs -> {
            LocalDateTime value = rs.getObject(1, LocalDateTime.class);
            if (rs.wasNull()) {
                return null;
            }
            return value;
        };
    }

    @DefaultComponent
    default public JdbcRowMapper<OffsetTime> offsetTimeJdbcRowMapper() {
        return rs -> {
            OffsetTime value = rs.getObject(1, OffsetTime.class);
            if (rs.wasNull()) {
                return null;
            }
            return value;
        };
    }

    @DefaultComponent
    default public JdbcRowMapper<OffsetDateTime> offsetDateTimeJdbcRowMapper() {
        return rs -> {
            OffsetDateTime value = rs.getObject(1, OffsetDateTime.class);
            if (rs.wasNull()) {
                return null;
            }
            return value;
        };
    }

    @DefaultComponent
    default public JdbcParameterColumnMapper<BigDecimal> bigDecimalJdbcParameterColumnMapper() {
        return (stmt, index, o) -> {
            if (o == null) {
                stmt.setNull(index, 2);
            } else {
                stmt.setObject(index, o, 2);
            }
        };
    }

    @DefaultComponent
    default public JdbcParameterColumnMapper<UUID> uuidJdbcParameterColumnMapper() {
        return (stmt, index, o) -> {
            if (o == null) {
                stmt.setNull(index, 1111);
            } else {
                stmt.setObject(index, o, 1111);
            }
        };
    }

    @DefaultComponent
    default public JdbcParameterColumnMapper<LocalDate> localDateJdbcParameterColumnMapper() {
        return (stmt, index, o) -> {
            if (o == null) {
                stmt.setNull(index, 91);
            } else {
                stmt.setObject(index, o, 91);
            }
        };
    }

    @DefaultComponent
    default public JdbcParameterColumnMapper<LocalTime> localTimeJdbcParameterColumnMapper() {
        return (stmt, index, o) -> {
            if (o == null) {
                stmt.setNull(index, 92);
            } else {
                stmt.setObject(index, o, 92);
            }
        };
    }

    @DefaultComponent
    default public JdbcParameterColumnMapper<LocalDateTime> LocalDateTimeJdbcParameterColumnMapper() {
        return (stmt, index, o) -> {
            if (o == null) {
                stmt.setNull(index, 93);
            } else {
                stmt.setObject(index, o, 93);
            }
        };
    }

    @DefaultComponent
    default public JdbcParameterColumnMapper<OffsetTime> offsetTimeJdbcParameterColumnMapper() {
        return (stmt, index, o) -> {
            if (o == null) {
                stmt.setNull(index, 2013);
            } else {
                stmt.setObject(index, o, 2013);
            }
        };
    }

    @DefaultComponent
    default public JdbcParameterColumnMapper<OffsetDateTime> offsetDateTimeJdbcParameterColumnMapper() {
        return (stmt, index, o) -> {
            if (o == null) {
                stmt.setNull(index, 2014);
            } else {
                stmt.setObject(index, o, 2014);
            }
        };
    }

    @DefaultComponent
    default public JdbcResultColumnMapper<BigDecimal> bigDecimalJdbcResultColumnMapper() {
        return (row, index) -> {
            BigDecimal value = row.getObject(index, BigDecimal.class);
            if (row.wasNull()) {
                return null;
            }
            return value;
        };
    }

    @DefaultComponent
    default public JdbcResultColumnMapper<UUID> uuidJdbcResultColumnMapper() {
        return (row, index) -> {
            UUID value = row.getObject(index, UUID.class);
            if (row.wasNull()) {
                return null;
            }
            return value;
        };
    }

    @DefaultComponent
    default public JdbcResultColumnMapper<LocalDate> localDateJdbcColumnMapper() {
        return (row, index) -> {
            LocalDate value = row.getObject(index, LocalDate.class);
            if (row.wasNull()) {
                return null;
            }
            return value;
        };
    }

    @DefaultComponent
    default public JdbcResultColumnMapper<LocalTime> localTimeJdbcColumnMapper() {
        return (row, index) -> {
            LocalTime value = row.getObject(index, LocalTime.class);
            if (row.wasNull()) {
                return null;
            }
            return value;
        };
    }

    @DefaultComponent
    default public JdbcResultColumnMapper<LocalDateTime> localDateTimeJdbcColumnMapper() {
        return (row, index) -> {
            LocalDateTime value = row.getObject(index, LocalDateTime.class);
            if (row.wasNull()) {
                return null;
            }
            return value;
        };
    }

    @DefaultComponent
    default public JdbcResultColumnMapper<OffsetTime> offsetTimeJdbcColumnMapper() {
        return (row, index) -> {
            OffsetTime value = row.getObject(index, OffsetTime.class);
            if (row.wasNull()) {
                return null;
            }
            return value;
        };
    }

    @DefaultComponent
    default public JdbcResultColumnMapper<OffsetDateTime> offsetDateTimeJdbcColumnMapper() {
        return (row, index) -> {
            OffsetDateTime value = row.getObject(index, OffsetDateTime.class);
            if (row.wasNull()) {
                return null;
            }
            return value;
        };
    }
}

