/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.jdbc.mapper.result;

import jakarta.annotation.Nullable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import ru.tinkoff.kora.common.Mapping;
import ru.tinkoff.kora.database.jdbc.mapper.result.JdbcRowMapper;

public interface JdbcResultSetMapper<T>
extends Mapping.MappingFunction {
    @Nullable
    public T apply(ResultSet var1) throws SQLException;

    public static <T> JdbcResultSetMapper<T> singleResultSetMapper(JdbcRowMapper<T> rowMapper) {
        return rs -> {
            if (!rs.next()) {
                return null;
            }
            return rowMapper.apply(rs);
        };
    }

    public static <T> JdbcResultSetMapper<List<T>> listResultSetMapper(JdbcRowMapper<T> rowMapper) {
        return rs -> {
            ArrayList list = new ArrayList();
            while (rs.next()) {
                Object row = rowMapper.apply(rs);
                list.add(row);
            }
            return list;
        };
    }

    public static <T> JdbcResultSetMapper<Optional<T>> optionalResultSetMapper(JdbcRowMapper<T> rowMapper) {
        return rs -> {
            if (rs.next()) {
                return Optional.ofNullable(rowMapper.apply(rs));
            }
            return Optional.empty();
        };
    }
}

