/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.r2dbc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.List;
import java.util.UUID;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import ru.tinkoff.kora.common.DefaultComponent;
import ru.tinkoff.kora.database.common.DataBaseModule;
import ru.tinkoff.kora.database.r2dbc.mapper.parameter.R2dbcParameterColumnMapper;
import ru.tinkoff.kora.database.r2dbc.mapper.result.R2dbcResultColumnMapper;
import ru.tinkoff.kora.database.r2dbc.mapper.result.R2dbcResultFluxMapper;
import ru.tinkoff.kora.database.r2dbc.mapper.result.R2dbcRowMapper;

public interface R2dbcModule
extends DataBaseModule {
    default public <T> R2dbcResultFluxMapper<T, Mono<T>> monoR2dbcResultFluxMapper(R2dbcRowMapper<T> rowMapper) {
        return R2dbcResultFluxMapper.mono(rowMapper);
    }

    default public <T> R2dbcResultFluxMapper<List<T>, Mono<List<T>>> monoListR2dbcResultFluxMapper(R2dbcRowMapper<T> rowMapper) {
        return R2dbcResultFluxMapper.monoList(rowMapper);
    }

    default public <T> R2dbcResultFluxMapper<T, Flux<T>> fluxR2dbcResultFluxMapper(R2dbcRowMapper<T> rowMapper) {
        return R2dbcResultFluxMapper.flux(rowMapper);
    }

    default public R2dbcRowMapper<String> stringR2dbcRowMapper() {
        return row -> (String)row.get(0, String.class);
    }

    default public R2dbcRowMapper<Short> shortR2dbcRowMapper() {
        return row -> (Short)row.get(0, Short.class);
    }

    default public R2dbcRowMapper<Integer> integerR2dbcRowMapper() {
        return row -> (Integer)row.get(0, Integer.class);
    }

    default public R2dbcRowMapper<Long> longR2dbcRowMapper() {
        return row -> (Long)row.get(0, Long.class);
    }

    default public R2dbcRowMapper<Double> doubleR2dbcRowMapper() {
        return row -> (Double)row.get(0, Double.class);
    }

    default public R2dbcRowMapper<BigDecimal> bigDecimalR2dbcRowMapper() {
        return row -> (BigDecimal)row.get(0, BigDecimal.class);
    }

    @DefaultComponent
    default public R2dbcRowMapper<BigInteger> bigIntegerR2dbcRowMapper() {
        return row -> (BigInteger)row.get(0, BigInteger.class);
    }

    default public R2dbcRowMapper<byte[]> byteArrayR2dbcRowMapper() {
        return row -> (byte[])row.get(0, byte[].class);
    }

    @DefaultComponent
    default public R2dbcRowMapper<UUID> uuidR2dbcRowMapper() {
        return row -> (UUID)row.get(0, UUID.class);
    }

    @DefaultComponent
    default public R2dbcRowMapper<LocalDate> localDateR2dbcRowMapper() {
        return row -> (LocalDate)row.get(0, LocalDate.class);
    }

    @DefaultComponent
    default public R2dbcRowMapper<LocalTime> localTimeR2dbcRowMapper() {
        return row -> (LocalTime)row.get(0, LocalTime.class);
    }

    @DefaultComponent
    default public R2dbcRowMapper<LocalDateTime> localDateTimeR2dbcRowMapper() {
        return row -> (LocalDateTime)row.get(0, LocalDateTime.class);
    }

    @DefaultComponent
    default public R2dbcRowMapper<OffsetTime> offsetTimeR2dbcRowMapper() {
        return row -> (OffsetTime)row.get(0, OffsetTime.class);
    }

    @DefaultComponent
    default public R2dbcRowMapper<OffsetDateTime> offsetDateTimeR2dbcRowMapper() {
        return row -> (OffsetDateTime)row.get(0, OffsetDateTime.class);
    }

    @DefaultComponent
    default public R2dbcParameterColumnMapper<BigDecimal> bigDecimalR2dbcParameterColumnMapper() {
        return (stmt, index, o) -> {
            if (o == null) {
                stmt.bindNull(index, BigDecimal.class);
            } else {
                stmt.bind(index, o);
            }
        };
    }

    @DefaultComponent
    default public R2dbcParameterColumnMapper<UUID> uuidR2dbcParameterColumnMapper() {
        return (stmt, index, o) -> {
            if (o == null) {
                stmt.bindNull(index, UUID.class);
            } else {
                stmt.bind(index, o);
            }
        };
    }

    @DefaultComponent
    default public R2dbcParameterColumnMapper<LocalDate> localDateR2dbcParameterColumnMapper() {
        return (stmt, index, o) -> {
            if (o == null) {
                stmt.bindNull(index, LocalDate.class);
            } else {
                stmt.bind(index, o);
            }
        };
    }

    @DefaultComponent
    default public R2dbcParameterColumnMapper<LocalTime> LocalTimeR2dbcParameterColumnMapper() {
        return (stmt, index, o) -> {
            if (o == null) {
                stmt.bindNull(index, LocalTime.class);
            } else {
                stmt.bind(index, o);
            }
        };
    }

    @DefaultComponent
    default public R2dbcParameterColumnMapper<LocalDateTime> LocalDateTimeR2dbcParameterColumnMapper() {
        return (stmt, index, o) -> {
            if (o == null) {
                stmt.bindNull(index, LocalDateTime.class);
            } else {
                stmt.bind(index, o);
            }
        };
    }

    @DefaultComponent
    default public R2dbcParameterColumnMapper<OffsetTime> offsetTimeR2dbcParameterColumnMapper() {
        return (stmt, index, o) -> {
            if (o == null) {
                stmt.bindNull(index, OffsetTime.class);
            } else {
                stmt.bind(index, o);
            }
        };
    }

    @DefaultComponent
    default public R2dbcParameterColumnMapper<OffsetDateTime> OffsetDateTimeR2dbcParameterColumnMapper() {
        return (stmt, index, o) -> {
            if (o == null) {
                stmt.bindNull(index, OffsetDateTime.class);
            } else {
                stmt.bind(index, o);
            }
        };
    }

    @DefaultComponent
    default public R2dbcResultColumnMapper<BigDecimal> bigDecimalR2dbcResultColumnMapper() {
        return (row, label) -> (BigDecimal)row.get(label, BigDecimal.class);
    }

    @DefaultComponent
    default public R2dbcResultColumnMapper<UUID> uuidR2dbcResultColumnMapper() {
        return (row, label) -> (UUID)row.get(label, UUID.class);
    }

    @DefaultComponent
    default public R2dbcResultColumnMapper<LocalDate> localDateR2dbcResultColumnMapper() {
        return (row, label) -> (LocalDate)row.get(label, LocalDate.class);
    }

    @DefaultComponent
    default public R2dbcResultColumnMapper<LocalTime> localTimeR2dbcResultColumnMapper() {
        return (row, label) -> (LocalTime)row.get(label, LocalTime.class);
    }

    @DefaultComponent
    default public R2dbcResultColumnMapper<LocalDateTime> localDateTimeR2dbcResultColumnMapper() {
        return (row, label) -> (LocalDateTime)row.get(label, LocalDateTime.class);
    }

    @DefaultComponent
    default public R2dbcResultColumnMapper<OffsetTime> offsetTimeR2dbcResultColumnMapper() {
        return (row, label) -> (OffsetTime)row.get(label, OffsetTime.class);
    }

    @DefaultComponent
    default public R2dbcResultColumnMapper<OffsetDateTime> offsetDateTimeR2dbcResultColumnMapper() {
        return (row, label) -> (OffsetDateTime)row.get(label, OffsetDateTime.class);
    }
}

