/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.r2dbc.mapper.result;

import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import java.util.List;
import java.util.Optional;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import ru.tinkoff.kora.common.Mapping;
import ru.tinkoff.kora.database.r2dbc.mapper.result.R2dbcRowMapper;

public interface R2dbcResultFluxMapper<T, P extends Publisher<T>>
extends Mapping.MappingFunction {
    public static <T> R2dbcResultFluxMapper<T, Mono<T>> mono(R2dbcRowMapper<T> rowMapper) {
        return resultFlux -> resultFlux.flatMap(result -> result.map((row, meta) -> rowMapper.apply((Row)row))).takeLast(1).next();
    }

    public static <T> R2dbcResultFluxMapper<List<T>, Mono<List<T>>> monoList(R2dbcRowMapper<T> rowMapper) {
        return resultFlux -> resultFlux.flatMap(result -> result.map((row, meta) -> rowMapper.apply((Row)row))).collectList();
    }

    public static <T> R2dbcResultFluxMapper<Optional<T>, Mono<Optional<T>>> monoOptional(R2dbcRowMapper<T> rowMapper) {
        return resultFlux -> resultFlux.flatMap(result -> result.map((row, meta) -> rowMapper.apply((Row)row))).takeLast(1).next().map(Optional::of).defaultIfEmpty(Optional.empty());
    }

    public static <T> R2dbcResultFluxMapper<T, Flux<T>> flux(R2dbcRowMapper<T> rowMapper) {
        return resultFlux -> resultFlux.flatMap(result -> result.map((row, meta) -> rowMapper.apply((Row)row)));
    }

    public P apply(Flux<Result> var1);
}

