/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.vertx;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import ru.tinkoff.kora.common.annotation.Generated;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.PathElement;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;
import ru.tinkoff.kora.database.vertx.VertxDatabaseConfig;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

@Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
public final class $VertxDatabaseConfig_ConfigValueExtractor
implements ConfigValueExtractor<VertxDatabaseConfig> {
    public static final VertxDatabaseConfig_Defaults DEFAULTS = new VertxDatabaseConfig_Defaults();
    private static final PathElement.Key _connectionUri_path = PathElement.get((String)"connectionUri");
    private static final PathElement.Key _username_path = PathElement.get((String)"username");
    private static final PathElement.Key _password_path = PathElement.get((String)"password");
    private static final PathElement.Key _poolName_path = PathElement.get((String)"poolName");
    private static final PathElement.Key _connectionTimeout_path = PathElement.get((String)"connectionTimeout");
    private static final PathElement.Key _idleTimeout_path = PathElement.get((String)"idleTimeout");
    private static final PathElement.Key _acquireTimeout_path = PathElement.get((String)"acquireTimeout");
    private static final PathElement.Key _maxPoolSize_path = PathElement.get((String)"maxPoolSize");
    private static final PathElement.Key _cachePreparedStatements_path = PathElement.get((String)"cachePreparedStatements");
    private static final PathElement.Key _readinessProbe_path = PathElement.get((String)"readinessProbe");
    private static final PathElement.Key _initializationFailTimeout_path = PathElement.get((String)"initializationFailTimeout");
    private static final PathElement.Key _telemetry_path = PathElement.get((String)"telemetry");
    private final ConfigValueExtractor<Duration> extractor1;
    private final ConfigValueExtractor<Duration> connectionTimeout_parser;
    private final ConfigValueExtractor<Duration> idleTimeout_parser;
    private final ConfigValueExtractor<Duration> acquireTimeout_parser;
    private final ConfigValueExtractor<Boolean> extractor2;
    private final ConfigValueExtractor<Boolean> cachePreparedStatements_parser;
    private final ConfigValueExtractor<Boolean> readinessProbe_parser;
    private final ConfigValueExtractor<Duration> initializationFailTimeout_parser;
    private final ConfigValueExtractor<TelemetryConfig> extractor3;
    private final ConfigValueExtractor<TelemetryConfig> telemetry_parser;

    public $VertxDatabaseConfig_ConfigValueExtractor(ConfigValueExtractor<Duration> extractor1, ConfigValueExtractor<Boolean> extractor2, ConfigValueExtractor<TelemetryConfig> extractor3) {
        this.extractor1 = extractor1;
        this.connectionTimeout_parser = extractor1;
        this.idleTimeout_parser = extractor1;
        this.acquireTimeout_parser = extractor1;
        this.extractor2 = extractor2;
        this.cachePreparedStatements_parser = extractor2;
        this.readinessProbe_parser = extractor2;
        this.initializationFailTimeout_parser = extractor1;
        this.extractor3 = extractor3;
        this.telemetry_parser = extractor3;
    }

    public VertxDatabaseConfig extract(ConfigValue<?> _sourceValue) {
        if (_sourceValue instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue _nullValue = (ConfigValue.NullValue)_sourceValue;
            _sourceValue = new ConfigValue.ObjectValue(_sourceValue.origin(), Map.of());
        }
        ConfigValue.ObjectValue _config = _sourceValue.asObject();
        String connectionUri = this.parse_connectionUri(_config);
        String username = this.parse_username(_config);
        String password = this.parse_password(_config);
        String poolName = this.parse_poolName(_config);
        Duration connectionTimeout = this.parse_connectionTimeout(_config);
        Duration idleTimeout = this.parse_idleTimeout(_config);
        Duration acquireTimeout = this.parse_acquireTimeout(_config);
        int maxPoolSize = this.parse_maxPoolSize(_config);
        boolean cachePreparedStatements = this.parse_cachePreparedStatements(_config);
        boolean readinessProbe = this.parse_readinessProbe(_config);
        Duration initializationFailTimeout = this.parse_initializationFailTimeout(_config);
        TelemetryConfig telemetry = this.parse_telemetry(_config);
        return new VertxDatabaseConfig_Impl(connectionUri, username, password, poolName, connectionTimeout, idleTimeout, acquireTimeout, maxPoolSize, cachePreparedStatements, readinessProbe, initializationFailTimeout, telemetry);
    }

    private String parse_connectionUri(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_connectionUri_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            throw ConfigValueExtractionException.missingValue((ConfigValue)nullValue);
        }
        return value.asString();
    }

    private String parse_username(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_username_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            throw ConfigValueExtractionException.missingValue((ConfigValue)nullValue);
        }
        return value.asString();
    }

    private String parse_password(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_password_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            throw ConfigValueExtractionException.missingValue((ConfigValue)nullValue);
        }
        return value.asString();
    }

    private String parse_poolName(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_poolName_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            throw ConfigValueExtractionException.missingValue((ConfigValue)nullValue);
        }
        return value.asString();
    }

    private Duration parse_connectionTimeout(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_connectionTimeout_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Duration defaultValue = DEFAULTS.connectionTimeout();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Duration parsed = (Duration)this.connectionTimeout_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private Duration parse_idleTimeout(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_idleTimeout_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Duration defaultValue = DEFAULTS.idleTimeout();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Duration parsed = (Duration)this.idleTimeout_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    @Nullable
    private Duration parse_acquireTimeout(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_acquireTimeout_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            return null;
        }
        return (Duration)this.acquireTimeout_parser.extract(value);
    }

    private int parse_maxPoolSize(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_maxPoolSize_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            int defaultValue = DEFAULTS.maxPoolSize();
            return defaultValue;
        }
        return value.asNumber().intValue();
    }

    private boolean parse_cachePreparedStatements(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_cachePreparedStatements_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            boolean defaultValue = DEFAULTS.cachePreparedStatements();
            return defaultValue;
        }
        Boolean parsed = (Boolean)this.cachePreparedStatements_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private boolean parse_readinessProbe(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_readinessProbe_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            boolean defaultValue = DEFAULTS.readinessProbe();
            return defaultValue;
        }
        Boolean parsed = (Boolean)this.readinessProbe_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    @Nullable
    private Duration parse_initializationFailTimeout(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_initializationFailTimeout_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            return null;
        }
        return (Duration)this.initializationFailTimeout_parser.extract(value);
    }

    private TelemetryConfig parse_telemetry(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_telemetry_path);
        TelemetryConfig parsed = (TelemetryConfig)this.telemetry_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    @Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
    public record VertxDatabaseConfig_Impl(@Nonnull String connectionUri, @Nonnull String username, @Nonnull String password, @Nonnull String poolName, @Nonnull Duration connectionTimeout, @Nonnull Duration idleTimeout, Duration acquireTimeout, int maxPoolSize, boolean cachePreparedStatements, boolean readinessProbe, Duration initializationFailTimeout, @Nonnull TelemetryConfig telemetry) implements VertxDatabaseConfig
    {
        public VertxDatabaseConfig_Impl {
            Objects.requireNonNull(connectionUri);
            Objects.requireNonNull(username);
            Objects.requireNonNull(password);
            Objects.requireNonNull(poolName);
            Objects.requireNonNull(connectionTimeout);
            Objects.requireNonNull(idleTimeout);
            Objects.requireNonNull(telemetry);
        }
    }

    @Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
    public static final class VertxDatabaseConfig_Defaults
    implements VertxDatabaseConfig {
        @Override
        public String connectionUri() {
            return null;
        }

        @Override
        public String username() {
            return null;
        }

        @Override
        public String password() {
            return null;
        }

        @Override
        public String poolName() {
            return null;
        }

        @Override
        public Duration acquireTimeout() {
            return null;
        }

        @Override
        public Duration initializationFailTimeout() {
            return null;
        }

        @Override
        public TelemetryConfig telemetry() {
            return null;
        }
    }
}

