/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.vertx;

import io.netty.channel.EventLoopGroup;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Transaction;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.application.graph.Wrapped;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.common.readiness.ReadinessProbe;
import ru.tinkoff.kora.common.readiness.ReadinessProbeFailure;
import ru.tinkoff.kora.common.util.TimeUtils;
import ru.tinkoff.kora.database.common.telemetry.DataBaseTelemetry;
import ru.tinkoff.kora.database.common.telemetry.DataBaseTelemetryFactory;
import ru.tinkoff.kora.database.vertx.VertxConnectionFactory;
import ru.tinkoff.kora.database.vertx.VertxDatabaseConfig;
import ru.tinkoff.kora.vertx.common.VertxUtil;

public class VertxDatabase
implements Lifecycle,
Wrapped<Pool>,
VertxConnectionFactory,
ReadinessProbe {
    private static final Logger logger = LoggerFactory.getLogger(VertxDatabase.class);
    private final Context.Key<SqlConnection> connectionKey = new Context.Key<SqlConnection>(){

        protected SqlConnection copy(SqlConnection object) {
            return null;
        }
    };
    private final Context.Key<Transaction> transactionKey = new Context.Key<Transaction>(){

        protected Transaction copy(Transaction object) {
            return null;
        }
    };
    private final Pool pool;
    private final DataBaseTelemetry telemetry;
    private final VertxDatabaseConfig config;

    public VertxDatabase(VertxDatabaseConfig vertxDatabaseConfig, EventLoopGroup eventLoopGroup, DataBaseTelemetryFactory telemetryFactory) {
        this.config = vertxDatabaseConfig;
        this.pool = Pool.pool((Vertx)VertxUtil.customEventLoopVertx((EventLoopGroup)eventLoopGroup), (SqlConnectOptions)VertxDatabaseConfig.toPgConnectOptions(vertxDatabaseConfig), (PoolOptions)VertxDatabaseConfig.toPgPoolOptions(vertxDatabaseConfig));
        this.telemetry = Objects.requireNonNullElse(telemetryFactory.get(vertxDatabaseConfig.telemetry(), vertxDatabaseConfig.poolName(), "vertx", "postgres", vertxDatabaseConfig.username()), DataBaseTelemetryFactory.EMPTY);
    }

    @Override
    public SqlConnection currentConnection() {
        Context ctx = Context.current();
        return (SqlConnection)ctx.get(this.connectionKey);
    }

    @Override
    public CompletionStage<SqlConnection> newConnection() {
        return this.pool.getConnection().toCompletionStage();
    }

    @Override
    public Pool pool() {
        return this.pool;
    }

    @Override
    public DataBaseTelemetry telemetry() {
        return this.telemetry;
    }

    @Override
    public <T> CompletionStage<T> withConnection(Function<SqlConnection, CompletionStage<T>> callback) {
        Context ctx = Context.current();
        SqlConnection currentConnection = (SqlConnection)ctx.get(this.connectionKey);
        if (currentConnection != null) {
            return callback.apply(currentConnection);
        }
        return this.pool.withConnection(connection -> {
            ctx.set(this.connectionKey, connection);
            Promise f = Promise.promise();
            Context old = Context.current();
            try {
                ctx.inject();
                ((CompletionStage)callback.apply((SqlConnection)connection)).whenComplete((result, error) -> {
                    Context old1 = Context.current();
                    try {
                        ctx.inject();
                        if (error != null) {
                            f.fail(error);
                        } else {
                            f.complete(result);
                        }
                    }
                    finally {
                        old1.inject();
                    }
                });
            }
            finally {
                old.inject();
            }
            return f.future();
        }).toCompletionStage();
    }

    @Override
    public <T> CompletionStage<T> inTx(Function<SqlConnection, CompletionStage<T>> callback) {
        Context ctx = Context.current();
        return this.withConnection(connection -> {
            Transaction currentTransaction = (Transaction)ctx.get(this.transactionKey);
            if (currentTransaction != null) {
                return (CompletionStage)callback.apply((SqlConnection)connection);
            }
            CompletableFuture future2 = new CompletableFuture();
            connection.begin(txEvent -> {
                ctx.inject();
                if (txEvent.failed()) {
                    future2.completeExceptionally(txEvent.cause());
                    return;
                }
                Transaction tx = (Transaction)txEvent.result();
                ctx.set(this.transactionKey, (Object)tx);
                ((CompletionStage)callback.apply((SqlConnection)connection)).whenComplete((result, error) -> {
                    if (error != null) {
                        tx.rollback(v -> {
                            Context oldCtx = Context.current();
                            try {
                                ctx.inject();
                                if (v.failed()) {
                                    error.addSuppressed(v.cause());
                                }
                                future2.completeExceptionally((Throwable)error);
                            }
                            finally {
                                ctx.remove(this.transactionKey);
                                oldCtx.inject();
                            }
                        });
                    } else {
                        tx.commit(v -> {
                            Context oldCtx1 = Context.current();
                            try {
                                ctx.inject();
                                if (v.succeeded()) {
                                    future2.complete(result);
                                } else {
                                    future2.completeExceptionally(v.cause());
                                }
                            }
                            finally {
                                ctx.remove(this.transactionKey);
                                oldCtx1.inject();
                            }
                        });
                    }
                });
            });
            return future2;
        });
    }

    public void init() throws Exception {
        if (this.config.initializationFailTimeout() != null) {
            logger.debug("VertxDatabase pool '{}' starting...", (Object)this.config.poolName());
            long started = System.nanoTime();
            this.pool.query("SELECT 1").execute().toCompletionStage().toCompletableFuture().get(this.config.initializationFailTimeout().toMillis(), TimeUnit.MILLISECONDS);
            logger.info("VertxDatabase pool '{}' started in {}", (Object)this.config.poolName(), (Object)TimeUtils.tookForLogging((long)started));
        }
    }

    public void release() {
        logger.debug("VertxDatabase pool '{}' stopping...", (Object)this.config.poolName());
        long started = System.nanoTime();
        this.pool.close().toCompletionStage().toCompletableFuture().join();
        logger.info("VertxDatabase pool '{}' stopped in {}", (Object)this.config.poolName(), (Object)TimeUtils.tookForLogging((long)started));
    }

    public Pool value() {
        return this.pool;
    }

    @Nullable
    public ReadinessProbeFailure probe() throws Exception {
        if (this.config.readinessProbe()) {
            this.pool.query("SELECT 1").execute().toCompletionStage().toCompletableFuture().get();
        }
        return null;
    }
}

