/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.vertx;

import io.vertx.core.buffer.Buffer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.UUID;
import ru.tinkoff.kora.database.common.DataBaseModule;
import ru.tinkoff.kora.database.vertx.mapper.result.VertxRowMapper;
import ru.tinkoff.kora.database.vertx.mapper.result.VertxRowSetMapper;
import ru.tinkoff.kora.netty.common.NettyCommonModule;
import ru.tinkoff.kora.vertx.common.VertxCommonModule;

public interface VertxDatabaseBaseModule
extends NettyCommonModule,
VertxCommonModule,
DataBaseModule {
    default public <T> VertxRowSetMapper<Optional<T>> vertxOptionalRowSetMapper(VertxRowMapper<T> rowMapper) {
        return VertxRowSetMapper.optionalRowSetMapper(rowMapper);
    }

    default public VertxRowSetMapper<Void> voidRowSetMapper() {
        return rows -> null;
    }

    default public VertxRowMapper<String> stringVertxRowMapper() {
        return row -> row.getString(0);
    }

    default public VertxRowMapper<Short> shortVertxRowMapper() {
        return row -> row.getShort(0);
    }

    default public VertxRowMapper<Integer> integerVertxRowMapper() {
        return row -> row.getInteger(0);
    }

    default public VertxRowMapper<Long> longVertxRowMapper() {
        return row -> row.getLong(0);
    }

    default public VertxRowMapper<Double> doubleVertxRowMapper() {
        return row -> row.getDouble(0);
    }

    default public VertxRowMapper<Float> floatVertxRowMapper() {
        return row -> row.getFloat(0);
    }

    default public VertxRowMapper<Boolean> booleanVertxRowMapper() {
        return row -> row.getBoolean(0);
    }

    default public VertxRowMapper<Buffer> bufferVertxRowMapper() {
        return row -> row.getBuffer(0);
    }

    default public VertxRowMapper<LocalDate> localDateVertxRowMapper() {
        return row -> row.getLocalDate(0);
    }

    default public VertxRowMapper<LocalDateTime> localDateTimeVertxRowMapper() {
        return row -> row.getLocalDateTime(0);
    }

    default public VertxRowMapper<BigDecimal> bigDecimalTimeVertxRowMapper() {
        return row -> row.getNumeric(0).bigDecimalValue();
    }

    default public VertxRowMapper<BigInteger> bigIntegerTimeVertxRowMapper() {
        return row -> row.getNumeric(0).bigIntegerValue();
    }

    default public VertxRowMapper<UUID> uuidTimeVertxRowMapper() {
        return row -> row.getUUID(0);
    }
}

