/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.vertx;

import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Objects;
import ru.tinkoff.kora.config.common.annotation.ConfigValueExtractor;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

@ConfigValueExtractor
public interface VertxDatabaseConfig {
    public String connectionUri();

    public String username();

    public String password();

    public String poolName();

    default public Duration connectionTimeout() {
        return Duration.ofSeconds(10L);
    }

    default public Duration idleTimeout() {
        return Duration.ofMinutes(10L);
    }

    @Nullable
    public Duration acquireTimeout();

    default public int maxPoolSize() {
        return 10;
    }

    default public boolean cachePreparedStatements() {
        return true;
    }

    default public boolean readinessProbe() {
        return false;
    }

    @Nullable
    public Duration initializationFailTimeout();

    public static SqlConnectOptions toPgConnectOptions(VertxDatabaseConfig config) {
        SqlConnectOptions options = SqlConnectOptions.fromUri((String)config.connectionUri());
        options.setCachePreparedStatements(config.cachePreparedStatements()).setUser(config.username()).setPassword(config.password()).setConnectTimeout(Math.toIntExact(config.connectionTimeout().toMillis())).setIdleTimeout(Math.toIntExact(config.idleTimeout().toMillis())).setMetricsName(config.poolName());
        return options;
    }

    public static PoolOptions toPgPoolOptions(VertxDatabaseConfig config) {
        return new PoolOptions().setIdleTimeout(Math.toIntExact(config.idleTimeout().toMillis())).setConnectionTimeout(Math.toIntExact(Objects.requireNonNullElse(config.acquireTimeout(), config.connectionTimeout()).toMillis())).setName(config.poolName()).setMaxSize(config.maxPoolSize());
    }

    public TelemetryConfig telemetry();
}

