/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.vertx;

import io.vertx.sqlclient.PreparedStatement;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.RowStream;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Tuple;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.database.common.QueryContext;
import ru.tinkoff.kora.database.common.UpdateCount;
import ru.tinkoff.kora.database.common.telemetry.DataBaseTelemetry;
import ru.tinkoff.kora.database.vertx.VertxConnectionFactory;
import ru.tinkoff.kora.database.vertx.mapper.result.VertxRowMapper;
import ru.tinkoff.kora.database.vertx.mapper.result.VertxRowSetMapper;

public final class VertxRepositoryHelper {
    private VertxRepositoryHelper() {
    }

    public static <T> CompletableFuture<T> completionStage(VertxConnectionFactory connectionFactory, QueryContext query, Tuple params, VertxRowSetMapper<T> mapper) {
        SqlConnection connection = connectionFactory.currentConnection();
        if (connection != null) {
            return VertxRepositoryHelper.completionStage((SqlClient)connection, connectionFactory.telemetry(), query, params, mapper);
        }
        return connectionFactory.newConnection().toCompletableFuture().thenCompose(c -> VertxRepositoryHelper.completionStage((SqlClient)c, connectionFactory.telemetry(), query, params, mapper).whenComplete((t, throwable) -> c.close()));
    }

    public static <T> CompletableFuture<T> completionStage(SqlClient connection, DataBaseTelemetry dataBaseTelemetry, QueryContext query, Tuple params, VertxRowSetMapper<T> mapper) {
        Context ctx = Context.current();
        DataBaseTelemetry.DataBaseTelemetryContext telemetry = dataBaseTelemetry.createContext(ctx, query);
        CompletableFuture future2 = new CompletableFuture();
        connection.preparedQuery(query.sql()).execute(params, rowSetEvent -> {
            Object result;
            ctx.inject();
            if (rowSetEvent.failed()) {
                telemetry.close(rowSetEvent.cause());
                future2.completeExceptionally(rowSetEvent.cause());
                return;
            }
            try {
                RowSet rowSet = (RowSet)rowSetEvent.result();
                result = mapper.apply((RowSet<Row>)rowSet);
            }
            catch (Exception e) {
                telemetry.close((Throwable)e);
                future2.completeExceptionally(e);
                return;
            }
            telemetry.close(null);
            future2.complete(result);
        });
        return future2;
    }

    public static CompletableFuture<UpdateCount> batchCompletionStage(VertxConnectionFactory connectionFactory, QueryContext query, List<Tuple> params) {
        SqlConnection connection = connectionFactory.currentConnection();
        if (connection != null) {
            return VertxRepositoryHelper.batchCompletionStage((SqlClient)connection, connectionFactory.telemetry(), query, params);
        }
        return connectionFactory.newConnection().toCompletableFuture().thenCompose(c -> VertxRepositoryHelper.batchCompletionStage((SqlClient)c, connectionFactory.telemetry(), query, params).whenComplete((t, throwable) -> c.close()));
    }

    public static CompletableFuture<UpdateCount> batchCompletionStage(SqlClient connection, DataBaseTelemetry dataBaseTelemetry, QueryContext query, List<Tuple> params) {
        Context ctx = Context.current();
        DataBaseTelemetry.DataBaseTelemetryContext telemetry = dataBaseTelemetry.createContext(ctx, query);
        CompletableFuture<UpdateCount> future2 = new CompletableFuture<UpdateCount>();
        connection.preparedQuery(query.sql()).executeBatch(params, rowSetEvent -> {
            ctx.inject();
            if (rowSetEvent.failed()) {
                telemetry.close(rowSetEvent.cause());
                future2.completeExceptionally(rowSetEvent.cause());
                return;
            }
            int result = 0;
            try {
                for (RowSet rowSet = (RowSet)rowSetEvent.result(); rowSet != null; rowSet = rowSet.next()) {
                    result += rowSet.rowCount();
                }
            }
            catch (Exception e) {
                telemetry.close((Throwable)e);
                future2.completeExceptionally(e);
                return;
            }
            telemetry.close(null);
            future2.complete(new UpdateCount((long)result));
        });
        return future2;
    }

    public static class Reactor {
        private Reactor() {
        }

        public static <T> Mono<T> mono(VertxConnectionFactory connectionFactory, QueryContext query, Tuple params, VertxRowSetMapper<T> mapper) {
            return Mono.defer(() -> {
                SqlConnection connection = connectionFactory.currentConnection();
                DataBaseTelemetry telemetry = connectionFactory.telemetry();
                if (connection != null) {
                    return Reactor.mono((SqlClient)connection, telemetry, query, params, mapper);
                }
                return Mono.usingWhen((Publisher)Mono.fromCompletionStage(connectionFactory.newConnection()), c -> Reactor.mono((SqlClient)c, telemetry, query, params, mapper), $connection -> Mono.fromRunnable(() -> ((SqlConnection)$connection).close()));
            });
        }

        public static <T> Mono<T> mono(SqlClient connection, DataBaseTelemetry dataBaseTelemetry, QueryContext query, Tuple params, VertxRowSetMapper<T> mapper) {
            return Mono.create(sink -> {
                DataBaseTelemetry.DataBaseTelemetryContext telemetry = dataBaseTelemetry.createContext(Context.Reactor.current((ContextView)sink.contextView()), query);
                connection.preparedQuery(query.sql()).execute(params, rowSetEvent -> {
                    if (rowSetEvent.failed()) {
                        telemetry.close(rowSetEvent.cause());
                        sink.error(rowSetEvent.cause());
                        return;
                    }
                    try {
                        RowSet rowSet = (RowSet)rowSetEvent.result();
                        Object result = mapper.apply((RowSet<Row>)rowSet);
                        telemetry.close(null);
                        sink.success(result);
                    }
                    catch (Exception e) {
                        telemetry.close((Throwable)e);
                        sink.error((Throwable)e);
                    }
                });
            });
        }

        public static Mono<UpdateCount> batchMono(VertxConnectionFactory connectionFactory, QueryContext query, List<Tuple> params) {
            return Mono.defer(() -> {
                SqlConnection connection = connectionFactory.currentConnection();
                if (connection != null) {
                    return Reactor.batchMono((SqlClient)connection, connectionFactory.telemetry(), query, params);
                }
                return Mono.usingWhen((Publisher)Mono.fromCompletionStage(connectionFactory.newConnection()), c -> Reactor.batchMono((SqlClient)c, connectionFactory.telemetry(), query, params), $connection -> Mono.fromRunnable(() -> ((SqlConnection)$connection).close()));
            });
        }

        public static Mono<UpdateCount> batchMono(SqlClient connection, DataBaseTelemetry dataBaseTelemetry, QueryContext query, List<Tuple> params) {
            return Mono.create(sink -> {
                DataBaseTelemetry.DataBaseTelemetryContext telemetry = dataBaseTelemetry.createContext(Context.Reactor.current((ContextView)sink.contextView()), query);
                connection.preparedQuery(query.sql()).executeBatch(params, rowSetEvent -> {
                    if (rowSetEvent.failed()) {
                        telemetry.close(rowSetEvent.cause());
                        sink.error(rowSetEvent.cause());
                        return;
                    }
                    long counter = 0L;
                    try {
                        for (RowSet current = (RowSet)rowSetEvent.result(); current != null; current = current.next()) {
                            counter += (long)current.rowCount();
                        }
                    }
                    catch (Exception e) {
                        telemetry.close((Throwable)e);
                        sink.error((Throwable)e);
                        return;
                    }
                    telemetry.close(null);
                    sink.success((Object)new UpdateCount(counter));
                });
            });
        }

        public static <T> Flux<T> flux(VertxConnectionFactory connectionFactory, QueryContext query, Tuple params, VertxRowMapper<T> mapper) {
            return Flux.defer(() -> {
                SqlConnection connection = connectionFactory.currentConnection();
                if (connection != null) {
                    return Reactor.flux(connection, connectionFactory.telemetry(), query, params, mapper);
                }
                return Flux.usingWhen((Publisher)Mono.fromCompletionStage(connectionFactory.newConnection()), c -> Reactor.flux(c, connectionFactory.telemetry(), query, params, mapper), $connection -> Mono.fromRunnable(() -> ((SqlConnection)$connection).close()));
            });
        }

        public static <T> Flux<T> flux(SqlConnection connection, DataBaseTelemetry dataBaseTelemetry, QueryContext query, Tuple params, VertxRowMapper<T> mapper) {
            return Flux.create(sink -> {
                DataBaseTelemetry.DataBaseTelemetryContext telemetry = dataBaseTelemetry.createContext(Context.Reactor.current((ContextView)sink.contextView()), query);
                connection.prepare(query.sql(), statementEvent -> {
                    if (statementEvent.failed()) {
                        telemetry.close(statementEvent.cause());
                        sink.error(statementEvent.cause());
                        return;
                    }
                    PreparedStatement stmt = (PreparedStatement)statementEvent.result();
                    RowStream stream = stmt.createStream(50, params).pause();
                    sink.onDispose(() -> ((RowStream)stream).close());
                    sink.onRequest(arg_0 -> ((RowStream)stream).fetch(arg_0));
                    stream.exceptionHandler(e -> {
                        stmt.close();
                        telemetry.close(e);
                        sink.error(e);
                    });
                    stream.endHandler(v -> {
                        stmt.close();
                        telemetry.close(null);
                        sink.complete();
                    });
                    stream.handler(row -> {
                        Object mappedRow = mapper.apply((Row)row);
                        sink.next(mappedRow);
                    });
                });
            });
        }
    }
}

