/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.vertx.mapper.result;

import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import ru.tinkoff.kora.common.Mapping;
import ru.tinkoff.kora.database.common.UpdateCount;
import ru.tinkoff.kora.database.vertx.mapper.result.VertxRowMapper;

public interface VertxRowSetMapper<T>
extends Mapping.MappingFunction {
    @Nullable
    public T apply(RowSet<Row> var1);

    public static UpdateCount extractUpdateCount(RowSet<Row> rowSet) {
        long result = 0L;
        while (rowSet != null) {
            result += (long)rowSet.rowCount();
            rowSet = rowSet.next();
        }
        return new UpdateCount(result);
    }

    public static <T> VertxRowSetMapper<Optional<T>> optionalRowSetMapper(VertxRowMapper<T> rowMapper) {
        return rows -> {
            if (rows.size() < 1) {
                return Optional.empty();
            }
            Row row = (Row)rows.iterator().next();
            return Optional.ofNullable(rowMapper.apply(row));
        };
    }

    public static <T> VertxRowSetMapper<List<T>> listRowSetMapper(VertxRowMapper<T> rowMapper) {
        return rows -> {
            ArrayList result = new ArrayList(rows.size());
            for (Row row : rows) {
                Object value = rowMapper.apply(row);
                result.add(value);
            }
            return result;
        };
    }

    public static <T> VertxRowSetMapper<T> singleRowSetMapper(VertxRowMapper<T> rowMapper) {
        return rows -> {
            if (rows.size() < 1) {
                return null;
            }
            Row row = (Row)rows.iterator().next();
            return rowMapper.apply(row);
        };
    }
}

