/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.grpc.client.annotation.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.grpc.client.annotation.processor.GrpcClassNames;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.kora.app.annotation.processor.extension.ExtensionResult;
import ru.tinkoff.kora.kora.app.annotation.processor.extension.KoraExtension;

public final class GrpcClientExtension
implements KoraExtension {
    private final ProcessingEnvironment env;
    private final TypeMirror stubErasure;

    public GrpcClientExtension(ProcessingEnvironment env, TypeMirror stubErasure) {
        this.env = env;
        this.stubErasure = Objects.requireNonNull(stubErasure);
    }

    @Nullable
    public KoraExtension.KoraExtensionDependencyGenerator getDependencyGenerator(RoundEnvironment roundEnvironment, TypeMirror typeMirror, Set<String> tag) {
        if (typeMirror.getKind() != TypeKind.DECLARED) {
            return null;
        }
        DeclaredType dt = (DeclaredType)typeMirror;
        TypeElement te = (TypeElement)dt.asElement();
        ClassName className = ClassName.get((TypeElement)te);
        if (this.env.getTypeUtils().isAssignable(typeMirror, this.stubErasure)) {
            return this.getStubGenerator(typeMirror, tag);
        }
        if (className.equals((Object)GrpcClassNames.channel) && tag.size() == 1) {
            return this.getChannel(typeMirror, tag);
        }
        if (className.equals((Object)GrpcClassNames.grpcClientConfig) && tag.size() == 1) {
            return this.getConfig(typeMirror, tag);
        }
        return null;
    }

    private KoraExtension.KoraExtensionDependencyGenerator getConfig(TypeMirror typeMirror, Set<String> tag) {
        String grpcServiceTypeName = tag.iterator().next();
        ClassName grpcServiceClassName = ClassName.bestGuess((String)grpcServiceTypeName);
        TypeElement clientConfigTypeElement = this.env.getElementUtils().getTypeElement(GrpcClassNames.grpcClientConfig.canonicalName());
        ExecutableElement factoryMethod = this.findStaticMethod(clientConfigTypeElement, "defaultConfig");
        ArrayList parameterTags = new ArrayList(factoryMethod.getParameters().size() - 1);
        ArrayList<TypeMirror> parameterTypes = new ArrayList<TypeMirror>(factoryMethod.getParameters().size() - 1);
        for (int i = 0; i < factoryMethod.getParameters().size() - 1; ++i) {
            VariableElement parameter = factoryMethod.getParameters().get(i);
            parameterTypes.add(parameter.asType());
            parameterTags.add(Set.of());
        }
        return () -> new ExtensionResult.CodeBlockResult((Element)factoryMethod, params -> CodeBlock.of((String)"$T.defaultConfig($L, $T.SERVICE_NAME)", (Object[])new Object[]{GrpcClassNames.grpcClientConfig, params, grpcServiceClassName}), typeMirror, tag, (List)parameterTypes, (List)parameterTags);
    }

    private KoraExtension.KoraExtensionDependencyGenerator getChannel(TypeMirror typeMirror, Set<String> tag) {
        TypeElement grpcServiceTypeElement = this.env.getElementUtils().getTypeElement(tag.iterator().next());
        ClassName grpcServiceClassName = ClassName.get((TypeElement)grpcServiceTypeElement);
        TypeElement managedChannelTypeElement = this.env.getElementUtils().getTypeElement(GrpcClassNames.managedChannelLifecycle.canonicalName());
        TypeMirror managedChannelTypeMirror = managedChannelTypeElement.asType();
        ExecutableElement managedChannelConstructor = (ExecutableElement)CommonUtils.findConstructors((TypeElement)managedChannelTypeElement, m -> m.contains((Object)Modifier.PUBLIC)).get(0);
        ArrayList<Set<String>> parameterTags = new ArrayList<Set<String>>(managedChannelConstructor.getParameters().size() - 1);
        ArrayList<TypeMirror> parameterTypes = new ArrayList<TypeMirror>(managedChannelConstructor.getParameters().size() - 1);
        for (int i = 0; i < managedChannelConstructor.getParameters().size() - 1; ++i) {
            VariableElement parameter = managedChannelConstructor.getParameters().get(i);
            parameterTags.add(i < 4 ? tag : Set.of());
            parameterTypes.add(parameter.asType());
        }
        return () -> new ExtensionResult.CodeBlockResult((Element)managedChannelConstructor, params -> CodeBlock.of((String)"new $T($L, $T.getServiceDescriptor())", (Object[])new Object[]{GrpcClassNames.managedChannelLifecycle, params, grpcServiceClassName}), managedChannelTypeMirror, tag, (List)parameterTypes, (List)parameterTags);
    }

    @Nullable
    private KoraExtension.KoraExtensionDependencyGenerator getStubGenerator(TypeMirror typeMirror, Set<String> tag) {
        if (!tag.isEmpty()) {
            return null;
        }
        if (typeMirror.getKind() != TypeKind.DECLARED) {
            return null;
        }
        DeclaredType dtm = (DeclaredType)typeMirror;
        Element typeElement = dtm.asElement();
        Element apiTypeElement = typeElement.getEnclosingElement();
        if (apiTypeElement.getKind() != ElementKind.CLASS) {
            return null;
        }
        ClassName apiClassName = ClassName.get((TypeElement)((TypeElement)apiTypeElement));
        if (AnnotationUtils.findAnnotation((Element)apiTypeElement, (ClassName)GrpcClassNames.grpcGenerated) == null) {
            return null;
        }
        String typeName = typeMirror.toString();
        ExecutableElement sourceElement = typeName.endsWith("BlockingStub") ? this.findStaticMethod(apiTypeElement, "newBlockingStub") : (typeName.endsWith("FutureStub") ? this.findStaticMethod(apiTypeElement, "newFutureStub") : this.findStaticMethod(apiTypeElement, "newStub"));
        TypeMirror channelType = sourceElement.getParameters().get(0).asType();
        return () -> new ExtensionResult.CodeBlockResult((Element)sourceElement, params -> CodeBlock.of((String)"$T.$N($L)", (Object[])new Object[]{apiClassName, sourceElement.getSimpleName(), params}), typeMirror, tag, List.of(channelType), List.of(Set.of(apiClassName.canonicalName())));
    }

    private ExecutableElement findStaticMethod(Element type, String methodName) {
        for (Element element : type.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD || !element.getModifiers().contains((Object)Modifier.STATIC) || !element.getModifiers().contains((Object)Modifier.PUBLIC) || !element.getSimpleName().contentEquals(methodName)) continue;
            return (ExecutableElement)element;
        }
        throw new IllegalStateException();
    }
}

