/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.grpc.server.telemetry;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.Status;
import jakarta.annotation.Nullable;
import ru.tinkoff.kora.grpc.server.telemetry.DefaultGrpcServerTelemetryContext;
import ru.tinkoff.kora.grpc.server.telemetry.GrpcServerLogger;
import ru.tinkoff.kora.grpc.server.telemetry.GrpcServerMetrics;
import ru.tinkoff.kora.grpc.server.telemetry.GrpcServerMetricsFactory;
import ru.tinkoff.kora.grpc.server.telemetry.GrpcServerTelemetry;
import ru.tinkoff.kora.grpc.server.telemetry.GrpcServerTracer;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public final class DefaultGrpcServerTelemetry
implements GrpcServerTelemetry {
    private static final GrpcServerTelemetry.GrpcServerTelemetryContext NOOP_CTX = new GrpcServerTelemetry.GrpcServerTelemetryContext(){

        @Override
        public void close(Status status, Throwable exception) {
        }

        @Override
        public void sendMessage(Object message) {
        }

        @Override
        public void receiveMessage(Object message) {
        }
    };
    private final TelemetryConfig config;
    @Nullable
    private final GrpcServerMetricsFactory metrics;
    @Nullable
    private final GrpcServerTracer tracing;
    @Nullable
    private final GrpcServerLogger logger;

    public DefaultGrpcServerTelemetry(TelemetryConfig config, @Nullable GrpcServerMetricsFactory metrics, @Nullable GrpcServerTracer tracing, @Nullable GrpcServerLogger logger) {
        this.config = config;
        this.metrics = metrics;
        this.tracing = tracing;
        this.logger = logger;
    }

    @Override
    public GrpcServerTelemetry.GrpcServerTelemetryContext createContext(ServerCall<?, ?> call, Metadata headers) {
        GrpcServerTracer.GrpcServerSpan span;
        GrpcServerMetricsFactory metrics = this.metrics;
        GrpcServerTracer tracing = this.tracing;
        GrpcServerLogger logger = this.logger;
        if (!(metrics != null || tracing != null || logger != null && logger.isEnabled())) {
            return NOOP_CTX;
        }
        long start = System.nanoTime();
        String serviceName = this.service(call);
        String methodName = this.method(call);
        GrpcServerMetrics m = metrics == null ? null : metrics.get(this.config.metrics(), call, headers, serviceName, methodName);
        GrpcServerTracer.GrpcServerSpan grpcServerSpan = span = tracing == null ? null : tracing.createSpan(call, headers, serviceName, methodName);
        if (logger != null) {
            logger.logBegin(call, headers, serviceName, methodName);
        }
        return new DefaultGrpcServerTelemetryContext(start, serviceName, methodName, m, logger, span);
    }

    private String service(ServerCall<?, ?> call) {
        String fullMethodName = call.getMethodDescriptor().getFullMethodName();
        int slashIndex = fullMethodName.lastIndexOf(47);
        if (slashIndex == -1) {
            return "unknownService";
        }
        return fullMethodName.substring(0, slashIndex);
    }

    private String method(ServerCall<?, ?> call) {
        String fullMethodName = call.getMethodDescriptor().getFullMethodName();
        int slashIndex = fullMethodName.lastIndexOf(47);
        if (slashIndex == -1) {
            return "unknownMethod";
        }
        return fullMethodName.substring(slashIndex + 1);
    }
}

