/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.grpc.server.telemetry;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.Status;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import ru.tinkoff.kora.grpc.server.GrpcNettyServer;
import ru.tinkoff.kora.grpc.server.telemetry.GrpcServerLogger;
import ru.tinkoff.kora.logging.common.arg.StructuredArgument;

public final class Slf4jGrpcServerLogger
implements GrpcServerLogger {
    private static final Logger log = LoggerFactory.getLogger(GrpcNettyServer.class);

    @Override
    public boolean isEnabled() {
        return log.isInfoEnabled();
    }

    @Override
    public void logEnd(String serviceName, String methodName, @Nullable Status status, @Nullable Throwable exception, long processingTime) {
        Marker marker = StructuredArgument.marker((String)"grpcResponse", gen -> {
            gen.writeStartObject();
            gen.writeStringField("serviceName", serviceName);
            gen.writeStringField("operation", serviceName + "/" + methodName);
            gen.writeNumberField("processingTime", processingTime / 1000000L);
            if (status != null) {
                gen.writeStringField("status", status.getCode().name());
            }
            if (exception != null) {
                String exceptionType = exception.getClass().getCanonicalName();
                gen.writeStringField("exceptionType", exceptionType);
            }
            gen.writeEndObject();
        });
        if (status != null && status.isOk()) {
            log.info(marker, "GrpcCall responded {} for {}#{}", new Object[]{status, serviceName, methodName});
        } else if (status != null) {
            log.warn(marker, "GrpcCall responded {} for {}#{}", new Object[]{status, serviceName, methodName, exception});
        } else {
            log.warn(marker, "GrpcCall responded for {}#{}", new Object[]{serviceName, methodName, exception});
        }
    }

    @Override
    public void logBegin(ServerCall<?, ?> call, Metadata headers, String serviceName, String methodName) {
        Marker marker = StructuredArgument.marker((String)"grpcRequest", gen -> {
            gen.writeStartObject();
            gen.writeStringField("serviceName", serviceName);
            gen.writeStringField("operation", serviceName + "/" + methodName);
            gen.writeEndObject();
        });
        if (log.isDebugEnabled()) {
            log.debug(marker, "GrpcCall received for {}#{}\n{}", new Object[]{serviceName, methodName, headers});
        } else {
            log.info(marker, "GrpcCall received for {}#{}", (Object)serviceName, (Object)methodName);
        }
    }

    @Override
    public void logSendMessage(String serviceName, String methodName, Object message) {
    }

    @Override
    public void logReceiveMessage(String serviceName, String methodName, Object message) {
    }
}

