/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.annotation.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.common.Module;
import ru.tinkoff.kora.common.annotation.Generated;
import ru.tinkoff.kora.http.client.annotation.processor.HttpClientClassNames;
import ru.tinkoff.kora.http.client.annotation.processor.HttpClientUtils;

public class ConfigModuleGenerator {
    private final Elements elements;

    public ConfigModuleGenerator(ProcessingEnvironment processingEnvironment) {
        this.elements = processingEnvironment.getElementUtils();
    }

    public JavaFile generate(TypeElement element) {
        StringBuilder lowercaseName = new StringBuilder(element.getSimpleName());
        lowercaseName.setCharAt(0, Character.toLowerCase(lowercaseName.charAt(0)));
        String packageName = this.elements.getPackageOf(element).getQualifiedName().toString();
        Object configPath = (String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)AnnotationUtils.findAnnotation((Element)element, (ClassName)HttpClientClassNames.httpClientAnnotation), (String)"configPath");
        if (configPath == null || ((String)configPath).isBlank()) {
            configPath = "httpClient." + lowercaseName;
        }
        String configName = HttpClientUtils.configName(element);
        String moduleName = HttpClientUtils.moduleName(element);
        ClassName configClass = ClassName.get((String)packageName, (String)configName, (String[])new String[0]);
        ParameterizedTypeName extractorClass = ParameterizedTypeName.get((ClassName)CommonClassNames.configValueExtractor, (TypeName[])new TypeName[]{configClass});
        TypeSpec.Builder type = TypeSpec.interfaceBuilder((String)moduleName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{ConfigModuleGenerator.class.getCanonicalName()}).build()).addAnnotation(AnnotationSpec.builder(Module.class).build()).addOriginatingElement((Element)element).addMethod(MethodSpec.methodBuilder((String)(lowercaseName + "Config")).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).returns((TypeName)configClass).addParameter(ParameterSpec.builder((TypeName)CommonClassNames.config, (String)"config", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)extractorClass, (String)"extractor", (Modifier[])new Modifier[0]).build()).addStatement("var value = config.get($S)", new Object[]{configPath}).addStatement("return $T.ofNullable(extractor.extract(value)).orElseThrow(() -> $T.missingValueAfterParse(value))", new Object[]{Optional.class, CommonClassNames.configValueExtractionException}).build());
        return JavaFile.builder((String)packageName, (TypeSpec)type.build()).build();
    }
}

