/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.annotation.processor;

import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import ru.tinkoff.kora.annotation.processor.common.AbstractKoraProcessor;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.http.client.annotation.processor.ClientClassGenerator;
import ru.tinkoff.kora.http.client.annotation.processor.ConfigClassGenerator;
import ru.tinkoff.kora.http.client.annotation.processor.ConfigModuleGenerator;
import ru.tinkoff.kora.http.client.annotation.processor.HttpClientClassNames;

public class HttpClientAnnotationProcessor
extends AbstractKoraProcessor {
    private ClientClassGenerator clientGenerator;
    private ConfigClassGenerator configGenerator;
    private boolean initialized;
    private ConfigModuleGenerator configModuleGenerator;

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        TypeElement httpClient = processingEnv.getElementUtils().getTypeElement(HttpClientClassNames.httpClientAnnotation.canonicalName());
        if (httpClient == null) {
            return;
        }
        this.initialized = true;
        this.clientGenerator = new ClientClassGenerator(processingEnv);
        this.configGenerator = new ConfigClassGenerator();
        this.configModuleGenerator = new ConfigModuleGenerator(processingEnv);
    }

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(HttpClientClassNames.httpClientAnnotation.canonicalName());
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!this.initialized) {
            return false;
        }
        if (roundEnv.processingOver()) {
            return false;
        }
        Set elements = annotations.stream().filter(a -> a.getQualifiedName().contentEquals(HttpClientClassNames.httpClientAnnotation.canonicalName())).flatMap(a -> roundEnv.getElementsAnnotatedWith((TypeElement)a).stream()).collect(Collectors.toSet());
        for (Element httpClient : elements) {
            if (httpClient.getKind() != ElementKind.INTERFACE) continue;
            TypeElement typeElement = (TypeElement)httpClient;
            try {
                this.generateClient(typeElement);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return !elements.isEmpty();
    }

    private void generateClient(TypeElement element) {
        String packageName = this.elements.getPackageOf(element).getQualifiedName().toString();
        TypeSpec client = this.clientGenerator.generate(element);
        TypeSpec config = this.configGenerator.generate(element);
        JavaFile configModule = this.configModuleGenerator.generate(element);
        CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)configModule);
        CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)JavaFile.builder((String)packageName, (TypeSpec)client).build());
        CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)JavaFile.builder((String)packageName, (TypeSpec)config).build());
    }
}

