/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.annotation.processor.extension;

import com.squareup.javapoet.ClassName;
import jakarta.annotation.Nullable;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.NameUtils;
import ru.tinkoff.kora.http.client.annotation.processor.HttpClientAnnotationProcessor;
import ru.tinkoff.kora.http.client.annotation.processor.HttpClientClassNames;
import ru.tinkoff.kora.http.client.annotation.processor.HttpClientUtils;
import ru.tinkoff.kora.kora.app.annotation.processor.extension.ExtensionResult;
import ru.tinkoff.kora.kora.app.annotation.processor.extension.KoraExtension;

public class HttpClientKoraExtension
implements KoraExtension {
    private final Elements elements;
    private final Types types;
    private final ProcessingEnvironment processingEnv;
    private final HttpClientAnnotationProcessor processor;

    public HttpClientKoraExtension(ProcessingEnvironment processingEnvironment) {
        this.processingEnv = processingEnvironment;
        this.elements = processingEnvironment.getElementUtils();
        this.types = processingEnvironment.getTypeUtils();
        this.processor = new HttpClientAnnotationProcessor();
        this.processor.init(processingEnvironment);
    }

    @Nullable
    public KoraExtension.KoraExtensionDependencyGenerator getDependencyGenerator(RoundEnvironment roundEnvironment, TypeMirror typeMirror, Set<String> tags) {
        if (!tags.isEmpty()) {
            return null;
        }
        Element element = this.types.asElement(typeMirror);
        if (element == null || element.getKind() != ElementKind.INTERFACE) {
            return null;
        }
        AnnotationMirror annotation = AnnotationUtils.findAnnotation((Element)element, (ClassName)HttpClientClassNames.httpClientAnnotation);
        if (annotation == null) {
            return null;
        }
        return () -> {
            TypeElement typeElement = (TypeElement)element;
            String implName = HttpClientUtils.clientName(typeElement);
            String packageName = this.processingEnv.getElementUtils().getPackageOf(typeElement).getQualifiedName().toString();
            TypeElement maybeGenerated = this.elements.getTypeElement(packageName + "." + implName);
            if (maybeGenerated == null) {
                return ExtensionResult.nextRound();
            }
            if (CommonUtils.hasAopAnnotations((TypeElement)typeElement)) {
                String aopProxy = NameUtils.generatedType((Element)maybeGenerated, (String)"_AopProxy");
                TypeElement aopProxyElement = this.elements.getTypeElement(packageName + "." + aopProxy);
                if (aopProxyElement == null) {
                    return ExtensionResult.nextRound();
                }
                maybeGenerated = aopProxyElement;
            }
            return (ExtensionResult)maybeGenerated.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.CONSTRUCTOR).map(ExecutableElement.class::cast).map(ExtensionResult::fromExecutable).findFirst().orElseThrow();
        };
    }
}

