/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.annotation.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.annotation.processor.common.TagUtils;
import ru.tinkoff.kora.annotation.processor.common.TypeUtils;
import ru.tinkoff.kora.http.client.annotation.processor.HttpClientClassNames;
import ru.tinkoff.kora.http.client.annotation.processor.HttpClientUtils;
import ru.tinkoff.kora.http.client.annotation.processor.Parameter;

public class ClientClassGenerator {
    private final ProcessingEnvironment processingEnv;
    private final Elements elements;
    private final Types types;
    private final Pattern PATH_PARAM_PATTERN = Pattern.compile("\\{.+?}");
    private final Set<String> primitiveTypes = Set.of("java.lang.String", "java.lang.Integer", "java.lang.Long", "java.lang.Boolean");

    public ClientClassGenerator(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        this.elements = this.processingEnv.getElementUtils();
        this.types = this.processingEnv.getTypeUtils();
    }

    public TypeSpec generate(TypeElement element) {
        String typeName = HttpClientUtils.clientName(element);
        List<MethodData> methods = this.parseMethods(element);
        TypeSpec.Builder builder = CommonUtils.extendsKeepAop((TypeElement)element, (String)typeName).addAnnotation(AnnotationUtils.generated(ClientClassGenerator.class));
        builder.addMethod(this.buildConstructor(builder, element, methods));
        builder.addField(String.class, "rootUrl", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        if (AnnotationUtils.findAnnotation((Element)element, (ClassName)CommonClassNames.component) != null) {
            builder.addAnnotation(CommonClassNames.component);
        }
        for (MethodData method : methods) {
            builder.addField((TypeName)HttpClientClassNames.httpClient, String.valueOf(method.element().getSimpleName()) + "Client", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            builder.addField(Duration.class, String.valueOf(method.element().getSimpleName()) + "RequestTimeout", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            builder.addField(String.class, String.valueOf(method.element().getSimpleName()) + "UriTemplate", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            boolean hasUriParameters = method.parameters.stream().anyMatch(p -> p instanceof Parameter.QueryParameter || p instanceof Parameter.PathParameter);
            if (!hasUriParameters) {
                builder.addField(URI.class, String.valueOf(method.element().getSimpleName()) + "Uri", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            }
            MethodSpec methodSpec = this.buildMethod(builder, method);
            builder.addMethod(methodSpec);
        }
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    private MethodSpec buildMethod(TypeSpec.Builder builder, MethodData methodData) {
        ExecutableElement method = methodData.element();
        MethodSpec.Builder b = CommonUtils.overridingKeepAop((ExecutableElement)method).addException((TypeName)HttpClientClassNames.httpClientException);
        String methodClientName = String.valueOf(method.getSimpleName()) + "Client";
        AnnotationMirror httpRoute = AnnotationUtils.findAnnotation((Element)method, (ClassName)HttpClientClassNames.httpRoute);
        String httpMethod = (String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)httpRoute, (String)"method");
        b.addStatement("var _client = this.$L", new Object[]{methodClientName});
        b.addStatement("var _headers = $T.of()", new Object[]{HttpClientClassNames.httpHeaders});
        b.addStatement("var _uriTemplate = this.$L", new Object[]{String.valueOf(method.getSimpleName()) + "UriTemplate"});
        b.addStatement("var _requestTimeout = this.$L", new Object[]{String.valueOf(method.getSimpleName()) + "RequestTimeout"});
        boolean hasPathParameters = methodData.parameters.stream().anyMatch(p -> p instanceof Parameter.PathParameter);
        boolean hasQueryParameters = methodData.parameters.stream().anyMatch(p -> p instanceof Parameter.QueryParameter);
        Parameter.BodyParameter bodyParameter = methodData.parameters.stream().filter(p -> p instanceof Parameter.BodyParameter).findFirst().map(Parameter.BodyParameter.class::cast).orElse(null);
        if (hasPathParameters || hasQueryParameters) {
            Object uriWithPlaceholdersString;
            String httpPath = Objects.requireNonNull((String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)httpRoute, (String)"path"));
            if (hasPathParameters) {
                b.addCode("var _uriNoQuery = this.rootUrl\n", new Object[0]);
                List<RoutePart> parts = this.parseRouteParts(httpPath, methodData.parameters);
                StringBuilder uriWithPlaceholdersStringB = new StringBuilder();
                for (RoutePart routePart : parts) {
                    if (routePart.string() != null) {
                        uriWithPlaceholdersStringB.append(routePart.string);
                        b.addCode("  + $S\n", new Object[]{routePart.string()});
                        continue;
                    }
                    uriWithPlaceholdersStringB.append("placeholder");
                    if (this.requiresConverter(routePart.parameter.parameter().asType())) {
                        String converterName = this.getConverterName(methodData, routePart.parameter.parameter());
                        b.addCode("  + $T.encode($L.convert($N), $T.UTF_8)\n", new Object[]{URLEncoder.class, converterName, routePart.parameter.parameter().getSimpleName(), StandardCharsets.class});
                        continue;
                    }
                    b.addCode("  + $T.encode($T.toString($N), $T.UTF_8)\n", new Object[]{URLEncoder.class, Objects.class, routePart.parameter.parameter().getSimpleName(), StandardCharsets.class});
                }
                uriWithPlaceholdersString = uriWithPlaceholdersStringB.toString();
                b.addCode(";\n", new Object[0]);
            } else {
                Matcher matcher = this.PATH_PARAM_PATTERN.matcher(httpPath);
                ArrayList<String> pathUnmatched = new ArrayList<String>();
                while (matcher.find()) {
                    String group = matcher.group();
                    pathUnmatched.add(group);
                }
                if (!pathUnmatched.isEmpty()) {
                    throw new ProcessingErrorException("HTTP path '" + (String)httpPath + "' contains unspecified path parameters: " + String.valueOf(pathUnmatched), (Element)method);
                }
                b.addStatement("var _uriNoQuery = this.rootUrl + $S", new Object[]{httpPath});
                uriWithPlaceholdersString = httpPath;
            }
            if (!hasQueryParameters) {
                b.addStatement("var _uri = $T.create(_uriNoQuery)", new Object[]{URI.class});
            } else {
                URI uriWithPlaceholders;
                try {
                    uriWithPlaceholders = URI.create((String)uriWithPlaceholdersString);
                }
                catch (Exception e) {
                    throw new ProcessingErrorException("Illegal URI path with Query parameters: " + e.getMessage(), (Element)method);
                }
                boolean hasQMark = uriWithPlaceholders.getQuery() != null;
                boolean hasFirstParam = hasQMark && !uriWithPlaceholders.getQuery().isBlank();
                b.addStatement("var _query = new $T($L, $L)", new Object[]{HttpClientClassNames.uriQueryBuilder, !hasQMark, hasFirstParam});
                for (Parameter parameter : methodData.parameters) {
                    boolean isMap;
                    if (!(parameter instanceof Parameter.QueryParameter)) continue;
                    Parameter.QueryParameter p2 = (Parameter.QueryParameter)parameter;
                    boolean nullable = CommonUtils.isNullable((AnnotatedConstruct)p2.parameter());
                    if (nullable) {
                        b.beginControlFlow("if ($L != null)", new Object[]{p2.parameter()});
                    }
                    Object targetLiteral = p2.parameter().getSimpleName().toString();
                    TypeMirror type = p2.parameter().asType();
                    boolean isList = CommonUtils.isCollection((TypeMirror)type);
                    if (isList) {
                        type = ((DeclaredType)type).getTypeArguments().get(0);
                        String paramName = "_" + (String)targetLiteral + "_element";
                        b.beginControlFlow("if ($N.isEmpty())", new Object[]{targetLiteral});
                        b.addStatement("_query.unsafeAdd($S)", new Object[]{URLEncoder.encode(p2.queryParameterName(), StandardCharsets.UTF_8)});
                        b.nextControlFlow("else", new Object[0]);
                        b.beginControlFlow("for (var $L : $L)", new Object[]{paramName, targetLiteral});
                        targetLiteral = paramName;
                    }
                    if (isMap = CommonUtils.isMap((TypeMirror)type)) {
                        TypeMirror keyType = ((DeclaredType)type).getTypeArguments().get(0);
                        if (!String.class.getCanonicalName().equals(keyType.toString())) {
                            throw new ProcessingErrorException("@Query map key type must be String, but was: " + String.valueOf(keyType), (Element)method);
                        }
                        type = ((DeclaredType)type).getTypeArguments().get(1);
                        String paramName = "_" + (String)targetLiteral + "_element";
                        b.beginControlFlow("for (var $L : $L.entrySet())", new Object[]{paramName, targetLiteral});
                        targetLiteral = paramName;
                        b.beginControlFlow("if($L.getKey() != null && !$L.getKey().isBlank())", new Object[]{paramName, paramName});
                        b.beginControlFlow("if($L.getValue() == null)", new Object[]{paramName});
                        b.addStatement("_query.add($L.getKey())", new Object[]{paramName});
                        b.nextControlFlow("else", new Object[0]);
                        b.addCode("_query.add($L.getKey(), ", new Object[]{paramName});
                        if (this.requiresConverter(type)) {
                            b.addCode("$L.convert($L.getValue())", new Object[]{this.getConverterName(methodData, p2.parameter()), targetLiteral});
                        } else {
                            b.addCode("$T.toString($L.getValue())", new Object[]{Objects.class, targetLiteral});
                        }
                        b.addStatement(")", new Object[]{StandardCharsets.class});
                        b.endControlFlow().endControlFlow().endControlFlow();
                    } else {
                        b.addCode("_query.unsafeAdd($S, $T.encode(", new Object[]{URLEncoder.encode(p2.queryParameterName(), StandardCharsets.UTF_8), URLEncoder.class});
                        if (this.requiresConverter(type)) {
                            b.addCode("$L.convert($L)", new Object[]{this.getConverterName(methodData, p2.parameter()), targetLiteral});
                        } else {
                            b.addCode("$T.toString($L)", new Object[]{Objects.class, targetLiteral});
                        }
                        b.addCode(", $T.UTF_8));\n", new Object[]{StandardCharsets.class});
                    }
                    if (isList) {
                        b.endControlFlow().endControlFlow();
                    }
                    if (!nullable) continue;
                    b.endControlFlow();
                }
                b.addStatement("var _uri = $T.create(_uriNoQuery + _query.build())", new Object[]{URI.class});
            }
        } else {
            b.addStatement("var _uri = this.$L", new Object[]{String.valueOf(method.getSimpleName()) + "Uri"});
        }
        b.addCode("\n", new Object[0]);
        for (Parameter parameter : methodData.parameters()) {
            void var16_31;
            boolean isMap;
            TypeMirror keyType;
            boolean isList;
            Object targetLiteral;
            if (parameter instanceof Parameter.HeaderParameter) {
                void var16_26;
                boolean isMap2;
                Parameter.HeaderParameter header = (Parameter.HeaderParameter)parameter;
                boolean nullable = CommonUtils.isNullable((AnnotatedConstruct)header.parameter());
                if (nullable) {
                    b.beginControlFlow("if ($L != null)", new Object[]{header.parameter()});
                }
                targetLiteral = header.parameter().getSimpleName().toString();
                TypeMirror typeMirror = header.parameter().asType();
                isList = CommonUtils.isCollection((TypeMirror)typeMirror);
                if (isList) {
                    TypeMirror typeMirror2 = ((DeclaredType)typeMirror).getTypeArguments().get(0);
                    String paramName = "_" + (String)targetLiteral + "_element";
                    b.beginControlFlow("for (var $L : $L)", new Object[]{paramName, targetLiteral});
                    targetLiteral = paramName;
                }
                if (isMap2 = CommonUtils.isMap((TypeMirror)var16_26)) {
                    keyType = ((DeclaredType)var16_26).getTypeArguments().get(0);
                    if (!String.class.getCanonicalName().equals(keyType.toString())) {
                        throw new ProcessingErrorException("@Header map key type must be String, but was: " + String.valueOf(keyType), (Element)method);
                    }
                    TypeMirror typeMirror3 = ((DeclaredType)var16_26).getTypeArguments().get(1);
                    b.beginControlFlow("for (var $L_header : $L.entrySet())", new Object[]{targetLiteral, targetLiteral});
                    b.beginControlFlow("if($L_header.getKey() != null && !$L_header.getKey().isBlank() && $L_header.getValue() != null)", new Object[]{targetLiteral, targetLiteral, targetLiteral});
                    if (this.requiresConverter(typeMirror3)) {
                        b.addStatement("_headers.add($L_header.getKey(), $L.convert($L_header.getValue()))", new Object[]{targetLiteral, this.getConverterName(methodData, header.parameter()), targetLiteral});
                    } else {
                        b.addStatement("_headers.add($L_header.getKey(), $L_header.getValue())", new Object[]{targetLiteral, targetLiteral});
                    }
                    b.endControlFlow().endControlFlow();
                } else if (ClassName.get((TypeMirror)var16_26).equals((Object)HttpClientClassNames.httpHeaders)) {
                    b.beginControlFlow("for (var $L_header : $L)", new Object[]{targetLiteral, targetLiteral});
                    b.addStatement("_headers.add($L_header.getKey(), $L_header.getValue())", new Object[]{targetLiteral, targetLiteral});
                    b.endControlFlow();
                } else if (this.requiresConverter((TypeMirror)var16_26)) {
                    b.addCode("_headers.add($S, $L.convert($L));\n", new Object[]{header.headerName(), this.getConverterName(methodData, header.parameter()), targetLiteral});
                } else {
                    b.addCode("_headers.add($S, $T.toString($L));\n", new Object[]{header.headerName(), Objects.class, targetLiteral});
                }
                if (isList) {
                    b.endControlFlow();
                }
                if (nullable) {
                    b.endControlFlow();
                }
            }
            if (!(parameter instanceof Parameter.CookieParameter)) continue;
            Parameter.CookieParameter cookie = (Parameter.CookieParameter)parameter;
            boolean nullable = CommonUtils.isNullable((AnnotatedConstruct)cookie.parameter());
            if (nullable) {
                b.beginControlFlow("if ($L != null)", new Object[]{cookie.parameter()});
            }
            targetLiteral = cookie.parameter().getSimpleName().toString();
            TypeMirror typeMirror = cookie.parameter().asType();
            isList = CommonUtils.isCollection((TypeMirror)typeMirror);
            if (isList) {
                TypeMirror typeMirror4 = ((DeclaredType)typeMirror).getTypeArguments().get(0);
                String paramName = "_" + (String)targetLiteral + "_element";
                b.beginControlFlow("for (var $L : $L)", new Object[]{paramName, targetLiteral});
                targetLiteral = paramName;
            }
            if (isMap = CommonUtils.isMap((TypeMirror)var16_31)) {
                keyType = ((DeclaredType)var16_31).getTypeArguments().get(0);
                if (!String.class.getCanonicalName().equals(keyType.toString())) {
                    throw new ProcessingErrorException("@Cookie map key type must be String, but was: " + String.valueOf(keyType), (Element)method);
                }
                TypeMirror typeMirror5 = ((DeclaredType)var16_31).getTypeArguments().get(1);
                b.beginControlFlow("for (var $L_cookie : $L.entrySet())", new Object[]{targetLiteral, targetLiteral});
                b.beginControlFlow("if($L_cookie.getKey() != null && !$L_cookie.getKey().isBlank() && $L_cookie.getValue() != null)", new Object[]{targetLiteral, targetLiteral, targetLiteral});
                if (this.requiresConverter(typeMirror5)) {
                    b.addStatement("_headers.add(\"Cookie\", $L_cookie.getKey() + \"=\" + $L.convert($L_cookie.getValue()))", new Object[]{targetLiteral, this.getConverterName(methodData, cookie.parameter()), targetLiteral});
                } else {
                    b.addStatement("_headers.add(\"Cookie\", $L_cookie.getKey() + \"=\" + $L_cookie.getValue())", new Object[]{targetLiteral, targetLiteral});
                }
                b.endControlFlow().endControlFlow();
            } else if (ClassName.get((TypeMirror)var16_31).equals((Object)HttpClientClassNames.httpCookie)) {
                b.addStatement("_headers.add(\"Cookie\", $L.toValue())", new Object[]{targetLiteral});
            } else if (this.requiresConverter((TypeMirror)var16_31)) {
                b.addCode("_headers.add(\"Cookie\", \"$L=\" + $L.convert($L));\n", new Object[]{cookie.cookieName(), this.getConverterName(methodData, cookie.parameter()), targetLiteral});
            } else {
                b.addCode("_headers.add(\"Cookie\", \"$L=\" + $T.toString($L));\n", new Object[]{cookie.cookieName(), Objects.class, targetLiteral});
            }
            if (isList) {
                b.endControlFlow();
            }
            if (!nullable) continue;
            b.endControlFlow();
        }
        if (bodyParameter == null) {
            b.addStatement("var _body = $T.empty()", new Object[]{HttpClientClassNames.httpBody});
        } else {
            String requestMapperName = String.valueOf(method.getSimpleName()) + "RequestMapper";
            b.addCode("\n", new Object[0]);
            b.addStatement("final $T _body", new Object[]{HttpClientClassNames.httpBodyOutput});
            b.addCode("try {$>\n", new Object[0]);
            CodeBlock ref = ClientClassGenerator.findMapperField((TypeSpec.Builder)builder, (String)requestMapperName).modifiers.contains((Object)Modifier.STATIC) ? CodeBlock.of((String)"$T", (Object[])new Object[]{this.implClassName(methodData.element)}) : CodeBlock.of((String)"this", (Object[])new Object[0]);
            b.addCode("_body = $L.$N.apply($T.current(), $L);$<\n", new Object[]{ref, requestMapperName, CommonClassNames.context, bodyParameter.parameter()});
            b.addCode("} catch (Exception _e) {$>\n", new Object[0]);
            b.addCode("throw new $T(_e);$<\n", new Object[]{HttpClientClassNames.httpClientEncoderException});
            b.addCode("}\n", new Object[0]);
        }
        b.addCode("\n", new Object[0]);
        b.addStatement("var _request = $T.of($S, _uri, _uriTemplate, _headers, _body, _requestTimeout)", new Object[]{HttpClientClassNames.httpClientRequest, httpMethod});
        if (CommonUtils.isMono((TypeMirror)method.getReturnType())) {
            b.addCode(this.buildCallMono(builder, methodData));
        } else if (CommonUtils.isFuture((TypeMirror)method.getReturnType())) {
            b.addCode(this.buildCallFuture(builder, methodData));
        } else {
            b.addCode(this.buildCallBlocking(builder, methodData));
        }
        return b.build();
    }

    private ClassName implClassName(ExecutableElement method) {
        return ClassName.get((String)this.elements.getPackageOf(method).getQualifiedName().toString(), (String)HttpClientUtils.clientName((TypeElement)method.getEnclosingElement()), (String[])new String[0]);
    }

    private static FieldSpec findMapperField(TypeSpec.Builder builder, String mapperName) {
        for (FieldSpec fieldSpec : builder.fieldSpecs) {
            if (!fieldSpec.name.equals(mapperName)) continue;
            return fieldSpec;
        }
        throw new IllegalStateException();
    }

    private List<RoutePart> parseRouteParts(String httpPath, List<Parameter> parameters) {
        List<RoutePart> parts = List.of(new RoutePart(null, httpPath));
        for (Parameter parameter : parameters) {
            ArrayList<RoutePart> newList = new ArrayList<RoutePart>();
            if (!(parameter instanceof Parameter.PathParameter)) continue;
            Parameter.PathParameter p = (Parameter.PathParameter)parameter;
            block1: for (RoutePart part : parts) {
                if (part.parameter != null) {
                    newList.add(part);
                    continue;
                }
                int from = 0;
                String token = "{" + p.pathParameterName() + "}";
                while (true) {
                    String str;
                    int idx;
                    if ((idx = part.string.indexOf(token, from)) < 0) {
                        str = part.string.substring(from);
                        if (str.isEmpty()) continue block1;
                        newList.add(new RoutePart(null, str));
                        continue block1;
                    }
                    str = part.string.substring(from, idx);
                    if (!str.isEmpty()) {
                        newList.add(new RoutePart(null, str));
                    }
                    newList.add(new RoutePart(p, null));
                    from = idx + token.length();
                }
            }
            parts = newList;
        }
        return parts;
    }

    private CodeBlock mapBlockingResponse(TypeSpec.Builder builder, MethodData methodData, TypeMirror resultType) {
        CodeBlock.Builder b = CodeBlock.builder();
        if (methodData.responseMapper != null && methodData.responseMapper.mapperClass() != null && methodData.codeMappers().isEmpty()) {
            String responseMapperName = String.valueOf(methodData.element.getSimpleName()) + "ResponseMapper";
            if (resultType.getKind() != TypeKind.VOID) {
                b.add("return ", new Object[0]);
            }
            CodeBlock ref = ClientClassGenerator.findMapperField((TypeSpec.Builder)builder, (String)responseMapperName).modifiers.contains((Object)Modifier.STATIC) ? CodeBlock.of((String)"$T", (Object[])new Object[]{this.implClassName(methodData.element)}) : CodeBlock.of((String)"this", (Object[])new Object[0]);
            b.addStatement("$L.$N.apply(_response)", new Object[]{ref, responseMapperName});
        } else if (methodData.codeMappers().isEmpty()) {
            DeclaredType dt;
            b.addStatement("var _code = _response.code()", new Object[0]);
            b.beginControlFlow("if (_code >= 200 && _code < 300)", new Object[0]);
            if (resultType.getKind() == TypeKind.VOID) {
                b.addStatement("return", new Object[0]);
            } else if (resultType instanceof DeclaredType && (dt = (DeclaredType)resultType).asElement().toString().equals("java.lang.Void")) {
                b.addStatement("return null", new Object[0]);
            } else {
                String responseMapperName = String.valueOf(methodData.element().getSimpleName()) + "ResponseMapper";
                CodeBlock ref = ClientClassGenerator.findMapperField((TypeSpec.Builder)builder, (String)responseMapperName).modifiers.contains((Object)Modifier.STATIC) ? CodeBlock.of((String)"$T", (Object[])new Object[]{this.implClassName(methodData.element)}) : CodeBlock.of((String)"this", (Object[])new Object[0]);
                b.addStatement("return $L.$N.apply(_response)", new Object[]{ref, responseMapperName});
            }
            b.nextControlFlow("else", new Object[0]);
            b.addStatement("throw $T.fromResponseFuture(_response).get()", new Object[]{HttpClientClassNames.httpClientResponseException});
            b.endControlFlow();
        } else {
            b.addStatement("var _code = _response.code()", new Object[0]);
            if (resultType.getKind() != TypeKind.VOID) {
                b.add("return ", new Object[0]);
            }
            b.add("switch (_code) {\n", new Object[0]);
            ResponseCodeMapperData defaultMapper = null;
            for (ResponseCodeMapperData codeMapper : methodData.codeMappers()) {
                CodeBlock ref;
                if (codeMapper.code() == -1) {
                    defaultMapper = codeMapper;
                    continue;
                }
                String responseMapperName = String.valueOf(methodData.element().getSimpleName()) + codeMapper.code() + "ResponseMapper";
                CodeBlock codeBlock = ref = ClientClassGenerator.findMapperField((TypeSpec.Builder)builder, (String)responseMapperName).modifiers.contains((Object)Modifier.STATIC) ? CodeBlock.of((String)"$T", (Object[])new Object[]{this.implClassName(methodData.element)}) : CodeBlock.of((String)"this", (Object[])new Object[0]);
                if (this.isMapperAssignable(methodData.element.getReturnType(), codeMapper.type, codeMapper.mapper)) {
                    b.add("  case $L -> $L.$L.apply(_response);\n", new Object[]{codeMapper.code(), ref, responseMapperName});
                    continue;
                }
                b.add("  case $L -> throw $L.$L.apply(_response);\n", new Object[]{codeMapper.code(), ref, responseMapperName});
            }
            if (defaultMapper == null) {
                b.add("  default -> {\n", new Object[0]);
                b.add("    throw $T.fromResponseFuture(_response).get();\n", new Object[]{HttpClientClassNames.httpClientResponseException});
                b.add("  }\n", new Object[0]);
            } else {
                CodeBlock ref;
                String responseMapperName = String.valueOf(methodData.element().getSimpleName()) + "DefaultResponseMapper";
                CodeBlock codeBlock = ref = ClientClassGenerator.findMapperField((TypeSpec.Builder)builder, (String)responseMapperName).modifiers.contains((Object)Modifier.STATIC) ? CodeBlock.of((String)"$T", (Object[])new Object[]{this.implClassName(methodData.element)}) : CodeBlock.of((String)"this", (Object[])new Object[0]);
                if (this.isMapperAssignable(methodData.element.getReturnType(), defaultMapper.type, defaultMapper.mapper)) {
                    b.add("  default -> $L.$L.apply(_response);\n", new Object[]{ref, responseMapperName});
                } else {
                    b.add("  default -> throw $L.$L.apply(_response);\n", new Object[]{ref, responseMapperName});
                }
            }
            b.add("};\n", new Object[0]);
        }
        return b.build();
    }

    private CodeBlock buildCallBlocking(TypeSpec.Builder builder, MethodData method) {
        CodeBlock.Builder b = CodeBlock.builder();
        b.beginControlFlow("try (var _response = _client.execute(_request).toCompletableFuture().get())", new Object[0]);
        b.add(this.mapBlockingResponse(builder, method, method.element().getReturnType()));
        b.nextControlFlow("catch (java.util.concurrent.ExecutionException e)", new Object[0]).addStatement("if (e.getCause() instanceof RuntimeException re) throw re", new Object[0]).addStatement("if (e.getCause() instanceof Error er) throw er", new Object[0]).addStatement("throw new $T(e.getCause())", new Object[]{HttpClientClassNames.httpClientUnknownException});
        b.nextControlFlow("catch (RuntimeException e)", new Object[0]).addStatement("throw e", new Object[0]);
        b.nextControlFlow("catch (Exception e)", new Object[0]).addStatement("throw new $T(e)", new Object[]{HttpClientClassNames.httpClientUnknownException});
        b.endControlFlow();
        return b.build();
    }

    private CodeBlock mapFutureResponse(TypeSpec.Builder builder, MethodData methodData, TypeMirror resultType) {
        CodeBlock.Builder b = CodeBlock.builder();
        if (methodData.responseMapper != null && methodData.responseMapper.mapperClass() != null) {
            String responseMapperName = String.valueOf(methodData.element.getSimpleName()) + "ResponseMapper";
            CodeBlock ref = ClientClassGenerator.findMapperField((TypeSpec.Builder)builder, (String)responseMapperName).modifiers.contains((Object)Modifier.STATIC) ? CodeBlock.of((String)"$T", (Object[])new Object[]{this.implClassName(methodData.element)}) : CodeBlock.of((String)"this", (Object[])new Object[0]);
            b.addStatement("_result = $L.$N.apply(_response)", new Object[]{ref, responseMapperName});
        } else if (methodData.codeMappers().isEmpty()) {
            DeclaredType dt;
            b.addStatement("var _code = _response.code()", new Object[0]);
            b.beginControlFlow("if (_code >= 200 && _code < 300)", new Object[0]);
            if (resultType instanceof DeclaredType && (dt = (DeclaredType)resultType).asElement().toString().equals("java.lang.Void")) {
                b.addStatement("_result = $T.completedFuture(null)", new Object[]{CompletableFuture.class});
            } else {
                String responseMapperName = String.valueOf(methodData.element().getSimpleName()) + "ResponseMapper";
                CodeBlock ref = ClientClassGenerator.findMapperField((TypeSpec.Builder)builder, (String)responseMapperName).modifiers.contains((Object)Modifier.STATIC) ? CodeBlock.of((String)"$T", (Object[])new Object[]{this.implClassName(methodData.element)}) : CodeBlock.of((String)"this", (Object[])new Object[0]);
                b.addStatement("_result = $L.$N.apply(_response)", new Object[]{ref, responseMapperName});
            }
            b.nextControlFlow("else", new Object[0]);
            b.addStatement("return $T.fromResponse(_response)", new Object[]{HttpClientClassNames.httpClientResponseException});
            b.endControlFlow();
        } else {
            b.addStatement("var _code = _response.code()", new Object[0]);
            b.add("_result = switch (_code) {\n", new Object[0]);
            ResponseCodeMapperData defaultMapper = null;
            for (ResponseCodeMapperData codeMapper : methodData.codeMappers()) {
                CodeBlock ref;
                if (codeMapper.code() == -1) {
                    defaultMapper = codeMapper;
                    continue;
                }
                String responseMapperName = String.valueOf(methodData.element().getSimpleName()) + codeMapper.code() + "ResponseMapper";
                CodeBlock codeBlock = ref = ClientClassGenerator.findMapperField((TypeSpec.Builder)builder, (String)responseMapperName).modifiers.contains((Object)Modifier.STATIC) ? CodeBlock.of((String)"$T", (Object[])new Object[]{this.implClassName(methodData.element)}) : CodeBlock.of((String)"this", (Object[])new Object[0]);
                if (this.isMapperAssignable(resultType, codeMapper.type, codeMapper.mapper)) {
                    b.add("  case $L -> $L.$L.apply(_response);\n", new Object[]{codeMapper.code(), ref, responseMapperName});
                    continue;
                }
                b.add("  case $L -> $L.$L.apply(_response).thenCompose($T::failedFuture);\n", new Object[]{codeMapper.code(), ref, responseMapperName, CompletableFuture.class});
            }
            if (defaultMapper == null) {
                b.add("  default -> $T.fromResponse(_response);\n", new Object[]{HttpClientClassNames.httpClientResponseException});
            } else {
                CodeBlock ref;
                String responseMapperName = String.valueOf(methodData.element().getSimpleName()) + "DefaultResponseMapper";
                CodeBlock codeBlock = ref = ClientClassGenerator.findMapperField((TypeSpec.Builder)builder, (String)responseMapperName).modifiers.contains((Object)Modifier.STATIC) ? CodeBlock.of((String)"$T", (Object[])new Object[]{this.implClassName(methodData.element)}) : CodeBlock.of((String)"this", (Object[])new Object[0]);
                if (this.isMapperAssignable(resultType, defaultMapper.type, defaultMapper.mapper)) {
                    b.add("  default -> $L.$L.apply(_response);\n", new Object[]{ref, responseMapperName});
                } else {
                    b.add("  default -> $L.$L.apply(_response).thenCompose($T::failedFuture);\n", new Object[]{ref, responseMapperName, CompletableFuture.class});
                }
            }
            b.add("};\n", new Object[0]);
        }
        return b.build();
    }

    private CodeBlock buildCallFuture(TypeSpec.Builder builder, MethodData method) {
        DeclaredType dt;
        DeclaredType returnType = (DeclaredType)method.element().getReturnType();
        TypeMirror returnTypeContent = returnType.getTypeArguments().get(0);
        CodeBlock.Builder b = CodeBlock.builder();
        b.add("return _client.execute(_request)$>\n", new Object[0]).add(".thenCompose(_response -> {$>\n", new Object[0]);
        b.addStatement("$T _result", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(CompletionStage.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)TypeName.get((TypeMirror)returnTypeContent))})});
        b.beginControlFlow("try", new Object[0]);
        b.add(this.mapFutureResponse(builder, method, returnTypeContent));
        b.nextControlFlow("catch (Throwable _e)", new Object[0]);
        b.addStatement("_result = $T.failedFuture(_e)", new Object[]{CompletableFuture.class});
        b.endControlFlow();
        b.add("return _result.whenComplete((__r, _err) -> {$>\n", new Object[0]);
        b.add("try {\n", new Object[0]);
        b.add("  _response.close();\n", new Object[0]);
        b.add("} catch (Exception _ex) {\n", new Object[0]);
        b.add("   _err.addSuppressed(_ex);\n", new Object[0]);
        b.add("}$<\n", new Object[0]);
        b.add("});$<\n", new Object[0]);
        b.add("}).<$T>thenApply(_r -> _r)", new Object[]{TypeName.get((TypeMirror)returnTypeContent)});
        TypeMirror typeMirror = method.element.getReturnType();
        if (typeMirror instanceof DeclaredType && (dt = (DeclaredType)typeMirror).asElement().toString().equals(CompletableFuture.class.getCanonicalName())) {
            b.add(".toCompletableFuture()", new Object[0]);
        }
        b.add(";$<\n", new Object[0]);
        return b.build();
    }

    private CodeBlock buildCallMono(TypeSpec.Builder builder, MethodData method) {
        DeclaredType returnType = (DeclaredType)method.element().getReturnType();
        TypeMirror returnTypeContent = returnType.getTypeArguments().get(0);
        CodeBlock.Builder b = CodeBlock.builder();
        b.add("return $T.fromFuture(() -> _client.execute(_request)$>\n", new Object[]{CommonClassNames.mono}).add(".thenCompose(_response -> {$>\n", new Object[0]);
        b.addStatement("$T _result", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(CompletionStage.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)TypeName.get((TypeMirror)returnTypeContent))})});
        b.beginControlFlow("try", new Object[0]);
        b.add(this.mapFutureResponse(builder, method, returnTypeContent));
        b.nextControlFlow("catch (Throwable _e)", new Object[0]);
        b.addStatement("_result = $T.failedFuture(_e)", new Object[]{CompletableFuture.class});
        b.endControlFlow();
        b.add("return _result.whenComplete((__r, _err) -> {$>\n", new Object[0]);
        b.add("try {\n", new Object[0]);
        b.add("  _response.close();\n", new Object[0]);
        b.add("} catch (Exception _ex) {\n", new Object[0]);
        b.add("   _err.addSuppressed(_ex);\n", new Object[0]);
        b.add("}$<\n", new Object[0]);
        b.add("});$<\n", new Object[0]);
        b.add("}).<$T>thenApply(_r -> _r).toCompletableFuture()", new Object[]{TypeName.get((TypeMirror)returnTypeContent)});
        b.add(");$<\n", new Object[0]);
        return b.build();
    }

    private MethodSpec buildConstructor(TypeSpec.Builder tb, TypeElement element, List<MethodData> methods) {
        Map<String, ParameterizedTypeName> parameterConverters = this.parseParameterConverters(methods);
        String packageName = this.processingEnv.getElementUtils().getPackageOf(element).getQualifiedName().toString();
        String configClassName = HttpClientUtils.configName(element);
        AnnotationMirror annotation = Objects.requireNonNull(AnnotationUtils.findAnnotation((Element)element, (ClassName)HttpClientClassNames.httpClientAnnotation));
        List telemetryTag = (List)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)annotation, (String)"telemetryTag");
        List httpClientTag = (List)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)annotation, (String)"httpClientTag");
        ParameterSpec.Builder clientParameter = ParameterSpec.builder((TypeName)HttpClientClassNames.httpClient, (String)"httpClient", (Modifier[])new Modifier[0]);
        if (httpClientTag != null && !httpClientTag.isEmpty()) {
            clientParameter.addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.tag).addMember("value", TagUtils.writeTagAnnotationValue((List)httpClientTag)).build());
        }
        ParameterSpec.Builder telemetryParameter = ParameterSpec.builder((TypeName)HttpClientClassNames.httpClientTelemetryFactory, (String)"telemetryFactory", (Modifier[])new Modifier[0]);
        if (telemetryTag != null && !telemetryTag.isEmpty()) {
            telemetryParameter.addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.tag).addMember("value", TagUtils.writeTagAnnotationValue((List)telemetryTag)).build());
        }
        record Interceptor(TypeName type, @Nullable AnnotationSpec tag) {
        }
        Function<AnnotationMirror, Interceptor> interceptorParser = a -> {
            TypeMirror interceptorType = (TypeMirror)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)a, (String)"value");
            TypeName interceptorTypeName = ClassName.get((TypeMirror)Objects.requireNonNull(interceptorType));
            AnnotationMirror interceptorTag = (AnnotationMirror)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)a, (String)"tag");
            AnnotationSpec interceptorTagAnnotationSpec = interceptorTag == null ? null : AnnotationSpec.get((AnnotationMirror)interceptorTag);
            return new Interceptor(interceptorTypeName, interceptorTagAnnotationSpec);
        };
        List<Interceptor> classInterceptors = AnnotationUtils.findAnnotations((Element)element, (ClassName)HttpClientClassNames.interceptWithClassName, (ClassName)HttpClientClassNames.interceptWithContainerClassName).stream().map(interceptorParser).toList();
        int interceptorsCounter = 0;
        HashMap<Interceptor, Object> addedInterceptorsMap = new HashMap<Interceptor, Object>();
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(clientParameter.build()).addParameter((TypeName)ClassName.get((String)packageName, (String)configClassName, (String[])new String[0]), "config", new Modifier[0]).addParameter(telemetryParameter.build());
        for (Map.Entry<String, ParameterizedTypeName> entry : parameterConverters.entrySet()) {
            String readerName = entry.getKey();
            ParameterizedTypeName parameterizedTypeName = entry.getValue();
            tb.addField((TypeName)parameterizedTypeName, readerName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            builder.addParameter((TypeName)parameterizedTypeName, readerName, new Modifier[0]);
            builder.addStatement("this.$1L = $1L", new Object[]{readerName});
        }
        builder.addStatement("this.rootUrl = $T.requireNonNull(config.url())", new Object[]{Objects.class});
        for (Interceptor classInterceptor : classInterceptors) {
            if (addedInterceptorsMap.containsKey(classInterceptor)) continue;
            String name = "$interceptor" + (interceptorsCounter + 1);
            ParameterSpec.Builder p2 = ParameterSpec.builder((TypeName)classInterceptor.type, (String)name, (Modifier[])new Modifier[0]);
            if (classInterceptor.tag != null) {
                p2.addAnnotation(classInterceptor.tag);
            }
            ParameterSpec parameter = p2.build();
            builder.addParameter(parameter);
            addedInterceptorsMap.put(classInterceptor, name);
            ++interceptorsCounter;
        }
        classInterceptors = new ArrayList<Interceptor>(classInterceptors);
        Collections.reverse(classInterceptors);
        for (MethodData methodData : methods) {
            List<Interceptor> methodInterceptors;
            ExecutableElement method;
            block20: {
                block18: {
                    AnnotationSpec responseMapperTags;
                    DeclaredType dt;
                    boolean isFutureOfVoid;
                    TypeMirror responseMapperField;
                    String responseMapperName;
                    block19: {
                        method = methodData.element();
                        methodInterceptors = AnnotationUtils.findAnnotations((Element)methodData.element, (ClassName)HttpClientClassNames.interceptWithClassName, (ClassName)HttpClientClassNames.interceptWithContainerClassName).stream().map(interceptorParser).filter(Predicate.not(classInterceptors::contains)).distinct().toList();
                        for (Parameter parameter : methodData.parameters()) {
                            if (!(parameter instanceof Parameter.BodyParameter)) continue;
                            Parameter.BodyParameter bodyParameter = (Parameter.BodyParameter)parameter;
                            TypeName requestMapperType = bodyParameter.mapper() != null && bodyParameter.mapper().mapperClass() != null ? TypeName.get((TypeMirror)bodyParameter.mapper().mapperClass()) : ParameterizedTypeName.get((ClassName)HttpClientClassNames.httpClientRequestMapper, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)bodyParameter.parameter().asType())});
                            String paramName = String.valueOf(method.getSimpleName()) + "RequestMapper";
                            tb.addField(requestMapperType, paramName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                            AnnotationSpec tags = bodyParameter.mapper() != null ? bodyParameter.mapper().toTagAnnotation() : null;
                            ParameterSpec.Builder constructorParameter = ParameterSpec.builder((TypeName)requestMapperType, (String)paramName, (Modifier[])new Modifier[0]);
                            if (tags != null) {
                                constructorParameter.addAnnotation(tags);
                            }
                            builder.addParameter(constructorParameter.build());
                            builder.addStatement("this.$L = $L", new Object[]{paramName, paramName});
                        }
                        if (!methodData.codeMappers().isEmpty()) break block18;
                        responseMapperName = String.valueOf(method.getSimpleName()) + "ResponseMapper";
                        if (methodData.responseMapper() == null || methodData.responseMapper().mapperClass() == null || !CommonUtils.hasDefaultConstructorAndFinal((Types)this.types, (TypeMirror)methodData.responseMapper().mapperClass())) break block19;
                        TypeElement responseMapperTypeElement = (TypeElement)((DeclaredType)methodData.responseMapper.mapperClass()).asElement();
                        ClassName mapperClassName = ClassName.get((TypeElement)responseMapperTypeElement);
                        FieldSpec.Builder b = !responseMapperTypeElement.getTypeParameters().isEmpty() ? FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)mapperClassName, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)method.getReturnType())}), (String)responseMapperName, (Modifier[])new Modifier[0]).initializer(CodeBlock.of((String)"new $T<>()", (Object[])new Object[]{mapperClassName})) : FieldSpec.builder((TypeName)mapperClassName, (String)responseMapperName, (Modifier[])new Modifier[0]).initializer(CodeBlock.of((String)"new $T()", (Object[])new Object[]{mapperClassName}));
                        responseMapperField = b.addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).build();
                        tb.addField((FieldSpec)responseMapperField);
                        break block20;
                    }
                    boolean isVoid = method.getReturnType().getKind() == TypeKind.VOID;
                    boolean bl = isFutureOfVoid = (CommonUtils.isFuture((TypeMirror)method.getReturnType()) || CommonUtils.isMono((TypeMirror)method.getReturnType())) && (responseMapperField = method.getReturnType()) instanceof DeclaredType && (dt = (DeclaredType)responseMapperField).getTypeArguments().get(0).toString().equals("java.lang.Void");
                    if (isVoid || isFutureOfVoid) break block20;
                    Object responseMapperType = methodData.responseMapper() != null && methodData.responseMapper().mapperClass() != null ? TypeName.get((TypeMirror)methodData.responseMapper().mapperClass()) : (CommonUtils.isMono((TypeMirror)methodData.element.getReturnType()) || CommonUtils.isFuture((TypeMirror)methodData.element.getReturnType()) ? ParameterizedTypeName.get((ClassName)HttpClientClassNames.httpClientResponseMapper, (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get(CompletionStage.class), (TypeName[])new TypeName[]{(TypeName)((ParameterizedTypeName)methodData.returnType()).typeArguments.get(0)})}) : ParameterizedTypeName.get((ClassName)HttpClientClassNames.httpClientResponseMapper, (TypeName[])new TypeName[]{methodData.returnType()}));
                    ParameterSpec.Builder responseMapperParameter = ParameterSpec.builder((TypeName)responseMapperType, (String)responseMapperName, (Modifier[])new Modifier[0]);
                    AnnotationSpec annotationSpec = responseMapperTags = methodData.responseMapper() != null ? methodData.responseMapper().toTagAnnotation() : null;
                    if (responseMapperTags != null) {
                        responseMapperParameter.addAnnotation(responseMapperTags);
                    }
                    tb.addField(responseMapperType, responseMapperName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                    builder.addParameter(responseMapperParameter.build());
                    builder.addStatement("this.$L = $L", new Object[]{responseMapperName, responseMapperName});
                    break block20;
                }
                for (ResponseCodeMapperData codeMapper : methodData.codeMappers()) {
                    AnnotationSpec responseMapperTags;
                    String responseMapperName = String.valueOf(method.getSimpleName()) + String.valueOf(codeMapper.code() > 0 ? Integer.valueOf(codeMapper.code()) : "Default") + "ResponseMapper";
                    if (codeMapper.mapper() != null && CommonUtils.hasDefaultConstructorAndFinal((Types)this.types, (TypeMirror)codeMapper.mapper())) {
                        TypeElement mapperTypeElement = (TypeElement)codeMapper.mapper().asElement();
                        ClassName mapperTypeName = ClassName.get((TypeElement)mapperTypeElement);
                        FieldSpec.Builder b = mapperTypeElement.getTypeParameters().isEmpty() ? FieldSpec.builder((TypeName)mapperTypeName, (String)responseMapperName, (Modifier[])new Modifier[0]).initializer(CodeBlock.of((String)"new $T()", (Object[])new Object[]{mapperTypeName})) : FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)mapperTypeName, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)method.getReturnType())}), (String)responseMapperName, (Modifier[])new Modifier[0]).initializer(CodeBlock.of((String)"new $T<>()", (Object[])new Object[]{mapperTypeName}));
                        FieldSpec responseMapperField = b.addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).build();
                        tb.addField(responseMapperField);
                        continue;
                    }
                    TypeMirror returnType = method.getReturnType();
                    TypeName responseMapperType = CommonUtils.isMono((TypeMirror)returnType) || CommonUtils.isFuture((TypeMirror)returnType) ? codeMapper.futureResponseMapperType(((DeclaredType)returnType).getTypeArguments().get(0)) : codeMapper.responseMapperType(returnType);
                    ParameterSpec.Builder responseMapperParameter = ParameterSpec.builder((TypeName)responseMapperType, (String)responseMapperName, (Modifier[])new Modifier[0]);
                    AnnotationSpec annotationSpec = responseMapperTags = methodData.responseMapper() != null ? methodData.responseMapper().toTagAnnotation() : null;
                    if (responseMapperTags != null) {
                        responseMapperParameter.addAnnotation(responseMapperTags);
                    }
                    tb.addField(responseMapperType, responseMapperName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                    builder.addParameter(responseMapperParameter.build());
                    builder.addStatement("this.$L = $L", new Object[]{responseMapperName, responseMapperName});
                }
            }
            Name name = method.getSimpleName();
            AnnotationMirror httpRoute = AnnotationUtils.findAnnotation((Element)method, (ClassName)HttpClientClassNames.httpRoute);
            Object httpPath = AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)httpRoute, (String)"path");
            builder.addCode("var $L = config.apply(httpClient, $T.class, $S, config.$L(), telemetryFactory, $S);\n", new Object[]{name, element, name, name, httpPath});
            builder.addCode("this.$LUriTemplate = $L.url();\n", new Object[]{name, name});
            boolean hasUriParameters = methodData.parameters().stream().anyMatch(p -> p instanceof Parameter.QueryParameter || p instanceof Parameter.PathParameter);
            if (!hasUriParameters) {
                builder.addCode("this.$LUri = $T.create($L.url());\n", new Object[]{name, URI.class, name});
            }
            builder.addCode("this.$LClient = $L.client()", new Object[]{name, name});
            if (!methodInterceptors.isEmpty() || !classInterceptors.isEmpty()) {
                Object interceptorName;
                builder.addCode("\n", new Object[0]);
                for (Interceptor methodInterceptor : methodInterceptors) {
                    if (addedInterceptorsMap.containsKey(methodInterceptor)) continue;
                    interceptorName = "$interceptor" + (interceptorsCounter + 1);
                    ParameterSpec.Builder p3 = ParameterSpec.builder((TypeName)methodInterceptor.type, (String)interceptorName, (Modifier[])new Modifier[0]);
                    if (methodInterceptor.tag != null) {
                        p3.addAnnotation(methodInterceptor.tag);
                    }
                    ParameterSpec parameter = p3.build();
                    builder.addParameter(parameter);
                    addedInterceptorsMap.put(methodInterceptor, interceptorName);
                    ++interceptorsCounter;
                }
                methodInterceptors = new ArrayList<Interceptor>(methodInterceptors);
                Collections.reverse(methodInterceptors);
                for (Interceptor methodInterceptor : methodInterceptors) {
                    interceptorName = (String)addedInterceptorsMap.get(methodInterceptor);
                    builder.addCode("  .with($L)\n", new Object[]{interceptorName});
                }
                for (Interceptor classInterceptor : classInterceptors) {
                    interceptorName = (String)addedInterceptorsMap.get(classInterceptor);
                    builder.addCode("  .with($L)\n", new Object[]{interceptorName});
                }
            }
            builder.addCode(";\n", new Object[0]);
            builder.addCode("this.$LRequestTimeout = $L.requestTimeout();\n", new Object[]{name, name});
        }
        return builder.build();
    }

    private boolean isMapperAssignable(TypeMirror resultType, @Nullable TypeMirror mappingType, @Nullable DeclaredType mappingMapper) {
        if (mappingType == null && mappingMapper == null) {
            return true;
        }
        if (mappingType != null) {
            return this.types.isAssignable(mappingType, resultType);
        }
        DeclaredType responseMapperType = TypeUtils.findSupertype((DeclaredType)mappingMapper, (ClassName)HttpClientClassNames.httpClientResponseMapper);
        TypeMirror typeArg = responseMapperType.getTypeArguments().get(0);
        if (CommonUtils.isFuture((TypeMirror)typeArg)) {
            typeArg = ((DeclaredType)typeArg).getTypeArguments().get(0);
        }
        return typeArg.getKind() == TypeKind.TYPEVAR || this.types.isAssignable(typeArg, resultType);
    }

    private List<MethodData> parseMethods(TypeElement element) {
        ArrayList<MethodData> result = new ArrayList<MethodData>();
        for (Element element2 : this.elements.getAllMembers(element)) {
            ExecutableElement method;
            if (element2.getKind() != ElementKind.METHOD || (method = (ExecutableElement)element2).getModifiers().contains((Object)Modifier.DEFAULT) || method.getModifiers().contains((Object)Modifier.STATIC) || method.getEnclosingElement().toString().equals("java.lang.Object")) continue;
            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
            for (int i = 0; i < method.getParameters().size(); ++i) {
                Parameter parameter = Parameter.parse(method, i);
                parameters.add(parameter);
            }
            TypeName returnType = TypeName.get((TypeMirror)method.getReturnType());
            List<ResponseCodeMapperData> responseCodeMappers = this.parseMapperData(method);
            CommonUtils.MappingData responseMapper = CommonUtils.parseMapping((Element)method).getMapping(HttpClientClassNames.httpClientResponseMapper);
            result.add(new MethodData(method, returnType, responseMapper, responseCodeMappers, parameters));
        }
        return result;
    }

    private List<ResponseCodeMapperData> parseMapperData(ExecutableElement element) {
        List annotations = AnnotationUtils.findAnnotations((Element)element, (ClassName)HttpClientClassNames.responseCodeMapper, (ClassName)HttpClientClassNames.responseCodeMappers);
        if (annotations.isEmpty()) {
            return List.of();
        }
        return annotations.stream().map(a -> this.parseMapperData(element, (AnnotationMirror)a)).toList();
    }

    private ResponseCodeMapperData parseMapperData(ExecutableElement method, AnnotationMirror annotation) {
        Integer code = Objects.requireNonNull((Integer)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)annotation, (String)"code"));
        TypeMirror type = (TypeMirror)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)annotation, (String)"type");
        DeclaredType mapper = (DeclaredType)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)annotation, (String)"mapper");
        if (mapper == null && type == null) {
            TypeMirror returnType = method.getReturnType();
            if (returnType.getKind() == TypeKind.VOID) {
                returnType = this.elements.getTypeElement("java.lang.Void").asType();
            }
            return new ResponseCodeMapperData(code, null, null);
        }
        return new ResponseCodeMapperData(code, type, mapper);
    }

    private Map<String, ParameterizedTypeName> parseParameterConverters(List<MethodData> methods) {
        HashMap<String, ParameterizedTypeName> result = new HashMap<String, ParameterizedTypeName>();
        for (MethodData method : methods) {
            for (Parameter parameter : method.parameters) {
                Parameter.PathParameter pathParameter;
                TypeMirror type;
                if (parameter instanceof Parameter.PathParameter && this.requiresConverter(type = (pathParameter = (Parameter.PathParameter)parameter).parameter().asType())) {
                    result.put(this.getConverterName(method, pathParameter.parameter()), this.getConverterTypeName(type));
                }
                if (parameter instanceof Parameter.QueryParameter) {
                    Parameter.QueryParameter queryParameter = (Parameter.QueryParameter)parameter;
                    type = queryParameter.parameter().asType();
                    if (CommonUtils.isCollection((TypeMirror)type)) {
                        type = ((DeclaredType)type).getTypeArguments().get(0);
                    } else if (CommonUtils.isMap((TypeMirror)type)) {
                        type = ((DeclaredType)type).getTypeArguments().get(1);
                    }
                    if (this.requiresConverter(type)) {
                        result.put(this.getConverterName(method, queryParameter.parameter()), this.getConverterTypeName(type));
                    }
                }
                if (parameter instanceof Parameter.HeaderParameter) {
                    Parameter.HeaderParameter headerParameter = (Parameter.HeaderParameter)parameter;
                    type = headerParameter.parameter().asType();
                    if (CommonUtils.isCollection((TypeMirror)type)) {
                        type = ((DeclaredType)type).getTypeArguments().get(0);
                    } else if (CommonUtils.isMap((TypeMirror)type)) {
                        type = ((DeclaredType)type).getTypeArguments().get(1);
                    }
                    if (this.requiresConverter(type) && !ClassName.get((TypeMirror)headerParameter.parameter().asType()).equals((Object)HttpClientClassNames.httpHeaders)) {
                        result.put(this.getConverterName(method, headerParameter.parameter()), this.getConverterTypeName(type));
                    }
                }
                if (!(parameter instanceof Parameter.CookieParameter)) continue;
                Parameter.CookieParameter cookieParameter = (Parameter.CookieParameter)parameter;
                type = cookieParameter.parameter().asType();
                if (CommonUtils.isCollection((TypeMirror)type)) {
                    type = ((DeclaredType)type).getTypeArguments().get(0);
                } else if (CommonUtils.isMap((TypeMirror)type)) {
                    type = ((DeclaredType)type).getTypeArguments().get(1);
                }
                if (!this.requiresConverter(type) || ClassName.get((TypeMirror)cookieParameter.parameter().asType()).equals((Object)HttpClientClassNames.httpCookie)) continue;
                result.put(this.getConverterName(method, cookieParameter.parameter()), this.getConverterTypeName(type));
            }
        }
        return result;
    }

    private boolean requiresConverter(TypeMirror type) {
        if (type.getKind().isPrimitive()) {
            return false;
        }
        if (type instanceof DeclaredType) {
            DeclaredType dt = (DeclaredType)type;
            return !this.primitiveTypes.contains(dt.asElement().toString());
        }
        return false;
    }

    private String getConverterName(MethodData method, VariableElement parameter) {
        return method.element.getSimpleName().toString() + CommonUtils.capitalize((String)parameter.getSimpleName().toString()) + "Converter";
    }

    private ParameterizedTypeName getConverterTypeName(TypeMirror type) {
        return ParameterizedTypeName.get((ClassName)HttpClientClassNames.stringParameterConverter, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)type)});
    }

    record MethodData(ExecutableElement element, TypeName returnType, @Nullable CommonUtils.MappingData responseMapper, List<ResponseCodeMapperData> codeMappers, List<Parameter> parameters) {
    }

    private record RoutePart(@Nullable Parameter.PathParameter parameter, @Nullable String string) {
        RoutePart {
            if (parameter != null && string != null) {
                throw new IllegalStateException();
            }
        }
    }

    record ResponseCodeMapperData(int code, @Nullable TypeMirror type, @Nullable DeclaredType mapper) {
        public TypeName responseMapperType(TypeMirror returnType) {
            if (this.mapper() != null) {
                TypeElement mapperElement = (TypeElement)this.mapper().asElement();
                if (mapperElement.getTypeParameters().isEmpty()) {
                    return TypeName.get((TypeMirror)this.mapper());
                }
                if (this.type() != null) {
                    TypeName publisherParam = TypeName.get((TypeMirror)this.type());
                    return ParameterizedTypeName.get((ClassName)ClassName.get((TypeElement)mapperElement), (TypeName[])new TypeName[]{publisherParam});
                }
                TypeName publisherParam = TypeName.get((TypeMirror)returnType);
                return ParameterizedTypeName.get((ClassName)ClassName.get((TypeElement)mapperElement), (TypeName[])new TypeName[]{publisherParam});
            }
            if (this.type() != null) {
                TypeName publisherParam = TypeName.get((TypeMirror)this.type());
                return ParameterizedTypeName.get((ClassName)HttpClientClassNames.httpClientResponseMapper, (TypeName[])new TypeName[]{publisherParam.box()});
            }
            TypeName publisherParam = TypeName.get((TypeMirror)returnType);
            return ParameterizedTypeName.get((ClassName)HttpClientClassNames.httpClientResponseMapper, (TypeName[])new TypeName[]{publisherParam.box()});
        }

        public TypeName futureResponseMapperType(TypeMirror returnType) {
            if (this.mapper() != null) {
                TypeElement mapperElement = (TypeElement)this.mapper().asElement();
                if (mapperElement.getTypeParameters().isEmpty()) {
                    return TypeName.get((TypeMirror)this.mapper());
                }
                if (this.type() != null) {
                    TypeName publisherParam = TypeName.get((TypeMirror)this.type());
                    return ParameterizedTypeName.get((ClassName)ClassName.get((TypeElement)mapperElement), (TypeName[])new TypeName[]{publisherParam});
                }
                TypeName publisherParam = TypeName.get((TypeMirror)returnType);
                return ParameterizedTypeName.get((ClassName)ClassName.get((TypeElement)mapperElement), (TypeName[])new TypeName[]{publisherParam});
            }
            if (this.type() != null) {
                TypeName publisherParam = TypeName.get((TypeMirror)this.type());
                return ParameterizedTypeName.get((ClassName)HttpClientClassNames.httpClientResponseMapper, (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get(CompletionStage.class), (TypeName[])new TypeName[]{publisherParam})});
            }
            TypeName publisherParam = TypeName.get((TypeMirror)returnType);
            return ParameterizedTypeName.get((ClassName)HttpClientClassNames.httpClientResponseMapper, (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get(CompletionStage.class), (TypeName[])new TypeName[]{publisherParam})});
        }
    }
}

