/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.annotation.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import ru.tinkoff.kora.annotation.processor.common.AbstractKoraProcessor;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.http.client.annotation.processor.ClientClassGenerator;
import ru.tinkoff.kora.http.client.annotation.processor.ConfigClassGenerator;
import ru.tinkoff.kora.http.client.annotation.processor.ConfigModuleGenerator;
import ru.tinkoff.kora.http.client.annotation.processor.HttpClientClassNames;

public class HttpClientAnnotationProcessor
extends AbstractKoraProcessor {
    private ClientClassGenerator clientGenerator;
    private ConfigClassGenerator configGenerator;
    private ConfigModuleGenerator configModuleGenerator;

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.clientGenerator = new ClientClassGenerator(processingEnv);
        this.configGenerator = new ConfigClassGenerator(processingEnv.getElementUtils());
        this.configModuleGenerator = new ConfigModuleGenerator(processingEnv);
    }

    public Set<ClassName> getSupportedAnnotationClassNames() {
        return Set.of(HttpClientClassNames.httpClientAnnotation);
    }

    public void process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv, Map<ClassName, List<AbstractKoraProcessor.AnnotatedElement>> annotatedElements) {
        List elements = annotatedElements.getOrDefault(HttpClientClassNames.httpClientAnnotation, List.of());
        for (AbstractKoraProcessor.AnnotatedElement annotated : elements) {
            Element httpClient = annotated.element();
            if (httpClient.getKind() != ElementKind.INTERFACE) continue;
            TypeElement typeElement = (TypeElement)httpClient;
            try {
                this.generateClient(typeElement);
            }
            catch (ProcessingErrorException e) {
                e.printError(this.processingEnv);
            }
        }
    }

    private void generateClient(TypeElement element) {
        String packageName = this.elements.getPackageOf(element).getQualifiedName().toString();
        TypeSpec client = this.clientGenerator.generate(element);
        TypeSpec config = this.configGenerator.generate(element);
        JavaFile configModule = this.configModuleGenerator.generate(element);
        CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)configModule);
        CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)JavaFile.builder((String)packageName, (TypeSpec)client).build());
        CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)JavaFile.builder((String)packageName, (TypeSpec)config).build());
    }
}

