/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.annotation.processor;

import com.squareup.javapoet.ClassName;
import jakarta.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.http.client.annotation.processor.HttpClientClassNames;

public interface Parameter {
    public static Parameter parse(ExecutableElement method, int parameterIndex) {
        VariableElement parameter = method.getParameters().get(parameterIndex);
        AnnotationMirror header = AnnotationUtils.findAnnotation((Element)parameter, (ClassName)HttpClientClassNames.header);
        AnnotationMirror path = AnnotationUtils.findAnnotation((Element)parameter, (ClassName)HttpClientClassNames.path);
        AnnotationMirror query = AnnotationUtils.findAnnotation((Element)parameter, (ClassName)HttpClientClassNames.query);
        AnnotationMirror cookie = AnnotationUtils.findAnnotation((Element)parameter, (ClassName)HttpClientClassNames.cookie);
        if (header != null) {
            String headerValue = (String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)header, (String)"value");
            String name = headerValue == null || headerValue.isBlank() ? parameter.getSimpleName().toString() : headerValue;
            return new HeaderParameter(parameter, name);
        }
        if (path != null) {
            String pathValue = (String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)path, (String)"value");
            String name = pathValue == null || pathValue.isBlank() ? parameter.getSimpleName().toString() : pathValue;
            return new PathParameter(parameter, name);
        }
        if (query != null) {
            String queryValue = (String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)query, (String)"value");
            String name = queryValue == null || queryValue.isBlank() ? parameter.getSimpleName().toString() : queryValue;
            return new QueryParameter(parameter, name);
        }
        if (cookie != null) {
            String cookieValue = (String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)cookie, (String)"value");
            String name = cookieValue == null || cookieValue.isBlank() ? parameter.getSimpleName().toString() : cookieValue;
            return new CookieParameter(parameter, name);
        }
        CommonUtils.MappingData mapping = CommonUtils.parseMapping((Element)parameter).getMapping(HttpClientClassNames.httpClientRequestMapper);
        return new BodyParameter(parameter, mapping);
    }

    public record HeaderParameter(VariableElement parameter, String headerName) implements Parameter
    {
    }

    public record PathParameter(VariableElement parameter, String pathParameterName) implements Parameter
    {
    }

    public record QueryParameter(VariableElement parameter, String queryParameterName) implements Parameter
    {
    }

    public record CookieParameter(VariableElement parameter, String cookieName) implements Parameter
    {
    }

    public record BodyParameter(VariableElement parameter, @Nullable CommonUtils.MappingData mapper) implements Parameter
    {
    }

    public record ContinuationParameter(VariableElement parameter) implements Parameter
    {
    }
}

