/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common.auth;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import ru.tinkoff.kora.http.client.common.auth.HttpClientTokenProvider;
import ru.tinkoff.kora.http.client.common.request.HttpClientRequest;

public class BasicAuthHttpClientTokenProvider
implements HttpClientTokenProvider {
    private final String token;
    private final CompletableFuture<String> tokenFuture;

    public BasicAuthHttpClientTokenProvider(String username, String password) {
        String usernameAndPassword = username + ":" + password;
        this.token = Base64.getEncoder().encodeToString(usernameAndPassword.getBytes(StandardCharsets.US_ASCII));
        this.tokenFuture = CompletableFuture.completedFuture(this.token);
    }

    @Override
    public CompletionStage<String> getToken(HttpClientRequest request) {
        return this.tokenFuture;
    }
}

