/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common.declarative;

import jakarta.annotation.Nullable;
import java.time.Duration;
import ru.tinkoff.kora.http.client.common.HttpClient;
import ru.tinkoff.kora.http.client.common.declarative.DeclarativeHttpClientOperationData;
import ru.tinkoff.kora.http.client.common.declarative.HttpClientOperationConfig;
import ru.tinkoff.kora.http.client.common.declarative.HttpClientOperationTelemetryConfig;
import ru.tinkoff.kora.http.client.common.interceptor.TelemetryInterceptor;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientTelemetry;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientTelemetryFactory;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public interface DeclarativeHttpClientConfig {
    public String url();

    public TelemetryConfig telemetry();

    @Nullable
    public Duration requestTimeout();

    default public DeclarativeHttpClientOperationData apply(HttpClient root, Class<?> clientClass, String operationName, HttpClientOperationConfig operationConfig, HttpClientTelemetryFactory telemetryFactory, String operationPath) {
        HttpClientOperationTelemetryConfig telemetryConfig;
        HttpClientTelemetry telemetry;
        Duration requestTimeout;
        HttpClient builder = root;
        String url = this.url() + operationPath;
        Duration duration = requestTimeout = this.requestTimeout() == null ? null : this.requestTimeout();
        if (operationConfig.requestTimeout() != null) {
            requestTimeout = operationConfig.requestTimeout();
        }
        if ((telemetry = telemetryFactory.get(telemetryConfig = new HttpClientOperationTelemetryConfig(this.telemetry(), operationConfig.telemetry()), clientClass.getCanonicalName() + "." + operationName)) != null) {
            builder = builder.with(new TelemetryInterceptor(telemetry));
        }
        return new DeclarativeHttpClientOperationData(builder, url, requestTimeout);
    }
}

