/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common.declarative;

import jakarta.annotation.Nullable;
import java.util.Objects;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public final class HttpClientOperationTelemetryConfig
implements TelemetryConfig {
    private final OperationLogConfig logging;
    private final OperationMetricConfig metrics;
    private final OperationTracingConfig tracing;

    public HttpClientOperationTelemetryConfig(TelemetryConfig client, TelemetryConfig operation) {
        this.logging = new OperationLogConfig(client.logging(), operation.logging());
        this.metrics = new OperationMetricConfig(client.metrics(), operation.metrics());
        this.tracing = new OperationTracingConfig(client.tracing(), operation.tracing());
    }

    public TelemetryConfig.LogConfig logging() {
        return this.logging;
    }

    public TelemetryConfig.TracingConfig tracing() {
        return this.tracing;
    }

    public TelemetryConfig.MetricsConfig metrics() {
        return this.metrics;
    }

    private static class OperationLogConfig
    implements TelemetryConfig.LogConfig {
        private final TelemetryConfig.LogConfig client;
        private final TelemetryConfig.LogConfig operation;

        private OperationLogConfig(TelemetryConfig.LogConfig client, TelemetryConfig.LogConfig operation) {
            this.client = Objects.requireNonNull(client);
            this.operation = Objects.requireNonNull(operation);
        }

        @Nullable
        public Boolean enabled() {
            if (this.operation.enabled() != null) {
                return this.operation.enabled();
            }
            return this.client.enabled();
        }
    }

    private static class OperationMetricConfig
    implements TelemetryConfig.MetricsConfig {
        private final TelemetryConfig.MetricsConfig client;
        private final TelemetryConfig.MetricsConfig operation;

        private OperationMetricConfig(TelemetryConfig.MetricsConfig client, TelemetryConfig.MetricsConfig operation) {
            this.client = Objects.requireNonNull(client);
            this.operation = Objects.requireNonNull(operation);
        }

        @Nullable
        public Boolean enabled() {
            if (this.operation.enabled() != null) {
                return this.operation.enabled();
            }
            return this.client.enabled();
        }

        public double[] slo() {
            if (this.operation.slo() != null) {
                return this.operation.slo();
            }
            return this.client.slo();
        }
    }

    private static class OperationTracingConfig
    implements TelemetryConfig.TracingConfig {
        private final TelemetryConfig.TracingConfig client;
        private final TelemetryConfig.TracingConfig operation;

        private OperationTracingConfig(TelemetryConfig.TracingConfig client, TelemetryConfig.TracingConfig operation) {
            this.client = client;
            this.operation = operation;
        }

        @Nullable
        public Boolean enabled() {
            if (this.operation.enabled() != null) {
                return this.operation.enabled();
            }
            return this.client.enabled();
        }
    }
}

