/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common.interceptor;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.http.client.common.auth.HttpClientTokenProvider;
import ru.tinkoff.kora.http.client.common.interceptor.HttpClientInterceptor;
import ru.tinkoff.kora.http.client.common.request.HttpClientRequest;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponse;

public class BearerAuthHttpClientInterceptor
implements HttpClientInterceptor {
    private final HttpClientTokenProvider tokenProvider;

    public BearerAuthHttpClientInterceptor(HttpClientTokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    public BearerAuthHttpClientInterceptor(String token) {
        CompletableFuture<String> result = CompletableFuture.completedFuture(token);
        this.tokenProvider = request -> result;
    }

    @Override
    public CompletionStage<HttpClientResponse> processRequest(Context context, HttpClientInterceptor.InterceptChain chain, HttpClientRequest request) {
        return this.tokenProvider.getToken(request).thenCompose(token -> {
            try {
                if (token == null) {
                    return chain.process(context, request);
                }
                HttpClientRequest modifiedRequest = request.toBuilder().header("authorization", "Bearer " + token).build();
                return chain.process(context, modifiedRequest);
            }
            catch (Throwable t) {
                return CompletableFuture.failedFuture(t);
            }
        });
    }
}

