/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common.interceptor;

import java.net.URI;
import java.util.concurrent.CompletionStage;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.http.client.common.interceptor.HttpClientInterceptor;
import ru.tinkoff.kora.http.client.common.request.DefaultHttpClientRequest;
import ru.tinkoff.kora.http.client.common.request.HttpClientRequest;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponse;

public class RootUriInterceptor
implements HttpClientInterceptor {
    private final String root;

    public RootUriInterceptor(String root) {
        this.root = root.endsWith("/") ? root.substring(0, root.length() - 1) : root;
    }

    @Override
    public CompletionStage<HttpClientResponse> processRequest(Context ctx, HttpClientInterceptor.InterceptChain chain, HttpClientRequest request) throws Exception {
        if (request.uri().getScheme() != null) {
            return chain.process(ctx, request);
        }
        Object uri = request.uri().toString();
        if (!((String)uri).startsWith("/")) {
            uri = "/" + (String)uri;
        }
        String prefixed = this.root + (String)uri;
        URI parsed = URI.create(prefixed);
        DefaultHttpClientRequest r = new DefaultHttpClientRequest(request.method(), parsed, request.uriTemplate(), request.headers(), request.body(), request.requestTimeout());
        return chain.process(ctx, r);
    }
}

