/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common.interceptor;

import java.util.concurrent.CompletionStage;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.http.client.common.interceptor.HttpClientInterceptor;
import ru.tinkoff.kora.http.client.common.request.HttpClientRequest;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponse;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientTelemetry;

public class TelemetryInterceptor
implements HttpClientInterceptor {
    private final HttpClientTelemetry telemetry;

    public TelemetryInterceptor(HttpClientTelemetry telemetry) {
        this.telemetry = telemetry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<HttpClientResponse> processRequest(Context ctx, HttpClientInterceptor.InterceptChain chain, HttpClientRequest request) throws Exception {
        if (!this.telemetry.isEnabled()) {
            return chain.process(ctx, request);
        }
        try {
            Context fork = ctx.fork();
            HttpClientTelemetry.HttpClientTelemetryContext telemetryContext = this.telemetry.get(fork, request);
            if (telemetryContext == null) {
                CompletionStage<HttpClientResponse> completionStage = chain.process(ctx, request);
                return completionStage;
            }
            fork.inject();
            CompletionStage<HttpClientResponse> completionStage = chain.process(fork, telemetryContext.request()).whenComplete((rs, error) -> {
                if (error != null) {
                    Context old = Context.current();
                    try {
                        fork.inject();
                        telemetryContext.close(null, (Throwable)error);
                    }
                    finally {
                        old.inject();
                    }
                }
            }).thenApply(rs -> {
                Context old = Context.current();
                try {
                    fork.inject();
                    HttpClientResponse httpClientResponse = telemetryContext.close((HttpClientResponse)rs, null);
                    return httpClientResponse;
                }
                finally {
                    old.inject();
                }
            });
            return completionStage;
        }
        finally {
            ctx.inject();
        }
    }
}

