/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common.request;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Flow;
import ru.tinkoff.kora.http.client.common.form.FormMultipartClientRequestMapper;
import ru.tinkoff.kora.http.client.common.form.FormUrlEncodedClientRequestMapper;
import ru.tinkoff.kora.http.client.common.request.HttpClientRequestMapper;
import ru.tinkoff.kora.http.common.body.HttpBody;
import ru.tinkoff.kora.http.common.body.HttpBodyOutput;

public interface HttpClientRequestMapperModule {
    default public HttpClientRequestMapper<byte[]> byteArrayHttpClientRequestMapper() {
        return (ctx, body) -> HttpBody.octetStream((byte[])body);
    }

    default public HttpClientRequestMapper<ByteBuffer> byteBufferHttpClientRequestMapper() {
        return (ctx, body) -> HttpBody.octetStream((ByteBuffer)body);
    }

    default public HttpClientRequestMapper<String> stringHttpClientRequestMapper() {
        return (ctx, body) -> HttpBody.octetStream((byte[])body.getBytes(StandardCharsets.UTF_8));
    }

    default public HttpClientRequestMapper<Flow.Publisher<ByteBuffer>> byteBufferPublisherHttpClientRequestMapper() {
        return (ctx, body) -> HttpBodyOutput.octetStream((Flow.Publisher)body);
    }

    default public FormUrlEncodedClientRequestMapper formUrlEncodedClientRequestMapper() {
        return new FormUrlEncodedClientRequestMapper();
    }

    default public FormMultipartClientRequestMapper formMultipartClientRequestMapper() {
        return new FormMultipartClientRequestMapper();
    }
}

