/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common.response;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import ru.tinkoff.kora.common.util.FlowUtils;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponse;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponseMapper;
import ru.tinkoff.kora.http.common.HttpResponseEntity;
import ru.tinkoff.kora.http.common.body.HttpBody;
import ru.tinkoff.kora.http.common.body.HttpBodyInput;
import ru.tinkoff.kora.http.common.header.MutableHttpHeaders;

public interface HttpClientResponseMapperModule {
    default public HttpClientResponseMapper<String> stringHttpClientResponseMapper() {
        return HttpClientResponseMapper.fromAsync(response -> response.body().asArrayStage().thenApply(r -> new String((byte[])r, StandardCharsets.UTF_8)));
    }

    default public HttpClientResponseMapper<CompletionStage<String>> stringCompletionStageHttpClientResponseMapper() {
        return response -> response.body().asArrayStage().thenApply(r -> new String((byte[])r, StandardCharsets.UTF_8));
    }

    default public HttpClientResponseMapper<byte[]> byteArrayHttpClientResponseMapper() {
        return HttpClientResponseMapper.fromAsync(response -> response.body().asArrayStage());
    }

    default public HttpClientResponseMapper<CompletionStage<byte[]>> byteArrayCompletionStageHttpClientResponseMapper() {
        return response -> response.body().asArrayStage();
    }

    default public HttpClientResponseMapper<ByteBuffer> byteBufferHttpClientResponseMapper() {
        return HttpClientResponseMapper.fromAsync(response -> response.body().asBufferStage());
    }

    default public HttpClientResponseMapper<CompletionStage<ByteBuffer>> byteBufferCompletionStageHttpClientResponseMapper() {
        return response -> response.body().asBufferStage();
    }

    default public <T> HttpClientResponseMapper<HttpResponseEntity<T>> entityResponseHttpClientResponseMapper(HttpClientResponseMapper<T> mapper) {
        return response -> HttpResponseEntity.of((int)response.code(), (MutableHttpHeaders)response.headers().toMutable(), mapper.apply(response));
    }

    default public <T> HttpClientResponseMapper<CompletionStage<HttpResponseEntity<T>>> entityResponseCompletionStageHttpClientResponseMapper(HttpClientResponseMapper<T> mapper) {
        return response -> response.body().asArrayStage().thenApply(body -> {
            try {
                HttpClientResponse.Default temp = new HttpClientResponse.Default(response.code(), response.headers(), (HttpBodyInput)HttpBody.of((byte[])body), () -> {});
                return HttpResponseEntity.of((int)temp.code(), (MutableHttpHeaders)temp.headers().toMutable(), mapper.apply(temp));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    default public HttpClientResponseMapper<Flow.Publisher<ByteBuffer>> byteBufferFluxHttpClientResponseMapper() {
        return HttpClientResponse::body;
    }

    default public HttpClientResponseMapper<Void> voidHttpClientResponseMapper() {
        return response -> null;
    }

    default public HttpClientResponseMapper<CompletionStage<Void>> voidFutureHttpClientResponseMapper() {
        return response -> {
            response.body().subscribe(FlowUtils.drain());
            return CompletableFuture.completedFuture(null);
        };
    }
}

