/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common.telemetry;

import jakarta.annotation.Nullable;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.http.client.common.request.HttpClientRequest;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponse;
import ru.tinkoff.kora.http.client.common.telemetry.DefaultHttpClientTelemetryCollectingResponseBodyWrapper;
import ru.tinkoff.kora.http.client.common.telemetry.DefaultHttpClientTelemetryResponseBodyWrapper;
import ru.tinkoff.kora.http.client.common.telemetry.DefaultHttpClientTelemetryResponseWrapper;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientLogger;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientMetrics;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientTelemetry;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientTracer;
import ru.tinkoff.kora.http.common.HttpResultCode;
import ru.tinkoff.kora.http.common.body.HttpBody;
import ru.tinkoff.kora.http.common.body.HttpBodyOutput;
import ru.tinkoff.kora.http.common.header.HttpHeaders;
import ru.tinkoff.kora.http.common.header.MutableHttpHeaders;

public final class DefaultHttpClientTelemetry
implements HttpClientTelemetry {
    @Nullable
    private final HttpClientTracer tracing;
    @Nullable
    private final HttpClientMetrics metrics;
    @Nullable
    private final HttpClientLogger logger;

    public DefaultHttpClientTelemetry(@Nullable HttpClientTracer tracing, @Nullable HttpClientMetrics metrics, @Nullable HttpClientLogger logger) {
        this.tracing = tracing;
        this.metrics = metrics;
        this.logger = logger;
    }

    @Override
    public boolean isEnabled() {
        return this.metrics != null || this.tracing != null || this.logger != null && (this.logger.logRequest() || this.logger.logRequestBody() || this.logger.logResponse() || this.logger.logResponseBody());
    }

    private static String operation(String method, String uriTemplate, URI uri) {
        int questionMark;
        if (uri.getAuthority() != null && uri.getScheme() != null) {
            uriTemplate = uriTemplate.replace(uri.getScheme() + "://" + uri.getAuthority(), "");
        }
        if ((questionMark = uriTemplate.indexOf(63)) >= 0) {
            uriTemplate = uriTemplate.substring(0, questionMark);
        }
        return method + " " + uriTemplate;
    }

    @Override
    @Nullable
    public HttpClientTelemetry.HttpClientTelemetryContext get(Context ctx, HttpClientRequest request) {
        if (!this.isEnabled()) {
            return null;
        }
        String method = request.method();
        String resolvedUri = request.uri().toString();
        boolean isOperationRequired = this.logger != null && (this.logger.logRequest() || this.logger.logResponse());
        String operation = isOperationRequired ? DefaultHttpClientTelemetry.operation(request.method(), request.uriTemplate(), request.uri()) : null;
        TelemetryContextData data = new TelemetryContextData(request, operation);
        String authority = data.authority();
        HttpClientTracer.HttpClientSpan createSpanResult = this.tracing == null ? null : this.tracing.createSpan(ctx, request);
        MutableHttpHeaders headers = request.headers();
        if (this.logger != null && this.logger.logRequest()) {
            if (!this.logger.logRequestHeaders()) {
                this.logger.logRequest(authority, request.method(), operation, resolvedUri, null, null);
            } else if (!this.logger.logRequestBody()) {
                this.logger.logRequest(authority, request.method(), operation, resolvedUri, (HttpHeaders)headers, null);
            } else {
                Charset requestBodyCharset = this.detectCharset(request.body().contentType());
                if (requestBodyCharset == null) {
                    this.logger.logRequest(authority, request.method(), operation, resolvedUri, (HttpHeaders)headers, null);
                } else {
                    HttpBodyOutput requestBody = this.wrapRequestBody(ctx, request.body(), buffers -> {
                        String bodyString = DefaultHttpClientTelemetry.byteBufListToBodyString(buffers, requestBodyCharset);
                        this.logger.logRequest(authority, method, operation, resolvedUri, (HttpHeaders)headers, bodyString);
                    });
                    request = request.toBuilder().body(requestBody).build();
                }
            }
        }
        return new DefaultHttpClientTelemetryContextImpl(ctx, request, data, createSpanResult, this.metrics, this.logger);
    }

    private static String byteBufListToBodyString(@Nullable List<ByteBuffer> l, @Nullable Charset charset) {
        if (l == null || l.isEmpty() || charset == null) {
            return null;
        }
        int sbl = 0;
        for (ByteBuffer byteBuffer : l) {
            sbl += byteBuffer.remaining();
        }
        StringBuilder sb = new StringBuilder(sbl);
        for (ByteBuffer byteBuffer : l) {
            CharBuffer cb = charset.decode(byteBuffer);
            sb.append(cb);
        }
        return sb.toString();
    }

    private HttpBodyOutput wrapRequestBody(Context ctx, HttpBodyOutput body, final Consumer<List<ByteBuffer>> onComplete) {
        ByteBuffer full = body.getFullContentIfAvailable();
        if (full != null) {
            try {
                onComplete.accept(List.of(full.slice()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return HttpBody.of((String)body.contentType(), (ByteBuffer)full);
        }
        final ArrayList bodyChunks = new ArrayList();
        Flow.Publisher publisher = subscriber -> body.subscribe((Flow.Subscriber)new Flow.Subscriber<ByteBuffer>(){

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                subscriber.onSubscribe(subscription);
            }

            @Override
            public void onNext(ByteBuffer item) {
                bodyChunks.add(item);
                subscriber.onNext(item);
            }

            @Override
            public void onError(Throwable throwable) {
                subscriber.onError(throwable);
            }

            @Override
            public void onComplete() {
                onComplete.accept(bodyChunks);
                subscriber.onComplete();
            }
        });
        return HttpBodyOutput.of((String)body.contentType(), (long)body.contentLength(), publisher);
    }

    @Nullable
    private Charset detectCharset(String contentType) {
        if (contentType == null) {
            return null;
        }
        String[] split = contentType.split("; charset=", 2);
        if (split.length == 2) {
            return Charset.forName(split[1]);
        }
        String mimeType = split[0];
        if (mimeType.contains("text") || mimeType.contains("json") || mimeType.contains("xml")) {
            return StandardCharsets.UTF_8;
        }
        if (mimeType.contains("application/x-www-form-urlencoded")) {
            return StandardCharsets.US_ASCII;
        }
        return null;
    }

    record TelemetryContextData(long startTime, String method, String operation, String host, String scheme, String authority, String target) {
        public TelemetryContextData(HttpClientRequest request, String operation) {
            this(System.nanoTime(), request.method(), operation, request.uri().getHost(), request.uri().getScheme(), request.uri().getAuthority(), request.uriTemplate());
        }
    }

    public class DefaultHttpClientTelemetryContextImpl
    implements HttpClientTelemetry.HttpClientTelemetryContext {
        private final Context ctx;
        private final HttpClientRequest request;
        private final TelemetryContextData data;
        private final HttpClientTracer.HttpClientSpan span;
        private final HttpClientMetrics metrics;
        private final HttpClientLogger logger;

        public DefaultHttpClientTelemetryContextImpl(Context ctx, HttpClientRequest request, TelemetryContextData data, HttpClientTracer.HttpClientSpan span, HttpClientMetrics metrics, HttpClientLogger logger) {
            this.ctx = ctx;
            this.request = request;
            this.data = data;
            this.span = span;
            this.metrics = metrics;
            this.logger = logger;
        }

        @Override
        public HttpClientRequest request() {
            return this.request;
        }

        @Override
        public HttpClientResponse close(@Nullable HttpClientResponse response, @Nullable Throwable exception) {
            Charset responseBodyCharset;
            if (response == null) {
                this.onClose(exception);
                return null;
            }
            ByteBuffer full = response.body().getFullContentIfAvailable();
            if (full != null) {
                this.onClose(response.code(), response.headers(), response.body().contentType(), List.of(full));
                return response;
            }
            Charset charset = responseBodyCharset = this.logger == null || !this.logger.logResponseBody() ? null : DefaultHttpClientTelemetry.this.detectCharset(response.body().contentType());
            if (responseBodyCharset != null) {
                DefaultHttpClientTelemetryCollectingResponseBodyWrapper body = new DefaultHttpClientTelemetryCollectingResponseBodyWrapper(response, this);
                return new DefaultHttpClientTelemetryResponseWrapper(response, body);
            }
            DefaultHttpClientTelemetryResponseBodyWrapper body = new DefaultHttpClientTelemetryResponseBodyWrapper(response, this);
            return new DefaultHttpClientTelemetryResponseWrapper(response, body);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onClose(Throwable throwable) {
            if (this.span != null) {
                this.span.close(-1, throwable);
            }
            long processingTime = System.nanoTime() - this.data.startTime();
            if (this.metrics != null) {
                this.metrics.record(-1, processingTime, this.request.method(), this.data.host(), this.data.scheme(), this.data.target());
            }
            if (this.logger != null && this.logger.logResponse()) {
                try {
                    this.ctx.inject();
                    this.logger.logResponse(this.data.authority(), this.data.operation(), processingTime, null, HttpResultCode.CONNECTION_ERROR, throwable, null, null);
                }
                finally {
                    this.ctx.inject();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onClose(int code, @Nullable HttpHeaders headers, @Nullable String contentType, @Nullable List<ByteBuffer> body) {
            Charset responseBodyCharset;
            Charset charset = responseBodyCharset = this.logger == null || !this.logger.logResponseBody() ? null : DefaultHttpClientTelemetry.this.detectCharset(contentType);
            if (this.span != null) {
                this.span.close(code, null);
            }
            long processingTime = System.nanoTime() - this.data.startTime();
            if (this.metrics != null) {
                this.metrics.record(code, processingTime, this.request.method(), this.data.host(), this.data.scheme(), this.data.target());
            }
            HttpResultCode resultCode = HttpResultCode.fromStatusCode((int)code);
            if (this.logger != null) {
                HttpHeaders headersStr = this.logger.logResponseHeaders() ? headers : null;
                String bodyString = DefaultHttpClientTelemetry.byteBufListToBodyString(body, responseBodyCharset);
                Context ctx = Context.current();
                try {
                    this.ctx.inject();
                    this.logger.logResponse(this.data.authority(), this.data.operation(), processingTime, code, resultCode, null, headersStr, bodyString);
                }
                finally {
                    ctx.inject();
                }
            }
        }
    }
}

