/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common.telemetry;

import jakarta.annotation.Nullable;
import ru.tinkoff.kora.http.client.common.telemetry.DefaultHttpClientTelemetry;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientLogger;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientLoggerFactory;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientMetrics;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientMetricsFactory;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientTelemetry;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientTelemetryFactory;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientTracer;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientTracerFactory;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public final class DefaultHttpClientTelemetryFactory
implements HttpClientTelemetryFactory {
    @Nullable
    private final HttpClientLoggerFactory loggerFactory;
    @Nullable
    private final HttpClientTracerFactory tracingFactory;
    @Nullable
    private final HttpClientMetricsFactory metricsFactory;

    public DefaultHttpClientTelemetryFactory(@Nullable HttpClientLoggerFactory loggerFactory, @Nullable HttpClientTracerFactory tracingFactory, @Nullable HttpClientMetricsFactory metricsFactory) {
        this.loggerFactory = loggerFactory;
        this.tracingFactory = tracingFactory;
        this.metricsFactory = metricsFactory;
    }

    @Override
    @Nullable
    public HttpClientTelemetry get(TelemetryConfig config, String clientName) {
        HttpClientLogger logger;
        HttpClientTracer tracing = this.tracingFactory == null ? null : this.tracingFactory.get(config.tracing(), clientName);
        HttpClientMetrics metrics = this.metricsFactory == null ? null : this.metricsFactory.get(config.metrics(), clientName);
        HttpClientLogger httpClientLogger = logger = this.loggerFactory == null ? null : this.loggerFactory.get(config.logging(), clientName);
        if (tracing == null && metrics == null && logger == null) {
            return null;
        }
        return new DefaultHttpClientTelemetry(tracing, metrics, logger);
    }
}

