/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common.telemetry;

import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponse;
import ru.tinkoff.kora.http.client.common.telemetry.DefaultHttpClientTelemetry;
import ru.tinkoff.kora.http.common.body.HttpBodyInput;

public final class DefaultHttpClientTelemetryResponseBodyWrapper
extends AtomicBoolean
implements HttpBodyInput {
    private final HttpClientResponse response;
    private final DefaultHttpClientTelemetry.DefaultHttpClientTelemetryContextImpl telemetryContext;
    private volatile InputStream is;

    public DefaultHttpClientTelemetryResponseBodyWrapper(HttpClientResponse response, DefaultHttpClientTelemetry.DefaultHttpClientTelemetryContextImpl telemetryContext) {
        this.response = response;
        this.telemetryContext = telemetryContext;
    }

    public long contentLength() {
        return this.response.body().contentLength();
    }

    @Nullable
    public String contentType() {
        return this.response.body().contentType();
    }

    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
        if (!this.compareAndSet(false, true)) {
            throw new IllegalStateException("Body was already subscribed");
        }
        ByteBufferSubscriber s = new ByteBufferSubscriber(this.response, subscriber, this.telemetryContext);
        this.response.body().subscribe((Flow.Subscriber)s);
        subscriber.onSubscribe(s);
    }

    public InputStream asInputStream() {
        InputStream is = this.is;
        if (is != null) {
            return is;
        }
        if (this.compareAndSet(false, true)) {
            this.is = is = new WrappedInputStream(this.telemetryContext, this.response, this.response.body().asInputStream());
            return this.is;
        }
        throw new IllegalStateException("Body was already subscribed");
    }

    public void close() throws IOException {
        if (this.is != null) {
            try {
                this.is.close();
            }
            finally {
                this.response.close();
            }
        } else if (this.compareAndSet(false, true)) {
            this.response.body().subscribe((Flow.Subscriber)new DrainSubscriber(this.response, this.telemetryContext));
        }
    }

    private static class ByteBufferSubscriber
    implements Flow.Subscriber<ByteBuffer>,
    Flow.Subscription {
        private final Flow.Subscriber<? super ByteBuffer> subscriber;
        private final HttpClientResponse response;
        private final DefaultHttpClientTelemetry.DefaultHttpClientTelemetryContextImpl telemetryContext;
        private Flow.Subscription subscription;

        public ByteBufferSubscriber(HttpClientResponse response, Flow.Subscriber<? super ByteBuffer> subscriber, DefaultHttpClientTelemetry.DefaultHttpClientTelemetryContextImpl telemetryContext) {
            this.response = response;
            this.subscriber = subscriber;
            this.telemetryContext = telemetryContext;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.subscription = subscription;
        }

        @Override
        public void onNext(ByteBuffer item) {
            this.subscriber.onNext(item);
        }

        @Override
        public void onError(Throwable throwable) {
            try {
                this.telemetryContext.onClose(throwable);
            }
            finally {
                this.subscriber.onError(throwable);
            }
        }

        @Override
        public void onComplete() {
            try {
                this.telemetryContext.onClose(this.response.code(), this.response.headers(), null, null);
            }
            finally {
                this.subscriber.onComplete();
            }
        }

        @Override
        public void request(long n) {
            this.subscription.request(n);
        }

        @Override
        public void cancel() {
            this.subscription.cancel();
        }
    }

    private static final class WrappedInputStream
    extends InputStream {
        private final InputStream is;
        private final DefaultHttpClientTelemetry.DefaultHttpClientTelemetryContextImpl telemetryContext;
        private final HttpClientResponse response;
        private boolean telemetryClosed;

        public WrappedInputStream(DefaultHttpClientTelemetry.DefaultHttpClientTelemetryContextImpl telemetryContext, HttpClientResponse response, InputStream inputStream) {
            this.is = inputStream;
            this.telemetryContext = telemetryContext;
            this.response = response;
        }

        @Override
        public int read() throws IOException {
            try {
                int b = this.is.read();
                if (b < 0) {
                    this.telemetryClosed = true;
                    this.telemetryContext.onClose(this.response.code(), this.response.headers(), null, null);
                }
                return b;
            }
            catch (IOException e) {
                try {
                    this.telemetryClosed = true;
                    this.telemetryContext.onClose(e);
                }
                catch (Throwable t) {
                    e.addSuppressed(t);
                }
                throw e;
            }
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            try {
                int read = this.is.read(b, off, len);
                if (read < 0) {
                    this.telemetryClosed = true;
                    this.telemetryContext.onClose(this.response.code(), this.response.headers(), null, null);
                }
                return read;
            }
            catch (IOException e) {
                try {
                    this.telemetryClosed = true;
                    this.telemetryContext.onClose(e);
                }
                catch (Throwable t) {
                    e.addSuppressed(t);
                }
                throw e;
            }
        }

        @Override
        public void close() {
            if (!this.telemetryClosed) {
                this.telemetryClosed = true;
                this.telemetryContext.onClose(this.response.code(), this.response.headers(), null, null);
            }
        }
    }

    private static final class DrainSubscriber
    implements Flow.Subscriber<ByteBuffer> {
        private final HttpClientResponse response;
        private final DefaultHttpClientTelemetry.DefaultHttpClientTelemetryContextImpl telemetryContext;

        public DrainSubscriber(HttpClientResponse response, DefaultHttpClientTelemetry.DefaultHttpClientTelemetryContextImpl telemetryContext) {
            this.response = response;
            this.telemetryContext = telemetryContext;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            subscription.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(ByteBuffer item) {
        }

        @Override
        public void onError(Throwable throwable) {
            this.telemetryContext.onClose(throwable);
        }

        @Override
        public void onComplete() {
            this.telemetryContext.onClose(this.response.code(), this.response.headers(), null, null);
        }
    }
}

