/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common.telemetry;

import jakarta.annotation.Nullable;
import java.util.concurrent.CancellationException;
import org.slf4j.Logger;
import org.slf4j.Marker;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientLogger;
import ru.tinkoff.kora.http.common.HttpResultCode;
import ru.tinkoff.kora.http.common.header.HttpHeaders;
import ru.tinkoff.kora.logging.common.arg.StructuredArgument;

public class Sl4fjHttpClientLogger
implements HttpClientLogger {
    private final Logger requestLog;
    private final Logger responseLog;

    public Sl4fjHttpClientLogger(Logger requestLog, Logger responseLog) {
        this.requestLog = requestLog;
        this.responseLog = responseLog;
    }

    @Override
    public boolean logRequest() {
        return this.requestLog.isInfoEnabled();
    }

    @Override
    public boolean logRequestHeaders() {
        return this.requestLog.isDebugEnabled();
    }

    @Override
    public boolean logRequestBody() {
        return this.requestLog.isTraceEnabled();
    }

    @Override
    public boolean logResponse() {
        return this.responseLog.isInfoEnabled();
    }

    @Override
    public boolean logResponseHeaders() {
        return this.responseLog.isDebugEnabled();
    }

    @Override
    public boolean logResponseBody() {
        return this.responseLog.isTraceEnabled();
    }

    @Override
    public void logRequest(String authority, String method, String operation, String resolvedUri, @Nullable HttpHeaders headers, @Nullable String body) {
        Marker marker = StructuredArgument.marker((String)"httpRequest", gen -> {
            gen.writeStartObject();
            gen.writeStringField("authority", authority);
            gen.writeStringField("operation", operation);
            gen.writeEndObject();
        });
        if (this.requestLog.isTraceEnabled() && headers != null && headers.size() > 0 && body != null) {
            String headersString = this.requestHeaderString(headers);
            String bodyStr = this.requestBodyString(body);
            this.requestLog.trace(marker, "HttpClient requesting {}\n{}\n{}", new Object[]{operation, headersString, bodyStr});
        } else if (this.requestLog.isDebugEnabled() && headers != null && headers.size() > 0) {
            String headersString = this.requestHeaderString(headers);
            this.requestLog.debug(marker, "HttpClient requesting {}\n{}", (Object)operation, (Object)headersString);
        } else {
            this.requestLog.info(marker, "HttpClient requesting {}", (Object)operation);
        }
    }

    @Override
    public void logResponse(String authority, String operation, long processingTime, @Nullable Integer statusCode, HttpResultCode resultCode, @Nullable Throwable exception, @Nullable HttpHeaders headers, @Nullable String body) {
        String exceptionTypeString = exception != null ? exception.getClass().getCanonicalName() : (statusCode != null ? null : CancellationException.class.getCanonicalName());
        Marker marker = StructuredArgument.marker((String)"httpResponse", gen -> {
            gen.writeStartObject();
            gen.writeStringField("authority", authority);
            gen.writeStringField("operation", operation);
            gen.writeStringField("resultCode", resultCode.name().toLowerCase());
            gen.writeNumberField("processingTime", processingTime / 1000000L);
            if (statusCode != null) {
                gen.writeFieldName("statusCode");
                gen.writeNumber(statusCode.intValue());
            }
            if (exceptionTypeString != null) {
                gen.writeStringField("exceptionType", exceptionTypeString);
            }
            gen.writeEndObject();
        });
        if (this.responseLog.isTraceEnabled() && headers != null && headers.size() > 0 && body != null) {
            String headersString = this.responseHeaderString(headers);
            String bodyStr = this.responseBodyString(body);
            this.responseLog.trace(marker, "HttpClient received {} from {}\n{}\n{}", new Object[]{statusCode, operation, headersString, bodyStr});
        } else if (this.responseLog.isDebugEnabled() && headers != null && headers.size() > 0) {
            String headersString = this.responseHeaderString(headers);
            this.responseLog.debug(marker, "HttpClient received {} from {}\n{}", new Object[]{statusCode, operation, headersString});
        } else if (statusCode != null) {
            this.responseLog.info(marker, "HttpClient received {} from {}", (Object)statusCode, (Object)operation);
        } else {
            this.responseLog.info(marker, "HttpClient received No HttpResponse from {}", (Object)operation);
        }
    }

    public String responseBodyString(String body) {
        return body;
    }

    public String responseHeaderString(HttpHeaders headers) {
        return HttpHeaders.toString((HttpHeaders)headers);
    }

    public String requestBodyString(String body) {
        return body;
    }

    public String requestHeaderString(HttpHeaders headers) {
        return HttpHeaders.toString((HttpHeaders)headers);
    }
}

