/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.common.cookie;

import jakarta.annotation.Nullable;
import java.text.ParsePosition;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.http.common.cookie.Cookie;
import ru.tinkoff.kora.http.common.cookie.CookieImpl;

public class Cookies {
    private static final Logger logger = LoggerFactory.getLogger(Cookies.class);
    public static final String DOMAIN = "$Domain";
    public static final String VERSION = "$Version";
    public static final String PATH = "$Path";
    private static final String RFC1036_PATTERN = "EEEE, dd-MMM-yy HH:mm:ss z";
    private static final DateTimeFormatter RFC1036_FORMATTER = DateTimeFormatter.ofPattern("EEEE, dd-MMM-yy HH:mm:ss z", Locale.US);
    private static final String ASCITIME_PATTERN = "EEE MMM d HH:mm:ss yyyyy";
    private static final DateTimeFormatter ASCITIME_FORMATTER = DateTimeFormatter.ofPattern("EEE MMM d HH:mm:ss yyyyy", Locale.US);
    private static final String OLD_COOKIE_PATTERN = "EEE, dd-MMM-yyyy HH:mm:ss z";
    private static final DateTimeFormatter OLD_COOKIE_FORMATTER = DateTimeFormatter.ofPattern("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.US);

    private Cookies() {
    }

    public static Cookie parseSetCookieHeader(String headerValue) {
        String key = null;
        CookieImpl cookie = null;
        int state = 0;
        int current = 0;
        block5: for (int i = 0; i < headerValue.length(); ++i) {
            char c = headerValue.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '=') {
                        key = headerValue.substring(current, i);
                        current = i + 1;
                        state = 1;
                        continue block5;
                    }
                    if ((c == ';' || c == ' ') && current == i) {
                        ++current;
                        continue block5;
                    }
                    if (c != ';') continue block5;
                    if (cookie == null) {
                        throw new RuntimeException("Could not parse set cookie header %s".formatted(headerValue));
                    }
                    Cookies.handleValue(cookie, headerValue.substring(current, i), null);
                    current = i + 1;
                    continue block5;
                }
                case 1: {
                    if (c == ';') {
                        if (cookie == null) {
                            cookie = new CookieImpl(key, headerValue.substring(current, i));
                        } else {
                            Cookies.handleValue(cookie, key, headerValue.substring(current, i));
                        }
                        state = 0;
                        current = i + 1;
                        key = null;
                        continue block5;
                    }
                    if (c != '\"' || current != i) continue block5;
                    ++current;
                    state = 2;
                    continue block5;
                }
                case 2: {
                    if (c != '\"') continue block5;
                    if (cookie == null) {
                        cookie = new CookieImpl(key, headerValue.substring(current, i));
                    } else {
                        Cookies.handleValue(cookie, key, headerValue.substring(current, i));
                    }
                    state = 0;
                    current = i + 1;
                    key = null;
                }
            }
        }
        if (key == null) {
            if (current != headerValue.length()) {
                Cookies.handleValue(cookie, headerValue.substring(current, headerValue.length()), null);
            }
        } else if (current != headerValue.length()) {
            if (cookie == null) {
                cookie = new CookieImpl(key, headerValue.substring(current, headerValue.length()));
            } else {
                Cookies.handleValue(cookie, key, headerValue.substring(current, headerValue.length()));
            }
        } else {
            Cookies.handleValue(cookie, key, null);
        }
        return cookie;
    }

    public static String toCookieValue(Cookie cookie) {
        StringBuilder sb = new StringBuilder();
        sb.append(cookie.name()).append("=").append(cookie.value());
        if (cookie.path() != null) {
            sb.append("; Path=").append(cookie.path());
        }
        if (cookie.domain() != null) {
            sb.append("; Domain=").append(cookie.domain());
        }
        if (cookie.maxAge() != null) {
            sb.append("; Max-Age=").append(cookie.maxAge());
        }
        if (cookie.expires() != null) {
            sb.append("; Expires=").append(cookie.expires().format(DateTimeFormatter.RFC_1123_DATE_TIME));
        }
        if (cookie.isSecure()) {
            sb.append("; Secure");
        }
        if (cookie.isHttpOnly()) {
            sb.append("; HttpOnly");
        }
        if (cookie.comment() != null) {
            sb.append("; Comment=").append(cookie.comment());
        }
        if (cookie.isSameSite() && cookie.sameSiteMode() != null) {
            sb.append("; SameSite=").append(cookie.sameSiteMode());
        }
        return sb.toString();
    }

    private static void handleValue(CookieImpl cookie, String key, String value) {
        if (key == null) {
            return;
        }
        if (key.equalsIgnoreCase("path")) {
            cookie.setPath(value);
        } else if (key.equalsIgnoreCase("domain")) {
            cookie.setDomain(value);
        } else if (key.equalsIgnoreCase("max-age")) {
            cookie.setMaxAge(Integer.parseInt(value));
        } else if (key.equalsIgnoreCase("expires")) {
            cookie.setExpires(Cookies.parseDate(value));
        } else if (key.equalsIgnoreCase("discard")) {
            cookie.setDiscard(true);
        } else if (key.equalsIgnoreCase("secure")) {
            cookie.setSecure(true);
        } else if (key.equalsIgnoreCase("httpOnly")) {
            cookie.setHttpOnly(true);
        } else if (key.equalsIgnoreCase("version")) {
            cookie.setVersion(Integer.parseInt(value));
        } else if (key.equalsIgnoreCase("comment")) {
            cookie.setComment(value);
        } else if (key.equalsIgnoreCase("samesite")) {
            cookie.setSameSite(true);
            cookie.setSameSiteMode(value);
        }
    }

    public static void parseRequestCookies(int maxCookies, boolean allowEqualInValue, @Nullable List<String> cookies, Collection<Cookie> parsedCookies) {
        Cookies.parseRequestCookies(maxCookies, allowEqualInValue, cookies, parsedCookies, false);
    }

    static void parseRequestCookies(int maxCookies, boolean allowEqualInValue, @Nullable List<String> cookies, Collection<Cookie> parsedCookies, boolean commaIsSeperator) {
        if (cookies != null) {
            for (String cookie : cookies) {
                Cookies.parseCookie(cookie, parsedCookies, maxCookies, allowEqualInValue, commaIsSeperator);
            }
        }
    }

    private static void parseCookie(String cookie, Collection<Cookie> parsedCookies, int maxCookies, boolean allowEqualInValue, boolean commaIsSeperator) {
        CookieImpl c;
        int state = 0;
        String name = null;
        int start = 0;
        boolean containsEscapedQuotes = false;
        int cookieCount = parsedCookies.size();
        HashMap<String, String> cookies = new HashMap<String, String>();
        HashMap<String, String> additional = new HashMap<String, String>();
        block7: for (int i = 0; i < cookie.length(); ++i) {
            char c2 = cookie.charAt(i);
            switch (state) {
                case 0: {
                    if (c2 == ' ' || c2 == '\t' || c2 == ';') {
                        start = i + 1;
                        continue block7;
                    }
                    state = 1;
                }
                case 1: {
                    if (c2 == '=') {
                        name = cookie.substring(start, i);
                        start = i + 1;
                        state = 2;
                        continue block7;
                    }
                    if (c2 != ';' && (!commaIsSeperator || c2 != ',')) continue block7;
                    if (name != null) {
                        cookieCount = Cookies.createCookie(name, cookie.substring(start, i), maxCookies, cookieCount, cookies, additional);
                    } else if (logger.isTraceEnabled()) {
                        logger.trace("Ignoring invalid cookies in header {}", (Object)cookie);
                    }
                    state = 0;
                    start = i + 1;
                    continue block7;
                }
                case 2: {
                    if (c2 == ';' || commaIsSeperator && c2 == ',') {
                        cookieCount = Cookies.createCookie(name, cookie.substring(start, i), maxCookies, cookieCount, cookies, additional);
                        state = 0;
                        start = i + 1;
                        continue block7;
                    }
                    if (c2 == '\"' && start == i) {
                        containsEscapedQuotes = false;
                        state = 3;
                        start = i + 1;
                        continue block7;
                    }
                    if (c2 != '=' || allowEqualInValue) continue block7;
                    cookieCount = Cookies.createCookie(name, cookie.substring(start, i), maxCookies, cookieCount, cookies, additional);
                    state = 4;
                    start = i + 1;
                    continue block7;
                }
                case 3: {
                    if (c2 == '\"') {
                        cookieCount = Cookies.createCookie(name, containsEscapedQuotes ? Cookies.unescapeDoubleQuotes(cookie.substring(start, i)) : cookie.substring(start, i), maxCookies, cookieCount, cookies, additional);
                        state = 0;
                        start = i + 1;
                    }
                    if (c2 != '\\' || i + 1 >= cookie.length() || cookie.charAt(i + 1) != '\"' || i + 2 == cookie.length() || i + 2 < cookie.length() && (cookie.charAt(i + 2) == ';' || commaIsSeperator && cookie.charAt(i + 2) == ',')) continue block7;
                    ++i;
                    containsEscapedQuotes = true;
                    continue block7;
                }
                case 4: {
                    if (c2 == ';' || commaIsSeperator && c2 == ',') {
                        state = 0;
                    }
                    start = i + 1;
                }
            }
        }
        if (state == 2) {
            Cookies.createCookie(name, cookie.substring(start), maxCookies, cookieCount, cookies, additional);
        }
        for (Map.Entry entry : cookies.entrySet()) {
            String path;
            String version;
            c = new CookieImpl((String)entry.getKey(), (String)entry.getValue());
            String domain = (String)additional.get(DOMAIN);
            if (domain != null) {
                c.setDomain(domain);
            }
            if ((version = (String)additional.get(VERSION)) != null) {
                c.setVersion(Integer.parseInt(version));
            }
            if ((path = (String)additional.get(PATH)) != null) {
                c.setPath(path);
            }
            parsedCookies.add(c);
        }
        for (Map.Entry entry : additional.entrySet()) {
            if (DOMAIN.equals(entry.getKey())) {
                c = new CookieImpl(DOMAIN, (String)entry.getValue());
                parsedCookies.add(c);
                continue;
            }
            if (PATH.equals(entry.getKey())) {
                c = new CookieImpl(PATH, (String)entry.getValue());
                parsedCookies.add(c);
                continue;
            }
            if (!VERSION.equals(entry.getKey())) continue;
            c = new CookieImpl(VERSION, (String)entry.getValue());
            parsedCookies.add(c);
        }
    }

    private static int createCookie(String name, String value, int maxCookies, int cookieCount, Map<String, String> cookies, Map<String, String> additional) {
        if (!name.isEmpty() && name.charAt(0) == '$') {
            if (additional.containsKey(name)) {
                return cookieCount;
            }
            additional.put(name, value);
            return cookieCount;
        }
        if (cookieCount == maxCookies) {
            throw new RuntimeException("The number of cookies sent exceeded the maximum of %d".formatted(maxCookies));
        }
        if (cookies.containsKey(name)) {
            return cookieCount;
        }
        cookies.put(name, value);
        return ++cookieCount;
    }

    private static String unescapeDoubleQuotes(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        char[] tmp = new char[value.length()];
        int dest = 0;
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) == '\\' && i + 1 < value.length() && value.charAt(i + 1) == '\"') {
                ++i;
            }
            tmp[dest] = value.charAt(i);
            ++dest;
        }
        return new String(tmp, 0, dest);
    }

    @Nullable
    private static ZonedDateTime parseDate(String date) {
        ZonedDateTime value2;
        int semicolonIndex = date.indexOf(59);
        String trimmedDate = semicolonIndex >= 0 ? date.substring(0, semicolonIndex) : date;
        ParsePosition pp = new ParsePosition(0);
        try {
            value2 = ZonedDateTime.parse(trimmedDate, DateTimeFormatter.RFC_1123_DATE_TIME);
            if (pp.getIndex() == trimmedDate.length()) {
                return value2;
            }
        }
        catch (DateTimeParseException value2) {
            // empty catch block
        }
        pp.setIndex(0);
        pp.setErrorIndex(-1);
        try {
            value2 = ZonedDateTime.parse(trimmedDate, RFC1036_FORMATTER);
            if (pp.getIndex() == trimmedDate.length()) {
                return value2;
            }
        }
        catch (DateTimeParseException value3) {
            // empty catch block
        }
        pp.setIndex(0);
        pp.setErrorIndex(-1);
        try {
            value2 = ZonedDateTime.parse(trimmedDate, ASCITIME_FORMATTER);
            if (pp.getIndex() == trimmedDate.length()) {
                return value2;
            }
        }
        catch (DateTimeParseException value4) {
            // empty catch block
        }
        pp.setIndex(0);
        pp.setErrorIndex(-1);
        try {
            value2 = ZonedDateTime.parse(trimmedDate, OLD_COOKIE_FORMATTER);
            if (pp.getIndex() == trimmedDate.length()) {
                return value2;
            }
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
        return null;
    }
}

